/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.client.internal;

import io.crysknife.client.SyncBeanDef;
import io.crysknife.client.internal.BeanFactory;
import io.crysknife.client.internal.BeanManagerUtil;
import io.crysknife.client.internal.QualifierUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Typed;
import javax.inject.Named;

public class SyncBeanDefImpl<T>
implements SyncBeanDef<T> {
    private static final List<Annotation> defaultQualifiers = Arrays.asList(QualifierUtil.DEFAULT_QUALIFIERS);
    private final Class<T> actualType;
    private final Class<? extends Annotation> scope;
    private List<Annotation> qualifiers;
    private List<Class<?>> assignableTypes;
    private Optional<BeanFactory<T>> factory = Optional.empty();
    private Optional<Typed> typed = Optional.empty();

    protected SyncBeanDefImpl(Class<T> actualType) {
        this.actualType = actualType;
        this.scope = Dependent.class;
    }

    protected SyncBeanDefImpl(Class<T> actualType, Class<? extends Annotation> scope) {
        this.actualType = actualType;
        this.scope = scope;
    }

    @Override
    public boolean isAssignableTo(Class<?> type) {
        return this.getAssignableTypes().contains(type);
    }

    public Collection<Class<?>> getAssignableTypes() {
        return Collections.unmodifiableCollection(this.assignableTypes);
    }

    @Override
    public Class<T> getType() {
        return this.actualType;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.actualType;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public Collection<Annotation> getQualifiers() {
        HashSet<Annotation> temp = new HashSet<Annotation>(defaultQualifiers);
        if (this.qualifiers != null) {
            temp.addAll(this.qualifiers);
        }
        return Collections.unmodifiableCollection(temp);
    }

    @Override
    public Collection<Annotation> getActualQualifiers() {
        if (this.qualifiers == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.qualifiers);
    }

    @Override
    public Optional<BeanFactory<T>> getFactory() {
        return this.factory;
    }

    @Override
    public boolean matches(Set<Annotation> annotations) {
        return QualifierUtil.matches(annotations, this.getQualifiers());
    }

    @Override
    public String getName() {
        for (Annotation annotation : this.getActualQualifiers()) {
            if (!annotation.annotationType().equals(Named.class)) continue;
            return ((Named)annotation).value();
        }
        return this.actualType.getCanonicalName();
    }

    public String toString() {
        String qualifiers = "";
        if (this.qualifiers != null) {
            qualifiers = BeanManagerUtil.qualifiersToString(this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
        }
        return "[type=" + this.actualType + ", scope=" + this.scope.getSimpleName() + ", qualifiers=" + qualifiers + "]";
    }

    @Override
    public T getInstance() {
        if (!this.factory.isPresent()) {
            BeanManagerUtil.noFactoryResolutionException(this.actualType, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
        }
        return this.factory.get().getInstance();
    }

    @Override
    public T newInstance() {
        if (!this.factory.isPresent()) {
            BeanManagerUtil.noFactoryResolutionException(this.actualType, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
        }
        return this.factory.get().createInstance();
    }

    public Optional<Typed> getTyped() {
        return this.typed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SyncBeanDefImpl)) {
            return false;
        }
        SyncBeanDefImpl that = (SyncBeanDefImpl)o;
        return Objects.equals(this.actualType, that.actualType);
    }

    public int hashCode() {
        return Objects.hash(this.actualType);
    }

    public static class Builder {
        private final Class<?> actualType;
        private final Class<? extends Annotation> scope;
        private List<Annotation> qualifiers;
        private List<Class<?>> assignableTypes;
        private BeanFactory factory;
        private Typed typed;

        public Builder(Class<?> actualType, Class<? extends Annotation> scope) {
            this.actualType = actualType;
            this.scope = scope;
        }

        public Builder withQualifiers(Annotation[] qualifiers) {
            this.qualifiers = Arrays.asList(qualifiers);
            return this;
        }

        public Builder withTyped(Typed typed) {
            this.typed = typed;
            return this;
        }

        public Builder withAssignableTypes(Class<?>[] assignableTypes) {
            this.assignableTypes = Arrays.asList(assignableTypes);
            return this;
        }

        public Builder withFactory(BeanFactory factory) {
            this.factory = factory;
            return this;
        }

        public <T> SyncBeanDefImpl<T> build() {
            SyncBeanDefImpl definition = new SyncBeanDefImpl(this.actualType, this.scope);
            if (this.qualifiers != null) {
                definition.qualifiers = this.qualifiers;
            }
            if (this.assignableTypes != null) {
                definition.assignableTypes = this.assignableTypes;
            }
            if (this.factory != null) {
                this.factory.beanDef = definition;
                definition.factory = Optional.of(this.factory);
            }
            if (this.typed != null) {
                definition.typed = Optional.of(this.typed);
            }
            return definition;
        }
    }
}

