/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.client.internal;

import io.crysknife.client.internal.BeanManagerUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Typed;
import javax.inject.Named;

public class QualifierUtil {
    public static final Annotation DEFAULT_ANNOTATION = new Default(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Default.class;
        }

        @Override
        public String toString() {
            return "@Default";
        }
    };
    public static final Annotation SPECIALIZES_ANNOTATION = new Specializes(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Specializes.class;
        }

        @Override
        public String toString() {
            return "@Specializes";
        }
    };
    public static final Annotation ANY_ANNOTATION = new Any(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return Any.class;
        }

        @Override
        public String toString() {
            return "@Any";
        }
    };
    public static final Annotation[] DEFAULT_QUALIFIERS = new Annotation[]{DEFAULT_ANNOTATION, ANY_ANNOTATION};
    private static final Map<String, Annotation> DEFAULT_MATCHING_MAP = new HashMap<String, Annotation>(){
        {
            for (Annotation a : DEFAULT_QUALIFIERS) {
                this.put(a.annotationType().getName(), a);
            }
        }
    };

    public static boolean isSameType(Annotation a1, Annotation a2) {
        return a1 != null && a2 != null && a1.annotationType().equals(a2.annotationType());
    }

    public static boolean matches(Annotation[] allOf, Annotation[] in) {
        if (in.length == 0) {
            return true;
        }
        return QualifierUtil.contains(Arrays.asList(allOf), Arrays.asList(in));
    }

    public static boolean matches(Collection<Annotation> allOf, Collection<Annotation> in) {
        if (in.isEmpty()) {
            return true;
        }
        return QualifierUtil.contains(allOf, in);
    }

    public static boolean contains(Collection<Annotation> allOf, Collection<Annotation> in) {
        if (allOf.isEmpty()) {
            return true;
        }
        HashMap<String, Annotation> allOfMap = new HashMap<String, Annotation>();
        HashMap<String, Annotation> inMap = new HashMap<String, Annotation>();
        for (Annotation a : in) {
            inMap.put(BeanManagerUtil.qualifierToString(a), a);
        }
        for (Annotation a : allOf) {
            allOfMap.put(BeanManagerUtil.qualifierToString(a), a);
        }
        return inMap.keySet().containsAll(allOfMap.keySet());
    }

    public static boolean isDefaultAnnotations(Annotation[] annotations) {
        return annotations == null || QualifierUtil.isDefaultAnnotations(Arrays.asList(annotations));
    }

    public static boolean isDefaultAnnotations(Collection<Annotation> annotations) {
        return annotations == null || annotations.size() == 2 && QualifierUtil.contains(DEFAULT_MATCHING_MAP.values(), annotations);
    }

    public static Named createNamed(final String name) {
        return new Named(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Named.class;
            }

            @Override
            public String value() {
                return name;
            }
        };
    }

    public static Typed createTyped(final Class ... classes) {
        return new Typed(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Typed.class;
            }

            public Class[] value() {
                return classes;
            }
        };
    }

    public static String print(Annotation[] annotations) {
        return Arrays.stream(annotations).map(e -> e.annotationType().getSimpleName()).collect(Collectors.joining(","));
    }

    public static String print(Collection<Annotation> annotations) {
        return annotations.stream().map(e -> e.annotationType().getSimpleName()).collect(Collectors.joining(","));
    }
}

