/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.client.internal;

import io.crysknife.client.IOCBeanDef;
import io.crysknife.client.internal.IOCResolutionException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import javax.inject.Named;

public class BeanManagerUtil {
    public static <T> IOCResolutionException ambiguousResolutionException(Class<T> type, Collection<IOCBeanDef<T>> resolved, Annotation ... qualifiers) {
        StringBuilder builder = new StringBuilder();
        builder.append("Multiple beans matched " + type.getName() + " with qualifiers {" + BeanManagerUtil.qualifiersToString(qualifiers) + "\n").append("Found:\n");
        for (IOCBeanDef<T> beanDef : resolved) {
            builder.append("  ").append(beanDef.toString()).append("\n");
        }
        builder.append("}");
        IOCResolutionException iocResolutionException = new IOCResolutionException(builder.toString());
        return iocResolutionException;
    }

    public static <T> IOCResolutionException unsatisfiedResolutionException(Class<T> type, Annotation ... qualifiers) {
        return new IOCResolutionException("No beans matched " + type.getName() + " with qualifiers {" + BeanManagerUtil.qualifiersToString(qualifiers) + "}");
    }

    public static <T> IOCResolutionException noFactoryResolutionException(Class<T> type, Annotation ... qualifiers) {
        return new IOCResolutionException("No factory registered for " + type.getName() + " with qualifiers {" + BeanManagerUtil.qualifiersToString(qualifiers) + "}");
    }

    public static String qualifiersToString(Collection<Annotation> qualifiers) {
        return BeanManagerUtil.qualifiersToString(qualifiers.toArray(new Annotation[qualifiers.size()]));
    }

    public static String qualifiersToString(Annotation[] qualifiers) {
        StringBuilder builder = new StringBuilder().append("{ ");
        for (Annotation qualifier : qualifiers) {
            builder.append(BeanManagerUtil.qualifierToString(qualifier));
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public static String qualifierToString(Annotation qualifier) {
        StringBuilder builder = new StringBuilder();
        builder.append(qualifier.annotationType().getName());
        if (qualifier instanceof Named) {
            Named named = (Named)qualifier;
            builder.append("(\"").append(named.value()).append("\")");
        }
        return builder.toString();
    }
}

