/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.client.internal;

import io.crysknife.client.BeanManager;
import io.crysknife.client.SyncBeanDef;
import io.crysknife.client.internal.AbstractBeanManager;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;

public abstract class BeanFactory<T> {
    protected AbstractBeanManager beanManager;
    protected SyncBeanDef beanDef;
    protected T instance;
    private T incompleteInstance;
    private boolean initialized = false;

    protected BeanFactory(BeanManager beanManager) {
        this.beanManager = (AbstractBeanManager)beanManager;
    }

    public T getIncompleteInstance() {
        return this.incompleteInstance;
    }

    protected void setIncompleteInstance(T instance) {
        this.incompleteInstance = instance;
    }

    public abstract <T> T getInstance();

    public void initInstance(T instance) {
        if (this.beanDef.getScope().equals(Dependent.class) || !this.initialized) {
            this.doInitInstance(instance);
            this.initialized = true;
        }
    }

    protected void doInitInstance(T instance) {
    }

    public <T> T createNewInstance() {
        if (this.instance != null) {
            this.createInstance();
        }
        return this.instance;
    }

    protected <T> T createInstance() {
        throw new UnsupportedOperationException("The factory, " + this.getClass().getSimpleName() + ", only supports contextual instances.");
    }

    protected <T> T createInstanceInternal() {
        T instance = this.createInstance();
        return this.addBeanInstanceToPool(instance, this);
    }

    public T createContextualInstance(Class<?>[] typeArgs, Annotation[] qualifiers) {
        throw new UnsupportedOperationException("The factory, " + this.getClass().getSimpleName() + ", does not support contextual instances.");
    }

    protected void onDestroy(T instance) {
    }

    void onDestroyInternal(T instance) {
        this.onDestroy(instance);
        this.instance = null;
        this.initialized = false;
    }

    protected <T> T addBeanInstanceToPool(Object instance, BeanFactory factory) {
        return this.beanManager.addBeanInstanceToPool(instance, factory);
    }
}

