/*
 * Decompiled with CFR 0.152.
 */
package io.crysknife.client.internal;

import io.crysknife.client.BeanManager;
import io.crysknife.client.IOCBeanDef;
import io.crysknife.client.SyncBeanDef;
import io.crysknife.client.internal.BeanFactory;
import io.crysknife.client.internal.BeanManagerUtil;
import io.crysknife.client.internal.QualifierUtil;
import io.crysknife.client.internal.SyncBeanDefImpl;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractBeanManager
implements BeanManager {
    private final Map<Class, BeanDefinitionHolder> beans = new HashMap<Class, BeanDefinitionHolder>();
    private final Map<Object, BeanFactory> pool = new IdentityHashMap<Object, BeanFactory>();
    private final Map<String, Class> beansByBeanName = new HashMap<String, Class>();

    protected AbstractBeanManager() {
    }

    @Override
    public void register(SyncBeanDefImpl beanDefinition) {
        BeanDefinitionHolder holder = this.get(beanDefinition.getType());
        holder.beanDefinition = beanDefinition;
        beanDefinition.getAssignableTypes().forEach(superType -> {
            this.get((Class)superType).subTypes.add(holder);
            this.beansByBeanName.put(((Class)superType).getCanonicalName(), (Class)superType);
        });
        this.beansByBeanName.put(beanDefinition.getName(), beanDefinition.getType());
    }

    private BeanDefinitionHolder get(Class<?> type) {
        if (!this.beans.containsKey(type)) {
            BeanDefinitionHolder holder = new BeanDefinitionHolder();
            this.beans.put(type, holder);
        }
        return this.beans.get(type);
    }

    @Override
    public Collection<SyncBeanDef> lookupBeans(String name) {
        if (this.beansByBeanName.containsKey(name)) {
            return this.lookupBeans(this.beansByBeanName.get(name), new Annotation[0]);
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public <T> Collection<SyncBeanDef<T>> lookupBeans(Class<T> type, Annotation ... qualifiers) {
        HashSet result = new HashSet();
        if (!this.beans.containsKey(type)) {
            return result;
        }
        if (qualifiers.length == 0) {
            if (this.beans.get(type).beanDefinition != null) {
                result.add(this.beans.get(type).beanDefinition);
            }
            this.beans.get(type).subTypes.stream().filter(f -> f.beanDefinition != null).forEach(bean -> result.add(bean.beanDefinition));
            return result;
        }
        if (this.beans.get(type).beanDefinition != null && this.compareAnnotations(this.beans.get(type).beanDefinition.getActualQualifiers(), qualifiers)) {
            result.add(this.beans.get(type).beanDefinition);
        }
        this.beans.get(type).subTypes.stream().filter(f -> f.beanDefinition != null).filter(f -> this.compareAnnotations(f.beanDefinition.getActualQualifiers(), qualifiers)).forEach(bean -> result.add(bean.beanDefinition));
        return result;
    }

    private boolean compareAnnotations(Collection<Annotation> all, Annotation ... in) {
        Annotation[] _all = all.toArray(new Annotation[all.size()]);
        return QualifierUtil.matches(in, _all);
    }

    @Override
    public <T> SyncBeanDef<T> lookupBean(Class<T> type) {
        return this.lookupBean(type, QualifierUtil.DEFAULT_ANNOTATION);
    }

    @Override
    public <T> SyncBeanDef<T> lookupBean(Class<T> type, Annotation ... qualifiers) {
        Collection<IOCBeanDef<T>> candidates = this.doLookupBean(type, qualifiers);
        if (candidates.size() > 1) {
            throw BeanManagerUtil.ambiguousResolutionException(type, candidates, qualifiers);
        }
        if (candidates.isEmpty()) {
            throw BeanManagerUtil.unsatisfiedResolutionException(type, qualifiers);
        }
        return (SyncBeanDef)candidates.iterator().next();
    }

    @Override
    public void destroyBean(Object ref) {
        if (this.pool.containsKey(ref)) {
            this.pool.get(ref).onDestroyInternal(ref);
            this.pool.remove(ref);
        }
    }

    <T> T addBeanInstanceToPool(Object instance, BeanFactory factory) {
        this.pool.put(instance, factory);
        return (T)instance;
    }

    <T> Collection<IOCBeanDef<T>> doLookupBean(Class<T> type, Annotation ... qualifiers) {
        HashSet<IOCBeanDef<T>> candidates;
        block10: {
            candidates = new HashSet<IOCBeanDef<T>>();
            if (!this.beans.containsKey(type)) break block10;
            if (qualifiers == null || qualifiers.length == 0) {
                qualifiers = new Annotation[]{QualifierUtil.DEFAULT_ANNOTATION};
            }
            if (this.beans.get(type).beanDefinition != null) {
                if (this.beans.get(type).beanDefinition.getTyped().isPresent() && Arrays.stream(this.beans.get(type).beanDefinition.getTyped().get().value()).anyMatch(any -> any.equals(type))) {
                    HashSet<IOCBeanDef<T>> result = new HashSet<IOCBeanDef<T>>();
                    result.add(this.beans.get(type).beanDefinition);
                    return result;
                }
                if (this.compareAnnotations(this.beans.get(type).beanDefinition.getQualifiers(), qualifiers) && this.beans.get(type).beanDefinition.getFactory().isPresent()) {
                    candidates.add(this.beans.get(type).beanDefinition);
                }
            }
            if (qualifiers.length == 1 && !this.beans.get(type).subTypes.isEmpty() && this.isDefault(qualifiers)) {
                for (BeanDefinitionHolder subType : this.beans.get(type).subTypes) {
                    if (subType.beanDefinition == null || subType.beanDefinition.getActualQualifiers().isEmpty() || !this.compareAnnotations(subType.beanDefinition.getActualQualifiers(), QualifierUtil.SPECIALIZES_ANNOTATION)) continue;
                    HashSet<IOCBeanDef<T>> result = new HashSet<IOCBeanDef<T>>();
                    result.add(subType.beanDefinition);
                    return result;
                }
                for (BeanDefinitionHolder subType : this.beans.get(type).subTypes) {
                    if (subType.beanDefinition == null || subType.beanDefinition.getActualQualifiers().isEmpty() || !this.compareAnnotations(subType.beanDefinition.getActualQualifiers(), QualifierUtil.DEFAULT_ANNOTATION)) continue;
                    HashSet<IOCBeanDef<T>> result = new HashSet<IOCBeanDef<T>>();
                    result.add(subType.beanDefinition);
                    return result;
                }
                for (BeanDefinitionHolder subType : this.beans.get(type).subTypes) {
                    HashSet<Annotation> annotations = new HashSet<Annotation>();
                    annotations.add(QualifierUtil.DEFAULT_ANNOTATION);
                    if (!this.compareAnnotations(subType.beanDefinition.getActualQualifiers(), qualifiers) || subType.beanDefinition.getTyped().isPresent() || !subType.beanDefinition.getFactory().isPresent()) continue;
                    candidates.add(subType.beanDefinition);
                }
            } else {
                HashSet _qual = new HashSet();
                Collections.addAll(_qual, qualifiers);
                Collections.addAll(_qual, QualifierUtil.DEFAULT_QUALIFIERS);
                _qual.toArray(new Annotation[_qual.size()]);
                for (BeanDefinitionHolder subType : this.beans.get(type).subTypes) {
                    if (!this.compareAnnotations(subType.beanDefinition.getQualifiers(), _qual.toArray(new Annotation[_qual.size()])) || subType.beanDefinition.getTyped().isPresent() && !this.isDefault(subType.beanDefinition.getActualQualifiers()) || !subType.beanDefinition.getFactory().isPresent()) continue;
                    candidates.add(subType.beanDefinition);
                }
            }
        }
        return candidates;
    }

    private boolean isDefault(Collection<Annotation> qualifiers) {
        if (qualifiers.isEmpty()) {
            return false;
        }
        return this.isDefault(qualifiers.toArray(new Annotation[qualifiers.size()]));
    }

    private boolean isDefault(Annotation[] qualifiers) {
        Annotation[] a1 = new Annotation[]{qualifiers[0]};
        Annotation[] a2 = new Annotation[]{QualifierUtil.DEFAULT_ANNOTATION};
        return QualifierUtil.matches(a1, a2);
    }

    private boolean compareAnnotations(Annotation[] all, Annotation[] in) {
        return QualifierUtil.matches(in, all);
    }

    private static class BeanDefinitionHolder {
        SyncBeanDefImpl beanDefinition;
        Set<BeanDefinitionHolder> subTypes = new HashSet<BeanDefinitionHolder>();

        private BeanDefinitionHolder() {
        }
    }
}

