/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.common;

import com.google.auto.common.MoreTypes;
import com.google.auto.common.Overrides;
import com.google.auto.common.Visibility;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;

@Beta
public final class MoreElements {
    public static PackageElement getPackage(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    public static PackageElement asPackage(Element element) {
        return element.accept(PackageElementVisitor.INSTANCE, null);
    }

    public static boolean isType(Element element) {
        return element.getKind().isClass() || element.getKind().isInterface();
    }

    public static TypeElement asType(Element element) {
        return element.accept(TypeElementVisitor.INSTANCE, null);
    }

    public static VariableElement asVariable(Element element) {
        return element.accept(VariableElementVisitor.INSTANCE, null);
    }

    public static ExecutableElement asExecutable(Element element) {
        return element.accept(ExecutableElementVisitor.INSTANCE, null);
    }

    public static boolean isAnnotationPresent(Element element, Class<? extends Annotation> annotationClass) {
        return MoreElements.getAnnotationMirror(element, annotationClass).isPresent();
    }

    public static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationTypeElement = MoreElements.asType(annotationMirror.getAnnotationType().asElement());
            if (!annotationTypeElement.getQualifiedName().contentEquals(annotationClassName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.absent();
    }

    public static <T extends Element> Predicate<T> hasModifiers(Modifier ... modifiers) {
        return MoreElements.hasModifiers(ImmutableSet.copyOf(modifiers));
    }

    public static <T extends Element> Predicate<T> hasModifiers(final Set<Modifier> modifiers) {
        return new Predicate<T>(){

            @Override
            public boolean apply(T input) {
                return input.getModifiers().containsAll(modifiers);
            }
        };
    }

    @Deprecated
    public static ImmutableSet<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Elements elementUtils) {
        Overrides.NativeOverrides overrides = new Overrides.NativeOverrides(elementUtils);
        return MoreElements.getLocalAndInheritedMethods(type, overrides);
    }

    public static ImmutableSet<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Types typeUtils, Elements elementUtils) {
        Overrides.ExplicitOverrides overrides = new Overrides.ExplicitOverrides(typeUtils);
        return MoreElements.getLocalAndInheritedMethods(type, overrides);
    }

    private static ImmutableSet<ExecutableElement> getLocalAndInheritedMethods(TypeElement type, Overrides overrides) {
        LinkedHashMultimap<String, ExecutableElement> methodMap = LinkedHashMultimap.create();
        MoreElements.getLocalAndInheritedMethods(MoreElements.getPackage(type), type, methodMap);
        LinkedHashSet<ExecutableElement> overridden = new LinkedHashSet<ExecutableElement>();
        for (Collection methods : methodMap.asMap().values()) {
            ImmutableList methodList = ImmutableList.copyOf(methods);
            for (int i = 0; i < methodList.size(); ++i) {
                ExecutableElement methodI = (ExecutableElement)methodList.get(i);
                for (int j = i + 1; j < methodList.size(); ++j) {
                    ExecutableElement methodJ = (ExecutableElement)methodList.get(j);
                    if (!overrides.overrides(methodJ, methodI, type)) continue;
                    overridden.add(methodI);
                }
            }
        }
        LinkedHashSet methods = new LinkedHashSet(methodMap.values());
        methods.removeAll(overridden);
        return ImmutableSet.copyOf(methods);
    }

    private static void getLocalAndInheritedMethods(PackageElement pkg, TypeElement type, SetMultimap<String, ExecutableElement> methods) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            MoreElements.getLocalAndInheritedMethods(pkg, MoreTypes.asTypeElement(typeMirror), methods);
        }
        if (type.getSuperclass().getKind() != TypeKind.NONE) {
            MoreElements.getLocalAndInheritedMethods(pkg, MoreTypes.asTypeElement(type.getSuperclass()), methods);
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (executableElement.getModifiers().contains((Object)Modifier.STATIC) || !MoreElements.methodVisibleFromPackage(executableElement, pkg)) continue;
            methods.put(executableElement.getSimpleName().toString(), executableElement);
        }
    }

    static boolean methodVisibleFromPackage(ExecutableElement method, PackageElement pkg) {
        Visibility visibility = Visibility.ofElement(method);
        switch (visibility) {
            case PRIVATE: {
                return false;
            }
            case DEFAULT: {
                return MoreElements.getPackage(method).equals(pkg);
            }
        }
        return true;
    }

    private MoreElements() {
    }

    private static abstract class CastingElementVisitor<T>
    extends SimpleElementVisitor6<T, Void> {
        private final String label;

        CastingElementVisitor(String label) {
            this.label = label;
        }

        @Override
        protected final T defaultAction(Element e, Void ignore) {
            throw new IllegalArgumentException(e + " does not represent a " + this.label);
        }
    }

    private static final class ExecutableElementVisitor
    extends CastingElementVisitor<ExecutableElement> {
        private static final ExecutableElementVisitor INSTANCE = new ExecutableElementVisitor();

        ExecutableElementVisitor() {
            super("executable element");
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement e, Void label) {
            return e;
        }
    }

    private static final class VariableElementVisitor
    extends CastingElementVisitor<VariableElement> {
        private static final VariableElementVisitor INSTANCE = new VariableElementVisitor();

        VariableElementVisitor() {
            super("variable element");
        }

        @Override
        public VariableElement visitVariable(VariableElement e, Void ignore) {
            return e;
        }
    }

    private static final class TypeElementVisitor
    extends CastingElementVisitor<TypeElement> {
        private static final TypeElementVisitor INSTANCE = new TypeElementVisitor();

        TypeElementVisitor() {
            super("type element");
        }

        @Override
        public TypeElement visitType(TypeElement e, Void ignore) {
            return e;
        }
    }

    private static final class PackageElementVisitor
    extends CastingElementVisitor<PackageElement> {
        private static final PackageElementVisitor INSTANCE = new PackageElementVisitor();

        PackageElementVisitor() {
            super("package element");
        }

        @Override
        public PackageElement visitPackage(PackageElement e, Void ignore) {
            return e;
        }
    }
}

