/*
 * Decompiled with CFR 0.152.
 */
package io.cryptocontrol.cryptonewsapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cryptocontrol.cryptonewsapi.models.Article;
import io.cryptocontrol.cryptonewsapi.models.CategoryResponse;
import io.cryptocontrol.cryptonewsapi.models.Feed;
import io.cryptocontrol.cryptonewsapi.models.RedditPost;
import io.cryptocontrol.cryptonewsapi.models.Tweet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class CryptoControlApi {
    private final String apiKey;
    private final String USER_AGENT = "CryptoControl Java API v1.1.0";
    private final String HOST = "https://cryptocontrol.io/api/v1/public";
    private final Gson gson = new GsonBuilder().create();

    public CryptoControlApi(String apiKey) {
        if (apiKey == null) {
            throw new Error("No API key found. Register for an API key at https://cryptocontrol.io/apis");
        }
        this.apiKey = apiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(String path, OnResponseHandler callback, Type TypeofT) {
        String jsonStr = "";
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL("https://cryptocontrol.io/api/v1/public" + path);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("x-api-key", this.apiKey);
            urlConnection.setRequestProperty("user-agent", "CryptoControl Java API v1.1.0");
            int code = urlConnection.getResponseCode();
            switch (code) {
                case 200: {
                    break;
                }
                case 401: {
                    throw new Exception("Invalid API Key");
                }
                default: {
                    throw new Exception("Bad response from the CryptoControl server");
                }
            }
            BufferedInputStream in = new BufferedInputStream(urlConnection.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                jsonStr = jsonStr + line;
            }
            ((InputStream)in).close();
            callback.onSuccess(this.gson.fromJson(jsonStr, TypeofT));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public void getTopNews(OnResponseHandler<List<Article>> callback) {
        this.fetch("/news", callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getLatestNews(OnResponseHandler<List<Article>> callback) {
        this.fetch("/news?latest=true", callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getTopNewsByCategory(OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/category", callback, (Type)((Object)CategoryResponse.class));
    }

    public void getTopNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName, callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getLatestNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName + "?latest=true", callback, (Type)((Object)Article.ArticleList.class));
    }

    public void getTopNewsByCoinCategory(String coinName, OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/coin/" + coinName + "/category", callback, (Type)((Object)CategoryResponse.class));
    }

    public void getTopRedditPostsByCoin(String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.fetch("/reddit/coin/" + coinName, callback, (Type)((Object)RedditPost.RedditPostList.class));
    }

    public void getLatestRedditPostsByCoin(String coinName, OnResponseHandler<List<RedditPost>> callback) {
        this.fetch("/reddit/coin/" + coinName + "?latest=true", callback, (Type)((Object)RedditPost.RedditPostList.class));
    }

    public void getTopTweetsByCoin(String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.fetch("/tweets/coin/" + coinName, callback, (Type)((Object)Tweet.TweetList.class));
    }

    public void getLatestTweetsByCoin(String coinName, OnResponseHandler<List<Tweet>> callback) {
        this.fetch("/tweets/coin/" + coinName + "?latest=true", callback, (Type)((Object)Tweet.TweetList.class));
    }

    public void getTopFeedByCoin(String coinName, OnResponseHandler<List<Feed>> callback) {
        this.fetch("/feed/coin/" + coinName, callback, (Type)((Object)Feed.FeedList.class));
    }

    public void getLatestFeedByCoin(String coinName, OnResponseHandler<List<Feed>> callback) {
        this.fetch("/feed/coin/" + coinName + "?latest=true", callback, (Type)((Object)Feed.FeedList.class));
    }

    public static interface OnResponseHandler<T> {
        public void onSuccess(T var1);

        public void onFailure(Exception var1);
    }
}

