/*
 * Decompiled with CFR 0.152.
 */
package io.cryptocontrol.cryptonewsapi;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cryptocontrol.cryptonewsapi.Article;
import io.cryptocontrol.cryptonewsapi.Articles;
import io.cryptocontrol.cryptonewsapi.CategoryResponse;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class CryptoControlApi {
    private final String apiKey;
    private final String USER_AGENT = "CryptoControl Java API";
    private final String HOST = "https://cryptocontrol.io/api/v1/public";
    private final Gson gson = new GsonBuilder().create();

    public CryptoControlApi(String apiKey) {
        if (apiKey == null) {
            throw new Error("No API key found. Register for an API key at https://cryptocontrol.io/apis");
        }
        this.apiKey = apiKey;
    }

    private void fetch(String url, OnResponseHandler callback, Type TypeofT) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionTimeToLive(5000L, TimeUnit.MILLISECONDS).disableCookieManagement().build();
        HttpGet request = new HttpGet("https://cryptocontrol.io/api/v1/public" + url);
        request.addHeader("x-api-key", this.apiKey);
        request.addHeader("user-agent", "CryptoControl Java API");
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    break;
                }
                case 401: {
                    throw new Exception("Invalid API Key");
                }
                default: {
                    throw new Exception("Bad response from the CryptoControl server");
                }
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            callback.onSuccess(this.gson.fromJson(json, TypeofT));
        }
        catch (Exception e) {
            callback.onFailure(e);
        }
    }

    public void getTopNews(OnResponseHandler<List<Article>> callback) {
        this.fetch("/news", callback, (Type)((Object)Articles.class));
    }

    public void getLatestNews(OnResponseHandler<List<Article>> callback) {
        this.fetch("/news?latest=true", callback, (Type)((Object)Articles.class));
    }

    public void getTopNewsByCategory(OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/category", callback, (Type)((Object)CategoryResponse.class));
    }

    public void getTopNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName, callback, (Type)((Object)Articles.class));
    }

    public void getLatestNewsByCoin(String coinName, OnResponseHandler<List<Article>> callback) {
        this.fetch("/news/coin/" + coinName + "?latest=true", callback, (Type)((Object)Articles.class));
    }

    public void getTopNewsByCoinCategory(String coinName, OnResponseHandler<CategoryResponse> callback) {
        this.fetch("/news/coin/" + coinName + "/category", callback, (Type)((Object)CategoryResponse.class));
    }

    public static interface OnResponseHandler<T> {
        public void onSuccess(T var1);

        public void onFailure(Exception var1);
    }
}

