/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.transports;

import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.serializers.CBORSerializer;
import io.crossbar.autobahn.wamp.serializers.JSONSerializer;
import io.crossbar.autobahn.wamp.serializers.MessagePackSerializer;
import io.crossbar.autobahn.wamp.types.CloseDetails;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;

public class NettyWebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private static final IABLogger LOGGER = ABLogger.getLogger(NettyWebSocketClientHandler.class.getName());
    private final WebSocketClientHandshaker mHandshaker;
    private final ITransport mTransport;
    private ChannelPromise mHandshakeFuture;
    private ITransportHandler mTransportHandler;
    private boolean mWasCleanClose;
    private CloseDetails mCloseDetails;

    NettyWebSocketClientHandler(WebSocketClientHandshaker handshaker, ITransport transport, ITransportHandler transportHandler) {
        this.mHandshaker = handshaker;
        this.mTransport = transport;
        this.mTransportHandler = transportHandler;
    }

    ChannelFuture getHandshakeFuture() {
        return this.mHandshakeFuture;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.mHandshakeFuture = ctx.newPromise();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.mHandshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        LOGGER.i("WebSocket Client disconnected!");
        if (this.mCloseDetails == null) {
            this.mCloseDetails = new CloseDetails("wamp.close.transport_lost", null);
        }
        this.mTransportHandler.onLeave(this.mCloseDetails);
        this.mTransportHandler.onDisconnect(this.mWasCleanClose);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel ch = ctx.channel();
        if (!this.mHandshaker.isHandshakeComplete()) {
            FullHttpResponse response = (FullHttpResponse)msg;
            String negotiatedSerializer = response.headers().get("Sec-WebSocket-Protocol");
            LOGGER.d(String.format("Negotiated serializer=%s", negotiatedSerializer));
            ISerializer serializer = this.initializeSerializer(negotiatedSerializer);
            this.mHandshaker.finishHandshake(ch, response);
            this.mHandshakeFuture.setSuccess();
            this.mTransportHandler.onConnect(this.mTransport, serializer);
        } else {
            if (msg instanceof FullHttpResponse) {
                FullHttpResponse response = (FullHttpResponse)msg;
                throw new IllegalStateException("Unexpected FullHttpResponse (getStatus=" + response.status() + ", content=" + response.content().toString(CharsetUtil.UTF_8) + ')');
            }
            if (msg instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)msg;
                byte[] payload = new byte[binaryWebSocketFrame.content().readableBytes()];
                LOGGER.v(String.format("Received binary frame, content length=%s", payload.length));
                binaryWebSocketFrame.content().readBytes(payload);
                this.mTransportHandler.onMessage(payload, true);
            } else if (msg instanceof TextWebSocketFrame) {
                TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)msg;
                byte[] payload = new byte[textWebSocketFrame.content().readableBytes()];
                LOGGER.v(String.format("Received Text frame, content length=%s", payload.length));
                textWebSocketFrame.content().readBytes(payload);
                this.mTransportHandler.onMessage(payload, false);
            } else if (msg instanceof PingWebSocketFrame) {
                PingWebSocketFrame pingWebSocketFrame = (PingWebSocketFrame)msg;
                ctx.writeAndFlush((Object)new PongWebSocketFrame(pingWebSocketFrame.content().retain()));
            } else if (msg instanceof PongWebSocketFrame) {
                LOGGER.v("WebSocket Client received pong.");
            } else if (msg instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)msg;
                LOGGER.d(String.format("Received Close frame, code=%s, reason=%s", closeWebSocketFrame.statusCode(), closeWebSocketFrame.reasonText()));
                this.close(ctx, closeWebSocketFrame.statusCode() == 1000, new CloseDetails("wamp.close.normal", null));
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                this.close(ctx, false, new CloseDetails("wamp.close.transport_lost", null));
            } else if (event.state() == IdleState.WRITER_IDLE) {
                ctx.writeAndFlush((Object)new PingWebSocketFrame());
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.mHandshakeFuture.isDone()) {
            this.mHandshakeFuture.setFailure(cause);
        }
        this.close(ctx, false, new CloseDetails("wamp.close.transport_lost", null));
    }

    private void close(ChannelHandlerContext context, boolean wasClean, CloseDetails details) {
        context.close();
        this.mWasCleanClose = wasClean;
        this.mCloseDetails = details;
    }

    void close(Channel channel, boolean wasClean, CloseDetails details) {
        channel.close();
        this.mWasCleanClose = wasClean;
        this.mCloseDetails = details;
    }

    private ISerializer initializeSerializer(String negotiatedSerializer) throws Exception {
        switch (negotiatedSerializer) {
            case "wamp.2.cbor": {
                return new CBORSerializer();
            }
            case "wamp.2.json": {
                return new JSONSerializer();
            }
            case "wamp.2.msgpack": {
                return new MessagePackSerializer();
            }
        }
        throw new IllegalArgumentException("Unsupported serializer.");
    }
}

