/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.interfaces;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import java.io.IOException;
import java.util.List;

public abstract class ISerializer {
    private static final IABLogger LOGGER = ABLogger.getLogger(ISerializer.class.getName());
    public final ObjectMapper mapper;

    public ISerializer(JsonFactory factor) {
        this.mapper = new ObjectMapper(factor);
    }

    public byte[] serialize(List<Object> message) {
        try {
            return this.mapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            LOGGER.v(e.getMessage(), e);
            return null;
        }
    }

    public List<Object> unserialize(byte[] payload, boolean isBinary) {
        try {
            return (List)this.mapper.readValue(payload, (TypeReference)new TypeReference<List<Object>>(){});
        }
        catch (IOException e) {
            LOGGER.v(e.getMessage(), e);
            return null;
        }
    }

    public <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)this.mapper.convertValue(fromValue, toValueTypeRef);
    }

    public <T> T convertValue(Object fromValue, Class<T> toValueTypeClass) {
        return (T)this.mapper.convertValue(fromValue, toValueTypeClass);
    }

    public boolean isBinary() {
        return true;
    }
}

