/*
 * Decompiled with CFR 0.152.
 */
package xbr.network;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.exceptions.ApplicationError;
import io.crossbar.autobahn.wamp.types.CallOptions;
import io.crossbar.autobahn.wamp.types.CallResult;
import io.crossbar.autobahn.wamp.types.InvocationDetails;
import io.crossbar.autobahn.wamp.types.InvocationResult;
import io.crossbar.autobahn.wamp.types.Registration;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.json.JSONException;
import org.libsodium.jni.crypto.Random;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.utils.Numeric;
import xbr.network.KeySeries;
import xbr.network.Util;

public class SimpleSeller {
    private static final int STATE_NONE = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_STOPPING = 3;
    private static final int STATE_STOPPED = 4;
    private final ECKeyPair mECKey;
    private final byte[] mMarketMakerAddr;
    private final byte[] mAddr;
    private int mState = 0;
    private HashMap<String, KeySeries> mKeys;
    private HashMap<String, KeySeries> mKeysMap;
    private Session mSession;
    private List<Registration> mSessionRegs;
    private boolean mRunning;
    private BigInteger mBalance;
    private int mSeq;
    private HashMap<String, Object> mChannel;
    private HashMap<String, Object> mPayingBalance;

    private SimpleSeller(byte[] marketMakerAddr, byte[] sellerKey) {
        this.mMarketMakerAddr = marketMakerAddr;
        this.mECKey = ECKeyPair.create((byte[])sellerKey);
        this.mAddr = Numeric.hexStringToByteArray((String)Keys.getAddress((ECKeyPair)this.mECKey));
        this.mKeys = new HashMap();
        this.mKeysMap = new HashMap();
        this.mSessionRegs = new ArrayList<Registration>();
    }

    public SimpleSeller(String marketMakerAddr, String sellerKey) {
        this(Numeric.hexStringToByteArray((String)marketMakerAddr), Numeric.hexStringToByteArray((String)sellerKey));
    }

    public byte[] getPublicKey() {
        return this.mECKey.getPublicKey().toByteArray();
    }

    private void onRotate(KeySeries series) {
        this.mKeysMap.put(Numeric.toHexString((byte[])series.getID()), series);
        long validFrom = Math.round((double)System.nanoTime() - 10.0 * Math.pow(10.0, 9.0));
        byte[] signature = new Random().randomBytes(65);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(series.getID());
        args.add(series.getAPIID());
        args.add(series.getPrefix());
        args.add(validFrom);
        args.add(this.mAddr);
        args.add(signature);
        HashMap<String, Object> kwargs = new HashMap<String, Object>();
        kwargs.put("price", series.getPrice());
        kwargs.put("provider_id", Numeric.toHexStringWithPrefix((BigInteger)this.mECKey.getPublicKey()));
        CompletableFuture<CallResult> future = this.mSession.call("xbr.marketmaker.place_offer", args, kwargs, new CallOptions(1000));
        future.whenComplete((callResult, throwable) -> {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                System.out.println("Offer placed...");
            }
        });
    }

    public void add(byte[] apiID, String prefix, BigInteger price, int interval) {
        this.mKeys.put(Numeric.toHexString((byte[])apiID), new KeySeries(apiID, price, interval, prefix, this::onRotate));
    }

    public CompletableFuture<BigInteger> start(Session session) {
        CompletableFuture<BigInteger> future = new CompletableFuture<BigInteger>();
        this.mState = 1;
        this.mSession = session;
        String provider = Numeric.toHexStringWithPrefix((BigInteger)this.mECKey.getPublicKey());
        String procedureSell = String.format("xbr.provider.%s.sell", provider);
        ((CompletableFuture)this.mSession.register(procedureSell, this::sell).thenAccept(registration -> this.mSessionRegs.add((Registration)registration))).exceptionally(throwable -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        String procedureCloseChannel = String.format("xbr.provider.%s.close_channel", provider);
        ((CompletableFuture)this.mSession.register(procedureCloseChannel, this::closeChannel).thenAccept(registration -> this.mSessionRegs.add((Registration)registration))).exceptionally(throwable -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        for (KeySeries series : this.mKeys.values()) {
            series.start();
        }
        ((CompletableFuture)((CompletableFuture)this.mSession.call("xbr.marketmaker.get_active_paying_channel", new TypeReference<HashMap<String, Object>>(){}, new Object[]{this.mAddr}).thenCompose(channel -> {
            this.mChannel = channel;
            return this.mSession.call("xbr.marketmaker.get_paying_channel_balance", new TypeReference<HashMap<String, Object>>(){}, channel.get("channel"));
        })).thenAccept(payingBalance -> {
            this.mSeq = (Integer)payingBalance.get("seq");
            this.mBalance = new BigInteger((byte[])payingBalance.get("remaining"));
            BigInteger bi = new BigInteger("10").pow(18);
            System.out.println(this.mBalance.divide(bi));
            this.mState = 2;
            future.complete(this.mBalance);
        })).exceptionally(throwable -> {
            future.completeExceptionally((Throwable)throwable);
            return null;
        });
        return future;
    }

    public InvocationResult sell(List<Object> args, Map<String, Object> kwargs, InvocationDetails details) {
        String marketMakerAddr = Numeric.toHexString((byte[])((byte[])args.get(0)));
        byte[] buyerPubKey = (byte[])args.get(1);
        byte[] keyIDRaw = (byte[])args.get(2);
        String keyID = Numeric.toHexString((byte[])keyIDRaw);
        byte[] channelAddrRaw = (byte[])args.get(3);
        String channelAddr = Numeric.toHexString((byte[])channelAddrRaw);
        int channelSeq = (Integer)args.get(4);
        byte[] amountRaw = (byte[])args.get(5);
        BigInteger amount = new BigInteger(amountRaw);
        byte[] balanceRaw = (byte[])args.get(6);
        BigInteger balance = new BigInteger(balanceRaw);
        byte[] signature = (byte[])args.get(7);
        if (!marketMakerAddr.equals(Numeric.toHexString((byte[])this.mMarketMakerAddr))) {
            throw new ApplicationError("xbr.error.unexpected_marketmaker_adr");
        }
        if (!this.mKeysMap.containsKey(keyID)) {
            throw new ApplicationError("crossbar.error.no_such_object");
        }
        String signerAddr = Util.recoverEIP712Signer(channelAddrRaw, channelSeq, balance, false, signature);
        if (!signerAddr.equals(marketMakerAddr)) {
            throw new ApplicationError("xbr.error.invalid_signature");
        }
        ++this.mSeq;
        this.mBalance = this.mBalance.subtract(amount);
        KeySeries series = this.mKeysMap.get(keyID);
        byte[] sealedKey = series.encryptKey(keyIDRaw, buyerPubKey);
        HashMap<String, Object> receipt = new HashMap<String, Object>();
        receipt.put("key_id", keyIDRaw);
        receipt.put("delegate", this.mAddr);
        receipt.put("buyer_pubkey", buyerPubKey);
        receipt.put("sealed_key", sealedKey);
        receipt.put("channel_seq", this.mSeq);
        receipt.put("amount", amountRaw);
        receipt.put("balance", this.mBalance.toByteArray());
        try {
            byte[] sellerSignature = Util.signEIP712Data(this.mECKey, (byte[])this.mChannel.get("channel"), this.mSeq, this.mBalance, false);
            receipt.put("signature", sellerSignature);
        }
        catch (IOException | JSONException e) {
            e.printStackTrace();
        }
        return new InvocationResult(receipt);
    }

    public String closeChannel(List<Object> args, Map<String, Object> kwargs, InvocationDetails details) {
        System.out.println(args);
        System.out.println(kwargs);
        return null;
    }

    public Map<String, Object> wrap(byte[] apiID, String uri, Map<String, Object> payload) throws JsonProcessingException {
        KeySeries series = this.mKeys.get(Numeric.toHexString((byte[])apiID));
        return series.encrypt(payload);
    }
}

