/*
 * Decompiled with CFR 0.152.
 */
package xbr.network;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.exceptions.ApplicationError;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.json.JSONException;
import org.libsodium.jni.NaCl;
import org.libsodium.jni.Sodium;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.utils.Numeric;
import xbr.network.Util;
import xbr.network.crypto.SealedBox;
import xbr.network.crypto.SecretBox;

public class SimpleBuyer {
    private final byte[] mEthPrivateKey;
    private final byte[] mEthPublicKey;
    private final byte[] mEthAddr;
    private final byte[] mMarketMakerAddr;
    private final BigInteger mMaxPrice;
    private final ECKeyPair mECKey;
    private HashMap<byte[], SecretBox> mKeys;
    private Session mSession;
    private boolean mRunning;
    private int mSeq;
    private BigInteger mRemainingBalance;
    private HashMap<String, Object> mChannel;
    private final byte[] mPrivateKey;
    private final byte[] mPublicKey;

    public SimpleBuyer(String marketMakerAddr, String buyerKey, BigInteger maxPrice) {
        this.mECKey = ECKeyPair.create((byte[])Numeric.hexStringToByteArray((String)buyerKey));
        this.mMarketMakerAddr = Numeric.hexStringToByteArray((String)marketMakerAddr);
        this.mEthPrivateKey = this.mECKey.getPrivateKey().toByteArray();
        this.mEthPublicKey = this.mECKey.getPublicKey().toByteArray();
        this.mEthAddr = Numeric.hexStringToByteArray((String)Credentials.create((ECKeyPair)this.mECKey).getAddress());
        this.mPrivateKey = new byte[32];
        this.mPublicKey = new byte[32];
        NaCl.sodium();
        Sodium.crypto_box_keypair((byte[])this.mPublicKey, (byte[])this.mPrivateKey);
        this.mMaxPrice = maxPrice;
        this.mKeys = new HashMap();
    }

    private boolean isConnected() {
        return this.mSession != null && this.mSession.isConnected();
    }

    public CompletableFuture<BigInteger> start(Session session, String consumerID) {
        CompletableFuture<BigInteger> future = new CompletableFuture<BigInteger>();
        if (this.mRunning) {
            future.completeExceptionally(new IllegalStateException("Already running..."));
            return future;
        }
        this.mSession = session;
        this.mRunning = true;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.mEthAddr);
        CompletableFuture<HashMap<String, Object>> payChannelF = this.mSession.call("xbr.marketmaker.get_active_payment_channel", args, new TypeReference<HashMap<String, Object>>(){});
        payChannelF.whenComplete((channel, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                this.mChannel = channel;
                this.balance().whenComplete((balance, throwable1) -> {
                    if (throwable1 != null) {
                        future.completeExceptionally((Throwable)throwable1);
                    } else {
                        future.complete((BigInteger)balance.get("remaining"));
                    }
                });
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> stop() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (!this.mRunning) {
            future.completeExceptionally(new IllegalStateException("Already stopped..."));
            return future;
        }
        this.mRunning = false;
        return CompletableFuture.completedFuture(false);
    }

    public CompletableFuture<HashMap<String, Object>> balance() {
        CompletableFuture<HashMap<String, Object>> future = new CompletableFuture<HashMap<String, Object>>();
        if (!this.isConnected()) {
            future.completeExceptionally(new IllegalStateException("Session not connected"));
            return future;
        }
        CompletableFuture<HashMap<String, Object>> balanceFuture = this.mSession.call("xbr.marketmaker.get_payment_channel_balance", new TypeReference<HashMap<String, Object>>(){}, this.mChannel.get("channel"));
        balanceFuture.whenComplete((paymentBalance, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                this.mRemainingBalance = new BigInteger((byte[])paymentBalance.get("remaining"));
                HashMap res = new HashMap();
                res.put("amount", paymentBalance.get("amount"));
                res.put("remaining", this.mRemainingBalance);
                res.put("inflight", paymentBalance.get("inflight"));
                this.mSeq = (Integer)paymentBalance.get("seq");
                future.complete(res);
            }
        });
        return future;
    }

    public CompletableFuture<HashMap<String, Object>> openChannel(byte[] buyerAddr, BigInteger amount) {
        CompletableFuture<HashMap<String, Object>> future = new CompletableFuture<HashMap<String, Object>>();
        if (!this.isConnected()) {
            future.completeExceptionally(new IllegalStateException("Session not connected"));
            return future;
        }
        CompletableFuture<HashMap<String, Object>> callFuture = this.mSession.call("xbr.marketmaker.open_payment_channel", new TypeReference<HashMap<String, Object>>(){}, new Object[]{buyerAddr, this.mEthAddr, amount, new SecureRandom(new byte[64])});
        callFuture.whenComplete((paymentChannel, throwable) -> {
            if (throwable != null) {
                future.completeExceptionally((Throwable)throwable);
            } else {
                BigInteger remaining = new BigInteger((byte[])paymentChannel.get("remaining"));
                HashMap res = new HashMap();
                res.put("amount", paymentChannel.get("amount"));
                res.put("remaining", remaining);
                res.put("inflight", paymentChannel.get("inflight"));
                future.complete(res);
            }
        });
        return future;
    }

    public void closeChannel() {
    }

    public CompletableFuture<Object> unwrap(byte[] keyID, String encSerializer, byte[] ciphertext) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        byte[] channelAddr = (byte[])this.mChannel.get("channel");
        if (!this.mKeys.containsKey(keyID)) {
            CompletableFuture<HashMap<String, Object>> quoteF = this.mSession.call("xbr.marketmaker.get_quote", new TypeReference<HashMap<String, Object>>(){}, new Object[]{keyID});
            quoteF.whenComplete((quote, throwable) -> {
                BigInteger price = Util.toXBR((byte[])quote.get("price"));
                if (this.mRemainingBalance.compareTo(price) > 0) {
                    int channelSeq = this.mSeq + 1;
                    boolean isFinal = false;
                    try {
                        byte[] signature = Util.signEIP712Data(this.mECKey, channelAddr, channelSeq, this.mRemainingBalance.subtract(price), isFinal);
                        BigInteger remainingPost = this.mRemainingBalance.subtract(price);
                        this.buyKey(keyID, channelAddr, channelSeq, price, remainingPost, signature, ciphertext, future);
                    }
                    catch (IOException | JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            future.completeExceptionally(new ApplicationError("xbr.error.insufficient_balance"));
        }
        return future;
    }

    private void buyKey(byte[] keyID, byte[] channelAddr, int channelSeq, BigInteger price, BigInteger balance, byte[] signature, byte[] ciphertext, CompletableFuture<Object> future) {
        CompletableFuture<HashMap<String, Object>> keyF = this.mSession.call("xbr.marketmaker.buy_key", new TypeReference<HashMap<String, Object>>(){}, new Object[]{this.mEthAddr, this.mPublicKey, keyID, channelAddr, channelSeq, Numeric.toBytesPadded((BigInteger)price, (int)32), Numeric.toBytesPadded((BigInteger)balance, (int)32), signature});
        keyF.whenComplete((receipt, throwable) -> {
            int remoteSeq = (Integer)receipt.get("channel_seq");
            byte[] remaining = Numeric.toBytesPadded((BigInteger)new BigInteger((byte[])receipt.get("remaining")), (int)32);
            String signer = Util.recoverEIP712Signer(channelAddr, (Integer)receipt.get("channel_seq"), new BigInteger(remaining), false, (byte[])receipt.get("signature"));
            if (!signer.equals(Numeric.toHexString((byte[])this.mMarketMakerAddr))) {
                System.out.println("Shit went south, I am out...");
                this.mSession.leave();
            } else {
                this.mSeq = remoteSeq;
                this.mRemainingBalance = Util.toXBR(receipt.get("remaining"));
                SealedBox box = new SealedBox(this.mPublicKey, this.mPrivateKey);
                byte[] key = box.decrypt((byte[])receipt.get("sealed_key"));
                SecretBox secretBox = new SecretBox(key);
                byte[] message = secretBox.decrypt(ciphertext);
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new CBORFactory());
                try {
                    Object result = mapper.readValue(message, Object.class);
                    future.complete(result);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }
        });
    }
}

