/*
 * Decompiled with CFR 0.152.
 */
package xbr.network;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.libsodium.jni.crypto.Random;
import org.web3j.utils.Numeric;
import xbr.network.crypto.SealedBox;
import xbr.network.crypto.SecretBox;

public class KeySeries {
    private final byte[] mAPIID;
    private final BigInteger mPrice;
    private final int mInterval;
    private byte[] mID;
    private byte[] mKey;
    private SecretBox mBox;
    private Map<String, Map<String, Object>> mArchive;
    private ObjectMapper mCBOR;
    private Consumer<KeySeries> mOnRotateCallback;
    private Timer mTimer;
    private String mPrefix;
    private boolean mRunning;

    KeySeries(byte[] apiID, BigInteger price, int interval, String prefix, Consumer<KeySeries> onRotate) {
        this.mAPIID = apiID;
        this.mPrice = price;
        this.mInterval = interval;
        this.mCBOR = new ObjectMapper((JsonFactory)new CBORFactory());
        this.mOnRotateCallback = onRotate;
        this.mArchive = new HashMap<String, Map<String, Object>>();
        this.mTimer = new Timer();
        this.mPrefix = prefix;
    }

    void start() {
        this.mRunning = true;
        this.onRotate();
        this.mTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                KeySeries.this.onRotate();
            }
        }, this.mInterval * 1000, (long)(this.mInterval * 1000));
    }

    void stop() {
        if (this.mRunning) {
            this.mTimer.cancel();
            this.mRunning = false;
        }
    }

    byte[] getID() {
        return this.mID;
    }

    byte[] getAPIID() {
        return this.mAPIID;
    }

    String getPrefix() {
        return this.mPrefix;
    }

    byte[] getPrice() {
        return Numeric.toBytesPadded((BigInteger)this.mPrice, (int)32);
    }

    Map<String, Object> encrypt(Object payload) throws JsonProcessingException {
        byte[] nonce = new Random().randomBytes(24);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", this.mID);
        data.put("serializer", "cbor");
        data.put("ciphertext", this.mBox.encrypt(nonce, this.mCBOR.writeValueAsBytes(payload)));
        return data;
    }

    byte[] encryptKey(byte[] keyID, byte[] buyerPubKey) {
        Map<String, Object> key = this.mArchive.get(Numeric.toHexString((byte[])keyID));
        SealedBox sendKeyBox = new SealedBox(buyerPubKey);
        return sendKeyBox.encrypt((byte[])key.get("key"));
    }

    private void onRotate() {
        this.mID = new Random().randomBytes(16);
        this.mKey = new Random().randomBytes(32);
        this.mBox = new SecretBox(this.mKey);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("key", this.mKey);
        data.put("box", this.mBox);
        this.mArchive.put(Numeric.toHexString((byte[])this.mID), data);
        this.mOnRotateCallback.accept(this);
    }
}

