/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.utils;

import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.utils.CurrentThreadExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class Platform {
    public static int getAndroidAPIVersion() {
        if (io.crossbar.autobahn.utils.Platform.isAndroid()) {
            try {
                Class<?> klass = Class.forName("android.os.Build$VERSION");
                return klass.getField("SDK_INT").getInt(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }

    public static ITransport autoSelectTransport(String webSocketURL) throws RuntimeException {
        try {
            Class<?> transportClass = io.crossbar.autobahn.utils.Platform.isAndroid() ? Class.forName("io.crossbar.autobahn.wamp.transports.WebSocket") : Class.forName("io.crossbar.autobahn.wamp.transports.NettyWebSocket");
            return (ITransport)transportClass.getConstructor(String.class).newInstance(webSocketURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Executor autoSelectExecutor() {
        if (io.crossbar.autobahn.utils.Platform.isAndroid()) {
            return new CurrentThreadExecutor();
        }
        return ForkJoinPool.commonPool();
    }
}

