/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Register
implements IMessage {
    public static final int MESSAGE_TYPE = 64;
    private static final String MATCH_EXACT = "exact";
    private static final String MATCH_PREFIX = "prefix";
    private static final String MATCH_WILDCARD = "wildcard";
    private static final String INVOKE_SINGLE = "single";
    private static final String INVOKE_FIRST = "first";
    private static final String INVOKE_LAST = "last";
    private static final String INVOKE_ROUNDROBIN = "roundrobin";
    private static final String INVOKE_RANDOM = "random";
    private static final String INVOKE_ALL = "all";
    private final long request;
    private final String procedure;
    private final String match;
    private final String invoke;

    public Register(long request, String procedure, String match, String invoke) {
        this.request = request;
        this.procedure = procedure;
        if (match != null) {
            if (!(match.equals(MATCH_EXACT) || match.equals(MATCH_PREFIX) || match.equals(MATCH_WILDCARD))) {
                throw new IllegalArgumentException("match must be one of exact, prefix or wildcard.");
            }
            this.match = match;
        } else {
            this.match = null;
        }
        if (invoke != null) {
            if (!(invoke.equals(INVOKE_SINGLE) || invoke.equals(INVOKE_FIRST) || invoke.equals(INVOKE_LAST) || invoke.equals(INVOKE_ROUNDROBIN) || invoke.equals(INVOKE_RANDOM) || invoke.equals(INVOKE_ALL))) {
                throw new IllegalArgumentException("invoke must be one of single, first, last, roundrobin, random or all.");
            }
            this.invoke = invoke;
        } else {
            this.invoke = null;
        }
    }

    public static Register parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 64, "REGISTER", 4);
        long request = MessageUtil.parseLong(wmsg.get(1));
        Map options = (Map)wmsg.get(2);
        String match = null;
        if (options.containsKey("match") && !(match = (String)options.get("match")).equals(MATCH_EXACT) && !match.equals(MATCH_PREFIX) && !match.equals(MATCH_WILDCARD)) {
            throw new ProtocolError("match must be one of exact, prefix or wildcard.");
        }
        String invoke = null;
        if (!(!options.containsKey("invoke") || (invoke = (String)options.get("invoke")).equals(INVOKE_SINGLE) || invoke.equals(INVOKE_FIRST) || invoke.equals(INVOKE_LAST) || invoke.equals(INVOKE_ROUNDROBIN) || invoke.equals(INVOKE_RANDOM) || invoke.equals(INVOKE_ALL))) {
            throw new IllegalArgumentException("invoke must be one of single, first, last, roundrobin, random or all.");
        }
        String procedure = (String)wmsg.get(3);
        return new Register(request, procedure, match, invoke);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(64);
        marshaled.add(this.request);
        HashMap<String, String> options = new HashMap<String, String>();
        if (this.match != null && !this.match.equals(MATCH_EXACT)) {
            options.put("match", this.match);
        }
        if (this.invoke != null && !this.invoke.equals(INVOKE_SINGLE)) {
            options.put("invoke", this.invoke);
        }
        marshaled.add(options);
        marshaled.add(this.procedure);
        return marshaled;
    }
}

