/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Invocation
implements IMessage {
    public static final int MESSAGE_TYPE = 68;
    public final long request;
    public final long registration;
    public final Map<String, Object> details;
    public final List<Object> args;
    public final Map<String, Object> kwargs;

    public Invocation(long request, long registration, Map<String, Object> details, List<Object> args, Map<String, Object> kwargs) {
        this.request = request;
        this.registration = registration;
        this.details = details;
        this.args = args;
        this.kwargs = kwargs;
    }

    public static Invocation parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 68, "INVOCATION", 4, 6);
        long request = MessageUtil.parseLong(wmsg.get(1));
        long registration = MessageUtil.parseLong(wmsg.get(2));
        Map details = (Map)wmsg.get(3);
        List args = null;
        if (wmsg.size() > 4) {
            if (wmsg.get(4) instanceof byte[]) {
                throw new ProtocolError("Binary payload not supported");
            }
            args = (List)wmsg.get(4);
        }
        Map kwargs = null;
        if (wmsg.size() > 5) {
            kwargs = (Map)wmsg.get(5);
        }
        return new Invocation(request, registration, details, args, kwargs);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(68);
        marshaled.add(this.request);
        marshaled.add(this.registration);
        if (this.details == null) {
            marshaled.add(Collections.emptyMap());
        } else {
            marshaled.add(this.details);
        }
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

