/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.auth;

import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.interfaces.IAuthenticator;
import io.crossbar.autobahn.wamp.types.Challenge;
import io.crossbar.autobahn.wamp.types.ChallengeResponse;
import io.crossbar.autobahn.wamp.utils.AuthUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.libsodium.jni.keys.SigningKey;

public class CryptosignAuth
implements IAuthenticator {
    public static final String authmethod = "cryptosign";
    public final String authid;
    public final String authrole;
    public final Map<String, Object> authextra;
    private final byte[] privateKeyRaw;

    public CryptosignAuth(String authid, String privkey, Map<String, Object> authextra) {
        this(authid, null, privkey, authextra);
    }

    public CryptosignAuth(String authid, String privkey, final String pubkey) {
        this(authid, null, privkey, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("pubkey", pubkey);
            }
        });
    }

    public CryptosignAuth(String authid, File privateKeyFile) {
        this.authid = authid;
        try {
            Map<String, byte[]> keydata = AuthUtil.parseOpenSSHFile(privateKeyFile);
            HashMap<String, Object> authextra = new HashMap<String, Object>();
            authextra.put("pubkey", AuthUtil.toHexString(keydata.get("pubkey")));
            this.authextra = authextra;
            this.privateKeyRaw = keydata.get("privkey");
            this.authrole = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CryptosignAuth(String authid, String authrole, String privkey, Map<String, Object> authextra) {
        this.authid = authid;
        this.authrole = authrole;
        if (authextra == null || Shortcuts.getOrDefault(authextra, "pubkey", null) == null) {
            throw new RuntimeException("authextra must contain pubkey");
        }
        this.authextra = authextra;
        try {
            this.privateKeyRaw = AuthUtil.toBinary(privkey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<ChallengeResponse> onChallenge(Session session, Challenge challenge) {
        String hexChallenge = (String)challenge.extra.get("challenge");
        byte[] rawChallenge = AuthUtil.toBinary(hexChallenge);
        SigningKey key = new SigningKey(this.privateKeyRaw);
        byte[] signed = key.sign(rawChallenge);
        String signatureHex = AuthUtil.toHexString(signed);
        String res = signatureHex + hexChallenge;
        return CompletableFuture.completedFuture(new ChallengeResponse(res, null));
    }

    @Override
    public String getAuthMethod() {
        return authmethod;
    }
}

