/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp;

import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.interfaces.IAuthenticator;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.types.ExitInfo;
import io.crossbar.autobahn.wamp.types.TransportOptions;
import io.crossbar.autobahn.wamp.utils.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class Client {
    private static final IABLogger LOGGER = ABLogger.getLogger(Client.class.getName());
    private final List<ITransport> mTransports;
    private Session mSession;
    private String mRealm;
    private List<IAuthenticator> mAuthenticators;
    private Executor mExecutor;

    public Client(String webSocketURL) {
        this(Platform.autoSelectTransport(webSocketURL));
    }

    public Client(ITransport transport) {
        this.mTransports = new ArrayList<ITransport>();
        this.mTransports.add(transport);
    }

    public Client(ITransport transport, Executor executor) {
        this(transport);
        this.mExecutor = executor;
    }

    public Client(String webSocketURL, Executor executor) {
        this(webSocketURL);
        this.mExecutor = executor;
    }

    public Client(Session session, String webSocketURL, String realm) {
        this(webSocketURL);
        this.mSession = session;
        this.mRealm = realm;
    }

    public Client(Session session, String webSocketURL, String realm, Executor executor) {
        this(webSocketURL);
        this.mSession = session;
        this.mRealm = realm;
        this.mExecutor = executor;
    }

    public Client(Session session, String webSocketURL, String realm, List<IAuthenticator> authenticators) {
        this(webSocketURL);
        this.mSession = session;
        this.mRealm = realm;
        this.mAuthenticators = authenticators;
    }

    public Client(Session session, String webSocketURL, String realm, IAuthenticator authenticator) {
        this(webSocketURL);
        this.mSession = session;
        this.mRealm = realm;
        this.mAuthenticators = new ArrayList<IAuthenticator>();
        this.mAuthenticators.add(authenticator);
    }

    public Client(List<ITransport> transports) {
        this.mTransports = transports;
    }

    public Client(List<ITransport> transports, Executor executor) {
        this(transports);
        this.mExecutor = executor;
    }

    private Executor getExecutor() {
        return this.mExecutor == null ? Platform.autoSelectExecutor() : this.mExecutor;
    }

    public void add(Session session, String realm, List<IAuthenticator> authenticators) {
        if (this.mSession != null) {
            throw new IllegalStateException("Addition of multiple sessions not implemented");
        }
        this.mSession = session;
        this.mRealm = realm;
        this.mAuthenticators = authenticators;
    }

    public void add(Session session, String realm) {
        this.add(session, realm, null);
    }

    public CompletableFuture<ExitInfo> connect() {
        return this.connect(new TransportOptions());
    }

    public CompletableFuture<ExitInfo> connect(TransportOptions options) {
        CompletableFuture<ExitInfo> exitFuture = new CompletableFuture<ExitInfo>();
        this.mSession.addOnConnectListener(session -> this.mSession.join(this.mRealm, this.mAuthenticators).thenAccept(details -> LOGGER.i(String.format("JOINED session=%s realm=%s", details.sessionID, details.realm))));
        this.mSession.addOnDisconnectListener((session, wasClean) -> {
            for (ITransport transport : this.mTransports) {
                try {
                    transport.close();
                }
                catch (Exception exception) {}
            }
            exitFuture.complete(new ExitInfo(wasClean));
        });
        CompletableFuture.runAsync(() -> {
            try {
                this.mTransports.get(0).connect(this.mSession, options);
            }
            catch (Exception e) {
                exitFuture.completeExceptionally(e);
            }
        }, this.getExecutor());
        return exitFuture;
    }

    public void setOptions(TransportOptions options) {
        this.mTransports.get(0).setOptions(options);
    }
}

