/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.utils;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import java.util.List;

public class MessageUtil {
    public static void validateMessage(List<Object> wmsg, int messageType, String messageVerboseName, int lengthMin, int lengthMax) {
        if (wmsg.size() == 0 || !(wmsg.get(0) instanceof Integer) || (Integer)wmsg.get(0) != messageType) {
            throw new IllegalArgumentException("Invalid message.");
        }
        if (wmsg.size() < lengthMin || wmsg.size() > lengthMax) {
            throw new ProtocolError(String.format("Invalid message length %s for %s", wmsg.size(), messageVerboseName));
        }
    }

    public static void validateMessage(List<Object> wmsg, int messageType, String messageVerboseName, int length) {
        MessageUtil.validateMessage(wmsg, messageType, messageVerboseName, length, length);
    }

    public static long parseLong(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).intValue();
        }
        return (Long)object;
    }
}

