/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.transports;

import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.serializers.JSONSerializer;
import io.crossbar.autobahn.wamp.types.TransportOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import javax.net.SocketFactory;

public class RawSocket
implements ITransport {
    private static final int ZERO = 0;
    private Socket mSocket;
    private String mUri;
    private OutputStream mOStream;
    private InputStream mIStream;
    private ISerializer mSerializer;

    public RawSocket(String uri) {
        this.mUri = uri;
        throw new IllegalStateException("NOT IMPLEMENTED YET");
    }

    @Override
    public void send(byte[] payload, boolean isBinary) {
        try {
            this.mOStream.write(new byte[]{0, 0, 0, (byte)payload.length});
            this.mOStream.write(payload);
            this.mOStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connect(ITransportHandler transportHandler) throws Exception {
        this.connect(transportHandler, null);
    }

    @Override
    public void connect(ITransportHandler transportHandler, TransportOptions options) throws Exception {
        int serializer;
        byte b;
        int max_length;
        this.mSocket = SocketFactory.getDefault().createSocket();
        URI uri = URI.create(this.mUri);
        this.mSocket.connect(new InetSocketAddress(uri.getHost(), uri.getPort()));
        this.mOStream = this.mSocket.getOutputStream();
        this.mIStream = this.mSocket.getInputStream();
        int serializerID = 1;
        int request_max_len_exp = 24;
        long maxSize = (long)Math.pow(2.0, 9 + request_max_len_exp);
        this.mOStream.write(127);
        this.mOStream.write(request_max_len_exp - 9 << 4 | 1);
        this.mOStream.write(0);
        this.mOStream.write(0);
        this.mOStream.flush();
        byte[] bytes = new byte[4];
        do {
            this.mIStream.read(bytes);
            b = bytes[1];
            serializer = b & 0xF;
        } while ((max_length = b >> 4 & 0xF) + 9 != request_max_len_exp || serializer != serializerID);
        System.out.println("MAX " + maxSize);
        System.out.println("Handshake complete, lets roll");
        this.mSerializer = new JSONSerializer();
        transportHandler.onConnect(this, this.mSerializer);
    }

    @Override
    public boolean isOpen() {
        return this.mSocket != null && !this.mSocket.isClosed() && this.mSocket.isConnected();
    }

    @Override
    public void close() throws Exception {
        if (this.mSocket != null && !this.mSocket.isClosed()) {
            this.mSocket.close();
        }
    }

    @Override
    public void abort() throws Exception {
        if (this.mSocket != null && !this.mSocket.isClosed()) {
            this.mSocket.close();
        }
    }

    @Override
    public void setOptions(TransportOptions options) {
    }
}

