/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp;

import com.fasterxml.jackson.core.type.TypeReference;
import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.wamp.auth.ChallengeResponseAuth;
import io.crossbar.autobahn.wamp.auth.CryptosignAuth;
import io.crossbar.autobahn.wamp.auth.TicketAuth;
import io.crossbar.autobahn.wamp.exceptions.ApplicationError;
import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IAuthenticator;
import io.crossbar.autobahn.wamp.interfaces.IInvocationHandler;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.interfaces.ISession;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.interfaces.TriConsumer;
import io.crossbar.autobahn.wamp.interfaces.TriFunction;
import io.crossbar.autobahn.wamp.messages.Abort;
import io.crossbar.autobahn.wamp.messages.Authenticate;
import io.crossbar.autobahn.wamp.messages.Call;
import io.crossbar.autobahn.wamp.messages.Error;
import io.crossbar.autobahn.wamp.messages.Event;
import io.crossbar.autobahn.wamp.messages.Goodbye;
import io.crossbar.autobahn.wamp.messages.Hello;
import io.crossbar.autobahn.wamp.messages.Invocation;
import io.crossbar.autobahn.wamp.messages.MessageMap;
import io.crossbar.autobahn.wamp.messages.Publish;
import io.crossbar.autobahn.wamp.messages.Published;
import io.crossbar.autobahn.wamp.messages.Register;
import io.crossbar.autobahn.wamp.messages.Registered;
import io.crossbar.autobahn.wamp.messages.Result;
import io.crossbar.autobahn.wamp.messages.Subscribe;
import io.crossbar.autobahn.wamp.messages.Subscribed;
import io.crossbar.autobahn.wamp.messages.Unregister;
import io.crossbar.autobahn.wamp.messages.Unregistered;
import io.crossbar.autobahn.wamp.messages.Unsubscribe;
import io.crossbar.autobahn.wamp.messages.Unsubscribed;
import io.crossbar.autobahn.wamp.messages.Welcome;
import io.crossbar.autobahn.wamp.messages.Yield;
import io.crossbar.autobahn.wamp.reflectionRoles.ReflectionServices;
import io.crossbar.autobahn.wamp.reflectionRoles.WampException;
import io.crossbar.autobahn.wamp.requests.CallRequest;
import io.crossbar.autobahn.wamp.requests.PublishRequest;
import io.crossbar.autobahn.wamp.requests.RegisterRequest;
import io.crossbar.autobahn.wamp.requests.SubscribeRequest;
import io.crossbar.autobahn.wamp.requests.UnregisterRequest;
import io.crossbar.autobahn.wamp.requests.UnsubscribeRequest;
import io.crossbar.autobahn.wamp.types.CallOptions;
import io.crossbar.autobahn.wamp.types.CallResult;
import io.crossbar.autobahn.wamp.types.Challenge;
import io.crossbar.autobahn.wamp.types.CloseDetails;
import io.crossbar.autobahn.wamp.types.EventDetails;
import io.crossbar.autobahn.wamp.types.InvocationDetails;
import io.crossbar.autobahn.wamp.types.InvocationResult;
import io.crossbar.autobahn.wamp.types.Publication;
import io.crossbar.autobahn.wamp.types.PublishOptions;
import io.crossbar.autobahn.wamp.types.ReceptionResult;
import io.crossbar.autobahn.wamp.types.RegisterOptions;
import io.crossbar.autobahn.wamp.types.Registration;
import io.crossbar.autobahn.wamp.types.SessionDetails;
import io.crossbar.autobahn.wamp.types.SubscribeOptions;
import io.crossbar.autobahn.wamp.types.Subscription;
import io.crossbar.autobahn.wamp.utils.IDGenerator;
import io.crossbar.autobahn.wamp.utils.Platform;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Session
implements ISession,
ITransportHandler {
    public static final IABLogger LOGGER = ABLogger.getLogger(Session.class.getName());
    private final int STATE_DISCONNECTED = 1;
    private final int STATE_HELLO_SENT = 2;
    private final int STATE_AUTHENTICATE_SENT = 3;
    private final int STATE_JOINED = 4;
    private final int STATE_READY = 5;
    private final int STATE_GOODBYE_SENT = 6;
    private final int STATE_ABORT_SENT = 7;
    private ITransport mTransport;
    private ISerializer mSerializer;
    private Executor mExecutor;
    private CompletableFuture<SessionDetails> mJoinFuture;
    private List<IAuthenticator> mAuthenticators;
    private final ArrayList<ISession.OnJoinListener> mOnJoinListeners = new ArrayList();
    private final ArrayList<ISession.OnReadyListener> mOnReadyListeners = new ArrayList();
    private final ArrayList<ISession.OnLeaveListener> mOnLeaveListeners = new ArrayList();
    private final ArrayList<ISession.OnConnectListener> mOnConnectListeners = new ArrayList();
    private final ArrayList<ISession.OnDisconnectListener> mOnDisconnectListeners = new ArrayList();
    private final ArrayList<ISession.OnUserErrorListener> mOnUserErrorListeners = new ArrayList();
    private final IDGenerator mIDGenerator = new IDGenerator();
    private final Map<Long, CallRequest> mCallRequests = new HashMap<Long, CallRequest>();
    private final Map<Long, SubscribeRequest> mSubscribeRequests = new HashMap<Long, SubscribeRequest>();
    private final Map<Long, PublishRequest> mPublishRequests = new HashMap<Long, PublishRequest>();
    private final Map<Long, RegisterRequest> mRegisterRequest = new HashMap<Long, RegisterRequest>();
    private final Map<Long, List<Subscription>> mSubscriptions = new HashMap<Long, List<Subscription>>();
    private final Map<Long, Registration> mRegistrations = new HashMap<Long, Registration>();
    private final Map<Long, UnsubscribeRequest> mUnsubscribeRequests = new HashMap<Long, UnsubscribeRequest>();
    private final Map<Long, UnregisterRequest> mUnregisterRequests = new HashMap<Long, UnregisterRequest>();
    private int mState = 1;
    private long mSessionID;
    private boolean mGoodbyeSent;
    private String mRealm;
    private ReflectionServices mReflectionServices;

    public Session() {
        this(Platform.autoSelectExecutor());
    }

    public Session(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        this.mExecutor = executor;
    }

    public long getID() {
        return this.mSessionID;
    }

    private void throwIfNotConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("The transport must be connected first");
        }
    }

    @Override
    public void onConnect(ITransport transport, ISerializer serializer) throws Exception {
        LOGGER.d("onConnect()");
        if (this.mTransport != null) {
            throw new Exception("already connected");
        }
        this.mTransport = transport;
        this.mSerializer = serializer;
        this.mReflectionServices = new ReflectionServices(this, this.mSerializer);
        CompletableFuture.runAsync(() -> {
            for (ISession.OnConnectListener listener : this.mOnConnectListeners) {
                listener.onConnect(this);
            }
        }, this.mExecutor);
    }

    private void send(IMessage message) {
        if (!this.isConnected()) {
            throw new IllegalStateException("no transport");
        }
        LOGGER.d("  >>> TX : " + message);
        this.mTransport.send(this.mSerializer.serialize(message.marshal()), this.mSerializer.isBinary());
    }

    @Override
    public void onMessage(byte[] payload, boolean isBinary) throws Exception {
        List<Object> rawMessage = this.mSerializer.unserialize(payload, isBinary);
        try {
            int messageType = (Integer)rawMessage.get(0);
            Class<? extends IMessage> messageKlass = MessageMap.MESSAGE_TYPE_MAP.get(messageType);
            IMessage message = (IMessage)messageKlass.getMethod("parse", List.class).invoke(null, rawMessage);
            LOGGER.d("  <<< RX : " + message);
            if (this.mSessionID == 0L) {
                this.onPreSessionMessage(message);
            } else {
                this.onMessage(message);
            }
        }
        catch (Exception e) {
            LOGGER.d("mapping received message bytes to IMessage failed: " + e.getMessage());
        }
    }

    @Override
    public void onLeave(CloseDetails details) {
        if (this.mState == 1) {
            return;
        }
        LOGGER.d("onLeave(), reason=" + details.reason);
        ArrayList futures = new ArrayList();
        for (ISession.OnLeaveListener listener : this.mOnLeaveListeners) {
            futures.add(CompletableFuture.runAsync(() -> listener.onLeave(this, details), this.mExecutor));
        }
        CompletableFuture d = this.combineFutures(futures);
        d.thenRunAsync(() -> LOGGER.d("Notified all Session.onLeave listeners."), this.mExecutor);
    }

    private void onPreSessionMessage(IMessage message) throws Exception {
        block11: {
            block13: {
                block12: {
                    if (!(message instanceof Welcome)) break block12;
                    Welcome msg = (Welcome)message;
                    this.mState = 4;
                    this.mSessionID = msg.session;
                    SessionDetails details = new SessionDetails(msg.realm, msg.session);
                    this.mJoinFuture.complete(details);
                    ArrayList futures = new ArrayList();
                    for (ISession.OnJoinListener listener : this.mOnJoinListeners) {
                        futures.add(CompletableFuture.runAsync(() -> listener.onJoin(this, details), this.mExecutor));
                    }
                    CompletableFuture d = this.combineFutures(futures);
                    d.thenRunAsync(() -> {
                        this.mState = 5;
                        for (ISession.OnReadyListener listener : this.mOnReadyListeners) {
                            listener.onReady(this);
                        }
                    }, this.mExecutor);
                    break block11;
                }
                if (!(message instanceof Abort)) break block13;
                Abort abortMessage = (Abort)message;
                CloseDetails details = new CloseDetails(abortMessage.reason, abortMessage.message);
                ArrayList futures = new ArrayList();
                for (ISession.OnLeaveListener listener : this.mOnLeaveListeners) {
                    futures.add(CompletableFuture.runAsync(() -> listener.onLeave(this, details), this.mExecutor));
                }
                CompletableFuture d = this.combineFutures(futures);
                d.thenRunAsync(() -> {
                    LOGGER.d("Notified Session.onLeave listeners, now closing transport");
                    this.mState = 1;
                    if (this.mTransport != null && this.mTransport.isOpen()) {
                        try {
                            this.mTransport.close();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }
                }, this.mExecutor);
                break block11;
            }
            if (!(message instanceof io.crossbar.autobahn.wamp.messages.Challenge)) break block11;
            io.crossbar.autobahn.wamp.messages.Challenge msg = (io.crossbar.autobahn.wamp.messages.Challenge)message;
            Challenge challenge = new Challenge(msg.method, msg.extra);
            if (this.mAuthenticators != null) {
                if (msg.method.equals("ticket")) {
                    for (IAuthenticator authenticator : this.mAuthenticators) {
                        if (!authenticator.getAuthMethod().equals("ticket")) continue;
                        TicketAuth auth = (TicketAuth)authenticator;
                        auth.onChallenge(this, challenge).whenCompleteAsync((response, throwable) -> this.send(new Authenticate(response.signature, response.extra)), this.mExecutor);
                        break;
                    }
                } else if (msg.method.equals("wampcra")) {
                    for (IAuthenticator authenticator : this.mAuthenticators) {
                        if (!authenticator.getAuthMethod().equals("wampcra")) continue;
                        ChallengeResponseAuth auth = (ChallengeResponseAuth)authenticator;
                        auth.onChallenge(this, challenge).whenCompleteAsync((response, throwable) -> this.send(new Authenticate(response.signature, response.extra)), this.mExecutor);
                        break;
                    }
                } else if (msg.method.equals("cryptosign")) {
                    for (IAuthenticator authenticator : this.mAuthenticators) {
                        if (!authenticator.getAuthMethod().equals("cryptosign")) continue;
                        CryptosignAuth auth = (CryptosignAuth)authenticator;
                        auth.onChallenge(this, challenge).whenCompleteAsync((response, throwable) -> this.send(new Authenticate(response.signature, response.extra)), this.mExecutor);
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMessage(IMessage message) throws Exception {
        if (message instanceof Result) {
            Result msg = (Result)message;
            CallRequest callRequest = Shortcuts.getOrDefault(this.mCallRequests, msg.request, null);
            if (callRequest == null) {
                throw new ProtocolError(String.format("RESULT received for non-pending request ID %s", msg.request));
            }
            this.mCallRequests.remove(msg.request);
            if (callRequest.resultTypeRef != null) {
                callRequest.onReply.complete(this.mSerializer.convertValue(msg.args.get(0), callRequest.resultTypeRef));
                return;
            } else if (callRequest.resultTypeClass != null) {
                callRequest.onReply.complete(this.mSerializer.convertValue(msg.args.get(0), callRequest.resultTypeClass));
                return;
            } else {
                callRequest.onReply.complete(new CallResult(msg.args, msg.kwargs));
            }
            return;
        } else if (message instanceof Subscribed) {
            Subscribed msg = (Subscribed)message;
            SubscribeRequest subscribeRequest = Shortcuts.getOrDefault(this.mSubscribeRequests, msg.request, null);
            if (subscribeRequest == null) {
                throw new ProtocolError(String.format("SUBSCRIBED received for non-pending request ID %s", msg.request));
            }
            this.mSubscribeRequests.remove(msg.request);
            if (!this.mSubscriptions.containsKey(msg.subscription)) {
                this.mSubscriptions.put(msg.subscription, new ArrayList());
            }
            Subscription subscription = new Subscription(msg.subscription, subscribeRequest.topic, subscribeRequest.resultTypeRef, subscribeRequest.resultTypeClass, subscribeRequest.handler, this);
            this.mSubscriptions.get(msg.subscription).add(subscription);
            subscribeRequest.onReply.complete(subscription);
            return;
        } else if (message instanceof Event) {
            Event msg = (Event)message;
            List list = Shortcuts.getOrDefault(this.mSubscriptions, msg.subscription, null);
            if (list == null) {
                throw new ProtocolError(String.format("EVENT received for non-subscribed subscription ID %s", msg.subscription));
            }
            ArrayList futures = new ArrayList();
            for (Subscription subscription : list) {
                Object handler;
                EventDetails details = new EventDetails(subscription, msg.publication, msg.topic != null ? msg.topic : subscription.topic, msg.retained, -1L, null, null, this);
                CompletableFuture<Void> future = null;
                Object arg = subscription.resultTypeRef != null ? this.mSerializer.convertValue(msg.args.get(0), subscription.resultTypeRef) : (subscription.resultTypeClass != null ? this.mSerializer.convertValue(msg.args.get(0), subscription.resultTypeClass) : msg.args);
                if (subscription.handler instanceof Consumer) {
                    handler = (Consumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$10((Consumer)handler, arg), this.mExecutor);
                } else if (subscription.handler instanceof Function) {
                    handler = (Function)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$11((Function)handler, arg), this.mExecutor);
                } else if (subscription.handler instanceof BiConsumer) {
                    handler = (BiConsumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$12((BiConsumer)handler, arg, details), this.mExecutor);
                } else if (subscription.handler instanceof BiFunction) {
                    handler = (BiFunction)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$13((BiFunction)handler, arg, details), this.mExecutor);
                } else if (subscription.handler instanceof TriConsumer) {
                    handler = (TriConsumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$14((TriConsumer)handler, arg, msg, details), this.mExecutor);
                } else if (subscription.handler instanceof TriFunction) {
                    handler = (TriFunction)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$15((TriFunction)handler, arg, msg, details), this.mExecutor);
                }
                futures.add(future);
            }
            this.combineFutures(futures);
            return;
        } else if (message instanceof Published) {
            Published msg = (Published)message;
            PublishRequest publishRequest = Shortcuts.getOrDefault(this.mPublishRequests, msg.request, null);
            if (publishRequest == null) {
                throw new ProtocolError(String.format("PUBLISHED received for non-pending request ID %s", msg.request));
            }
            this.mPublishRequests.remove(msg.request);
            Publication publication = new Publication(msg.publication);
            publishRequest.onReply.complete(publication);
            return;
        } else if (message instanceof Registered) {
            Registered msg = (Registered)message;
            RegisterRequest registerRequest = Shortcuts.getOrDefault(this.mRegisterRequest, msg.request, null);
            if (registerRequest == null) {
                throw new ProtocolError(String.format("REGISTERED received for already existing registration ID %s", msg.request));
            }
            this.mRegisterRequest.remove(msg.request);
            Registration registration = new Registration(msg.registration, registerRequest.procedure, registerRequest.endpoint, this);
            this.mRegistrations.put(msg.registration, registration);
            registerRequest.onReply.complete(registration);
            return;
        } else if (message instanceof Invocation) {
            Invocation msg = (Invocation)message;
            Registration registration = Shortcuts.getOrDefault(this.mRegistrations, msg.registration, null);
            if (registration == null) {
                throw new ProtocolError(String.format("INVOCATION received for non-registered registration ID %s", msg.registration));
            }
            InvocationDetails details = new InvocationDetails(registration, registration.procedure, -1L, null, null, this);
            CompletableFuture.runAsync(() -> {
                Object result;
                Object endpoint;
                if (registration.endpoint instanceof Supplier) {
                    endpoint = (Supplier)registration.endpoint;
                    result = endpoint.get();
                } else if (registration.endpoint instanceof Function) {
                    endpoint = (Function)registration.endpoint;
                    result = endpoint.apply(msg.args);
                } else if (registration.endpoint instanceof BiFunction) {
                    endpoint = (BiFunction)registration.endpoint;
                    result = endpoint.apply(msg.args, details);
                } else if (registration.endpoint instanceof TriFunction) {
                    endpoint = (TriFunction)registration.endpoint;
                    result = endpoint.apply(msg.args, msg.kwargs, details);
                } else {
                    endpoint = (IInvocationHandler)registration.endpoint;
                    result = endpoint.apply(msg.args, msg.kwargs, details);
                }
                if (result instanceof CompletableFuture) {
                    CompletableFuture fResult = (CompletableFuture)result;
                    fResult.whenCompleteAsync((invocRes, throwable) -> {
                        if (throwable != null) {
                            if (throwable instanceof WampException) {
                                WampException casted = (WampException)throwable;
                                this.send(new Error(68, msg.request, casted.getErrorUri(), casted.getArguments(), casted.getKwArguments()));
                            } else {
                                ArrayList<Object> args = new ArrayList<Object>();
                                args.add(throwable.getMessage());
                                this.send(new Error(68, msg.request, "wamp.error.runtime_error", args, null));
                            }
                        } else {
                            this.send(new Yield(msg.request, invocRes.results, invocRes.kwresults));
                        }
                    }, this.mExecutor);
                } else if (result instanceof InvocationResult) {
                    InvocationResult res = (InvocationResult)result;
                    this.send(new Yield(msg.request, res.results, res.kwresults));
                } else if (result instanceof List) {
                    this.send(new Yield(msg.request, (List)result, null));
                } else if (result instanceof Map) {
                    this.send(new Yield(msg.request, null, (Map)result));
                } else if (result instanceof Void) {
                    this.send(new Yield(msg.request, null, null));
                } else {
                    ArrayList<Object> item = new ArrayList<Object>();
                    item.add(result);
                    this.send(new Yield(msg.request, item, null));
                }
            }, this.mExecutor).whenCompleteAsync((aVoid, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof WampException) {
                        WampException casted = (WampException)throwable;
                        this.send(new Error(68, msg.request, casted.getErrorUri(), casted.getArguments(), casted.getKwArguments()));
                    } else {
                        ArrayList<Object> args = new ArrayList<Object>();
                        args.add(throwable.getMessage());
                        this.send(new Error(68, msg.request, "wamp.error.runtime_error", args, null));
                    }
                }
            });
            return;
        } else if (message instanceof Goodbye) {
            Goodbye msg = (Goodbye)message;
            CloseDetails closeDetails = new CloseDetails(msg.reason, msg.message);
            ArrayList futures = new ArrayList();
            for (ISession.OnLeaveListener listener : this.mOnLeaveListeners) {
                futures.add(CompletableFuture.runAsync(() -> listener.onLeave(this, closeDetails), this.mExecutor));
            }
            CompletableFuture d = this.combineFutures(futures);
            d.thenRunAsync(() -> {
                LOGGER.d("Notified Session.onLeave listeners, now closing transport");
                if (this.mTransport != null && this.mTransport.isOpen()) {
                    try {
                        this.mTransport.close();
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }
                this.mState = 1;
            }, this.mExecutor);
            return;
        } else if (message instanceof Unregistered) {
            Unregistered msg = (Unregistered)message;
            UnregisterRequest unregisterRequest = Shortcuts.getOrDefault(this.mUnregisterRequests, msg.request, null);
            if (unregisterRequest == null) {
                throw new ProtocolError(String.format("UNREGISTERED received for already unregistered registration ID %s", msg.registration));
            }
            if (this.mRegistrations.containsKey(unregisterRequest.registrationID)) {
                this.mRegistrations.remove(unregisterRequest.registrationID);
            }
            unregisterRequest.onReply.complete(0);
            return;
        } else if (message instanceof Unsubscribed) {
            Unsubscribed msg = (Unsubscribed)message;
            UnsubscribeRequest unsubscribeRequest = Shortcuts.getOrDefault(this.mUnsubscribeRequests, msg.request, null);
            List<Subscription> subscriptions = this.mSubscriptions.get(unsubscribeRequest.subscriptionID);
            unsubscribeRequest.onReply.complete(subscriptions.size());
            return;
        } else {
            void var3_26;
            if (!(message instanceof Error)) throw new ProtocolError(String.format("Unexpected message %s", message.getClass().getName()));
            Error msg = (Error)message;
            Object var3_21 = null;
            if (msg.requestType == 48 && this.mCallRequests.containsKey(msg.request)) {
                CompletableFuture completableFuture = this.mCallRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mCallRequests.remove(msg.request);
            } else if (msg.requestType == 16 && this.mPublishRequests.containsKey(msg.request)) {
                CompletableFuture<Publication> completableFuture = this.mPublishRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mPublishRequests.remove(msg.request);
            } else if (msg.requestType == 32 && this.mSubscribeRequests.containsKey(msg.request)) {
                CompletableFuture<Subscription> completableFuture = this.mSubscribeRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mSubscribeRequests.remove(msg.request);
            } else if (msg.requestType == 64 && this.mRegisterRequest.containsKey(msg.request)) {
                CompletableFuture<Registration> completableFuture = this.mRegisterRequest.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mRegisterRequest.remove(msg.request);
            }
            if (var3_26 == null) throw new ProtocolError(String.format("ERROR received for non-pending request_type: %s and request ID %s", msg.requestType, msg.request));
            var3_26.completeExceptionally(new ApplicationError(msg.error, msg.args, msg.kwargs));
        }
    }

    @Override
    public void onDisconnect(boolean wasClean) {
        LOGGER.d("onDisconnect(), wasClean=" + wasClean);
        ArrayList futures = new ArrayList();
        for (ISession.OnDisconnectListener listener : this.mOnDisconnectListeners) {
            futures.add(CompletableFuture.runAsync(() -> listener.onDisconnect(this, wasClean), this.mExecutor));
        }
        CompletableFuture d = this.combineFutures(futures);
        d.thenRunAsync(() -> {
            LOGGER.d("Notified all Session.onDisconnect listeners.");
            this.mTransport = null;
            this.mSerializer = null;
            this.mState = 1;
        }, this.mExecutor);
    }

    @Override
    public boolean isConnected() {
        return this.mTransport != null;
    }

    private CompletableFuture combineFutures(List<CompletableFuture<?>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private <T> CompletableFuture<Subscription> reallySubscribe(String topic, Object handler, SubscribeOptions options, TypeReference<T> resultTypeRef, Class<T> resultTypeClass) {
        this.throwIfNotConnected();
        CompletableFuture<Subscription> future = new CompletableFuture<Subscription>();
        long requestID = this.mIDGenerator.next();
        this.mSubscribeRequests.put(requestID, new SubscribeRequest(requestID, topic, future, resultTypeRef, resultTypeClass, handler));
        this.send(new Subscribe(requestID, options, topic));
        return future;
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, Consumer<List<Object>> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, Consumer<List<Object>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Consumer<T> handler, TypeReference<T> resultType) {
        return this.reallySubscribe(topic, handler, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Consumer<T> handler, Class<T> resultType) {
        return this.reallySubscribe(topic, handler, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Consumer<T> handler, TypeReference<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Consumer<T> handler, Class<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, resultType);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, Function<List<Object>, CompletableFuture<ReceptionResult>> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, Function<List<Object>, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Function<T, CompletableFuture<ReceptionResult>> handler, TypeReference<T> resultType) {
        return this.reallySubscribe(topic, handler, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Function<T, CompletableFuture<ReceptionResult>> handler, Class<T> resultType) {
        return this.reallySubscribe(topic, handler, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Function<T, CompletableFuture<ReceptionResult>> handler, TypeReference<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Function<T, CompletableFuture<ReceptionResult>> handler, Class<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, resultType);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, BiConsumer<List<Object>, EventDetails> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, BiConsumer<List<Object>, EventDetails> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiConsumer<T, EventDetails> handler, TypeReference<T> resultType) {
        return this.reallySubscribe(topic, handler, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiConsumer<T, EventDetails> handler, Class<T> resultType) {
        return this.reallySubscribe(topic, handler, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiConsumer<T, EventDetails> handler, TypeReference<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiConsumer<T, EventDetails> handler, Class<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, resultType);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, BiFunction<List<Object>, EventDetails, CompletableFuture<ReceptionResult>> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, BiFunction<List<Object>, EventDetails, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiFunction<T, EventDetails, CompletableFuture<ReceptionResult>> handler, TypeReference<T> resultType) {
        return this.reallySubscribe(topic, handler, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiFunction<T, EventDetails, CompletableFuture<ReceptionResult>> handler, Class<T> resultType) {
        return this.reallySubscribe(topic, handler, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiFunction<T, EventDetails, CompletableFuture<ReceptionResult>> handler, TypeReference<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiFunction<T, EventDetails, CompletableFuture<ReceptionResult>> handler, Class<T> resultType, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, resultType);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, TriConsumer<List<Object>, Map<String, Object>, EventDetails> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, TriConsumer<List<Object>, Map<String, Object>, EventDetails> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, TriFunction<List<Object>, Map<String, Object>, EventDetails, CompletableFuture<ReceptionResult>> handler) {
        return this.reallySubscribe(topic, handler, null, null, null);
    }

    @Override
    public CompletableFuture<Subscription> subscribe(String topic, TriFunction<List<Object>, Map<String, Object>, EventDetails, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options, null, null);
    }

    @Override
    public CompletableFuture<Integer> unsubscribe(Subscription subscription) {
        if (!subscription.isActive()) {
            throw new IllegalStateException("Subscription is already inactive");
        }
        List subscriptions = Shortcuts.getOrDefault(this.mSubscriptions, subscription.subscription, null);
        if (subscriptions == null || !subscriptions.contains(subscription)) {
            throw new IllegalStateException("Subscription is already inactive");
        }
        subscriptions.remove(subscription);
        subscription.setInactive();
        int remainingCount = subscriptions.size();
        CompletableFuture<Integer> unsubFuture = new CompletableFuture<Integer>();
        if (remainingCount == 0) {
            long requestID = this.mIDGenerator.next();
            this.mUnsubscribeRequests.put(requestID, new UnsubscribeRequest(requestID, unsubFuture, subscription.subscription));
            this.send(new Unsubscribe(requestID, subscription.subscription));
        } else {
            unsubFuture.complete(remainingCount);
        }
        return unsubFuture;
    }

    private CompletableFuture<Publication> reallyPublish(String topic, List<Object> args, Map<String, Object> kwargs, PublishOptions options) {
        this.throwIfNotConnected();
        CompletableFuture<Publication> future = new CompletableFuture<Publication>();
        long requestID = this.mIDGenerator.next();
        this.mPublishRequests.put(requestID, new PublishRequest(requestID, future));
        if (options != null) {
            this.send(new Publish(requestID, topic, args, kwargs, options.acknowledge, options.excludeMe, options.retain));
        } else {
            this.send(new Publish(requestID, topic, args, kwargs, true, true, false));
        }
        return future;
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, List<Object> args, Map<String, Object> kwargs, PublishOptions options) {
        return this.reallyPublish(topic, args, kwargs, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, Object arg, PublishOptions options) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(arg);
        return this.reallyPublish(topic, args, null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, PublishOptions options, Object ... args) {
        return this.reallyPublish(topic, Arrays.asList(args), null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, Object ... args) {
        return this.reallyPublish(topic, Arrays.asList(args), null, null);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, PublishOptions options) {
        return this.reallyPublish(topic, null, null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic) {
        return this.reallyPublish(topic, null, null, null);
    }

    private CompletableFuture<Registration> reallyRegister(String procedure, Object endpoint, RegisterOptions options) {
        this.throwIfNotConnected();
        CompletableFuture<Registration> future = new CompletableFuture<Registration>();
        long requestID = this.mIDGenerator.next();
        this.mRegisterRequest.put(requestID, new RegisterRequest(requestID, future, procedure, endpoint));
        if (options != null) {
            this.send(new Register(requestID, procedure, options.match, options.invoke));
        } else {
            this.send(new Register(requestID, procedure, null, null));
        }
        return future;
    }

    @Override
    public <T> CompletableFuture<Registration> register(String procedure, Supplier<T> endpoint) {
        return this.reallyRegister(procedure, endpoint, null);
    }

    @Override
    public <T> CompletableFuture<Registration> register(String procedure, Supplier<T> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public CompletableFuture<Registration> register(String procedure, IInvocationHandler endpoint) {
        return this.reallyRegister(procedure, endpoint, null);
    }

    @Override
    public CompletableFuture<Registration> register(String procedure, IInvocationHandler endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T, R> CompletableFuture<Registration> register(String procedure, Function<T, R> endpoint) {
        return this.reallyRegister(procedure, endpoint, null);
    }

    @Override
    public <T, R> CompletableFuture<Registration> register(String procedure, Function<T, R> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T, R> CompletableFuture<Registration> register(String procedure, BiFunction<T, InvocationDetails, R> endpoint) {
        return this.reallyRegister(procedure, endpoint, null);
    }

    @Override
    public <T, R> CompletableFuture<Registration> register(String procedure, BiFunction<T, InvocationDetails, R> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T, U, R> CompletableFuture<Registration> register(String procedure, TriFunction<T, U, InvocationDetails, R> endpoint) {
        return this.reallyRegister(procedure, endpoint, null);
    }

    @Override
    public <T, U, R> CompletableFuture<Registration> register(String procedure, TriFunction<T, U, InvocationDetails, R> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public CompletableFuture<Integer> unregister(Registration registration) {
        if (!registration.isActive()) {
            throw new IllegalStateException("Registration is already inactive");
        }
        if (!this.mRegistrations.containsKey(registration.registration)) {
            throw new IllegalStateException("Not registered");
        }
        CompletableFuture<Integer> unregFuture = new CompletableFuture<Integer>();
        long requestID = this.mIDGenerator.next();
        this.mUnregisterRequests.put(requestID, new UnregisterRequest(requestID, unregFuture, registration.registration));
        this.send(new Unregister(requestID, registration.registration));
        return unregFuture;
    }

    private <T> CompletableFuture<T> reallyCall(String procedure, List<Object> args, Map<String, Object> kwargs, CallOptions options, TypeReference<T> resultTypeReference, Class<T> resultTypeClass) {
        this.throwIfNotConnected();
        CompletableFuture future = new CompletableFuture();
        long requestID = this.mIDGenerator.next();
        this.mCallRequests.put(requestID, new CallRequest(requestID, procedure, future, options, resultTypeReference, resultTypeClass));
        if (options == null) {
            this.send(new Call(requestID, procedure, args, kwargs, 0));
        } else {
            this.send(new Call(requestID, procedure, args, kwargs, options.timeout));
        }
        return future;
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure) {
        return this.reallyCall(procedure, null, null, null, null, null);
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, Object ... args) {
        return this.reallyCall(procedure, Arrays.asList(args), null, null, null, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, TypeReference<T> resultType) {
        return this.reallyCall(procedure, null, null, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Class<T> resultType) {
        return this.reallyCall(procedure, null, null, null, null, resultType);
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, CallOptions options, Object ... args) {
        return this.reallyCall(procedure, Arrays.asList(args), null, options, null, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, TypeReference<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, null, null, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Class<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, null, null, options, null, resultType);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, TypeReference<T> resultType) {
        return this.reallyCall(procedure, args, null, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Class<T> resultType) {
        return this.reallyCall(procedure, args, null, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, TypeReference<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, args, null, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Class<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, args, null, options, null, resultType);
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, Map<String, Object> kwargs) {
        return this.reallyCall(procedure, null, kwargs, null, null, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Map<String, Object> kwargs, TypeReference<T> resultType) {
        return this.reallyCall(procedure, null, kwargs, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Map<String, Object> kwargs, Class<T> resultType) {
        return this.reallyCall(procedure, null, kwargs, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Map<String, Object> kwargs, TypeReference<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, null, kwargs, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, Map<String, Object> kwargs, Class<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, null, kwargs, options, null, resultType);
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, Map<String, Object> kwargs, CallOptions options) {
        return this.reallyCall(procedure, null, kwargs, options, null, null);
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, List<Object> args, Map<String, Object> kwargs, CallOptions options) {
        return this.reallyCall(procedure, args, kwargs, options, null, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Map<String, Object> kwargs, TypeReference<T> resultType) {
        return this.reallyCall(procedure, args, kwargs, null, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Map<String, Object> kwargs, Class<T> resultType) {
        return this.reallyCall(procedure, args, kwargs, null, null, resultType);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Map<String, Object> kwargs, TypeReference<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, args, kwargs, options, resultType, null);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Map<String, Object> kwargs, Class<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, args, kwargs, options, null, resultType);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, TypeReference<T> resultType, CallOptions options, Object ... args) {
        return this.reallyCall(procedure, Arrays.asList(args), null, options, resultType, null);
    }

    private CompletableFuture<SessionDetails> reallyJoin(String realm, List<IAuthenticator> authenticators) {
        LOGGER.d("Called join() with realm=" + realm);
        this.mRealm = realm;
        this.mAuthenticators = authenticators;
        this.mGoodbyeSent = false;
        HashMap<String, Map> roles = new HashMap<String, Map>();
        roles.put("publisher", new HashMap());
        roles.put("subscriber", new HashMap());
        roles.put("caller", new HashMap());
        roles.put("callee", new HashMap());
        if (this.mAuthenticators == null) {
            this.send(new Hello(realm, roles));
        } else {
            ArrayList<String> authMethods = new ArrayList<String>();
            String authID = null;
            Map<String, Object> authextra = null;
            for (IAuthenticator authenticator : this.mAuthenticators) {
                IAuthenticator auth;
                authMethods.add(authenticator.getAuthMethod());
                if (authenticator.getAuthMethod().equals("ticket")) {
                    auth = (TicketAuth)authenticator;
                    authID = auth.authid;
                    continue;
                }
                if (authenticator.getAuthMethod().equals("wampcra")) {
                    auth = (ChallengeResponseAuth)authenticator;
                    authID = ((ChallengeResponseAuth)auth).authid;
                    continue;
                }
                if (!authenticator.getAuthMethod().equals("cryptosign")) continue;
                auth = (CryptosignAuth)authenticator;
                authID = ((CryptosignAuth)auth).authid;
                authextra = ((CryptosignAuth)auth).authextra;
            }
            this.send(new Hello(realm, roles, authMethods, authID, authextra));
        }
        this.mJoinFuture = new CompletableFuture();
        this.mState = 2;
        return this.mJoinFuture;
    }

    @Override
    public CompletableFuture<SessionDetails> join(String realm) {
        return this.reallyJoin(realm, null);
    }

    @Override
    public CompletableFuture<SessionDetails> join(String realm, List<IAuthenticator> authenticators) {
        return this.reallyJoin(realm, authenticators);
    }

    @Override
    public void leave() {
        this.leave(null, null);
    }

    @Override
    public void leave(String reason) {
        this.leave(reason, null);
    }

    @Override
    public void leave(String reason, String message) {
        LOGGER.d(String.format("reason=%s message=%s", reason, message));
        this.send(new Goodbye(reason, message));
        this.mState = 6;
    }

    public ISession.OnJoinListener addOnJoinListener(ISession.OnJoinListener listener) {
        return this.addListener(this.mOnJoinListeners, listener);
    }

    public void removeOnJoinListener(ISession.OnJoinListener listener) {
        this.removeListener(this.mOnJoinListeners, listener);
    }

    public ISession.OnReadyListener adOnReadyListener(ISession.OnReadyListener listener) {
        return this.addListener(this.mOnReadyListeners, listener);
    }

    public void removeOnReadyListener(ISession.OnReadyListener listener) {
        this.removeListener(this.mOnReadyListeners, listener);
    }

    public ISession.OnLeaveListener addOnLeaveListener(ISession.OnLeaveListener listener) {
        return this.addListener(this.mOnLeaveListeners, listener);
    }

    public void removeOnLeaveListener(ISession.OnLeaveListener listener) {
        this.removeListener(this.mOnLeaveListeners, listener);
    }

    public ISession.OnConnectListener addOnConnectListener(ISession.OnConnectListener listener) {
        return this.addListener(this.mOnConnectListeners, listener);
    }

    public void removeOnConnectListener(ISession.OnConnectListener listener) {
        this.removeListener(this.mOnConnectListeners, listener);
    }

    public ISession.OnDisconnectListener addOnDisconnectListener(ISession.OnDisconnectListener listener) {
        return this.addListener(this.mOnDisconnectListeners, listener);
    }

    public void removeOnDisconnectListener(ISession.OnDisconnectListener listener) {
        this.removeListener(this.mOnDisconnectListeners, listener);
    }

    public ISession.OnUserErrorListener addOnUserErrorListener(ISession.OnUserErrorListener listener) {
        return this.addListener(this.mOnUserErrorListeners, listener);
    }

    public void removeOnUserErrorListener(ISession.OnUserErrorListener listener) {
        this.removeListener(this.mOnUserErrorListeners, listener);
    }

    private <T> T addListener(ArrayList<T> listeners, T listener) {
        listeners.add(listener);
        return listener;
    }

    private <T> void removeListener(ArrayList<T> listeners, T listener) {
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
    }

    public ReflectionServices getReflectionServices() {
        return this.mReflectionServices;
    }

    private static /* synthetic */ void lambda$onMessage$15(TriFunction handler, Object arg, Event msg, EventDetails details) {
        handler.apply(arg, msg.kwargs, details);
    }

    private static /* synthetic */ void lambda$onMessage$14(TriConsumer handler, Object arg, Event msg, EventDetails details) {
        handler.accept(arg, msg.kwargs, details);
    }

    private static /* synthetic */ void lambda$onMessage$13(BiFunction handler, Object arg, EventDetails details) {
        handler.apply(arg, details);
    }

    private static /* synthetic */ void lambda$onMessage$12(BiConsumer handler, Object arg, EventDetails details) {
        handler.accept(arg, details);
    }

    private static /* synthetic */ void lambda$onMessage$11(Function handler, Object arg) {
        handler.apply(arg);
    }

    private static /* synthetic */ void lambda$onMessage$10(Consumer handler, Object arg) {
        handler.accept(arg);
    }
}

