/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.reflectionRoles;

import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.reflectionRoles.ParameterInfo;
import io.crossbar.autobahn.wamp.utils.Platform;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;

public class ArgumentUnpacker {
    private final ParameterInfo[] mParameters;

    public ArgumentUnpacker(Method method) {
        if (!Platform.isAndroid() || Platform.getAndroidAPIVersion() >= 26) {
            Parameter[] parameters = method.getParameters();
            this.mParameters = new ParameterInfo[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                String parameterName = parameter.getName();
                Class<?> parameterType = parameter.getType();
                this.mParameters[i] = new ParameterInfo(i, parameterName, parameterType);
            }
        } else {
            Class<?>[] parameterTypes = method.getParameterTypes();
            this.mParameters = new ParameterInfo[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String parameterName = "arg" + i;
                Class<?> parameterType = parameterTypes[i];
                this.mParameters[i] = new ParameterInfo(i, parameterName, parameterType);
            }
        }
    }

    public Object[] unpackParameters(ISerializer serializer, List<Object> list, Map<String, Object> map) {
        int i;
        Object[] result = new Object[this.mParameters.length];
        int namedParametersStartPosition = 0;
        if (list != null) {
            namedParametersStartPosition = list.size();
            for (i = 0; i < list.size(); ++i) {
                result[i] = serializer.convertValue(list.get(i), this.mParameters[i].getType());
            }
        }
        if (map != null) {
            for (i = namedParametersStartPosition; i < this.mParameters.length; ++i) {
                ParameterInfo currentParameter = this.mParameters[i];
                String parameterName = currentParameter.getName();
                if (!map.containsKey(parameterName)) continue;
                result[i] = serializer.convertValue(map.get(parameterName), currentParameter.getType());
            }
        }
        return result;
    }
}

