/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.utils;

import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.utils.CurrentThreadExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class Platform {
    private static boolean IS_PLATFORM_CHECKED = false;
    private static boolean IS_ANDROID = false;

    public static boolean isAndroid() {
        if (!IS_PLATFORM_CHECKED) {
            IS_ANDROID = System.getProperty("java.vendor").equals("The Android Project");
            IS_PLATFORM_CHECKED = true;
        }
        return IS_ANDROID;
    }

    public static int getAndroidAPIVersion() {
        if (Platform.isAndroid()) {
            try {
                Class<?> klass = Class.forName("android.os.Build$VERSION");
                return klass.getField("SDK_INT").getInt(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return 0;
    }

    public static ITransport autoSelectTransport(String webSocketURL) throws RuntimeException {
        try {
            Class<?> transportClass = Platform.isAndroid() ? Class.forName("io.crossbar.autobahn.wamp.transports.AndroidWebSocket") : Class.forName("io.crossbar.autobahn.wamp.transports.NettyWebSocket");
            return (ITransport)transportClass.getConstructor(String.class).newInstance(webSocketURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Executor autoSelectExecutor() {
        if (Platform.isAndroid()) {
            return new CurrentThreadExecutor();
        }
        return ForkJoinPool.commonPool();
    }
}

