/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.transports;

import io.crossbar.autobahn.utils.ABLogger;
import io.crossbar.autobahn.utils.IABLogger;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.transports.NettyWebSocketClientHandler;
import io.crossbar.autobahn.wamp.types.WebSocketOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;

public class NettyWebSocket
implements ITransport {
    private static final IABLogger LOGGER = ABLogger.getLogger(NettyWebSocket.class.getName());
    private static final String SERIALIZERS_DEFAULT = String.format("%s,%s,%s", "wamp.2.cbor", "wamp.2.msgpack", "wamp.2.json");
    private Channel mChannel;
    private NettyWebSocketClientHandler mHandler;
    private final String mUri;
    private Executor mExecutor;
    private WebSocketOptions mOptions;
    private List<String> mSerializers;

    public NettyWebSocket(String uri) {
        this.mUri = uri;
    }

    public NettyWebSocket(String uri, List<String> serializers) {
        this.mUri = uri;
        this.mSerializers = serializers;
    }

    public NettyWebSocket(String uri, WebSocketOptions options) {
        this(uri);
        this.mOptions = options;
    }

    public NettyWebSocket(String uri, List<String> serializers, WebSocketOptions options) {
        this.mUri = uri;
        this.mSerializers = serializers;
        this.mOptions = options;
    }

    private WebSocketOptions getOptions() {
        return this.mOptions == null ? new WebSocketOptions() : this.mOptions;
    }

    private int validateURIAndGetPort(URI uri) {
        String scheme = uri.getScheme();
        if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("Only WS(S) is supported.");
        }
        int port = uri.getPort();
        if (port == -1) {
            if ("ws".equalsIgnoreCase(scheme)) {
                port = 80;
            } else if ("wss".equalsIgnoreCase(scheme)) {
                port = 443;
            }
        }
        return port;
    }

    private SslContext getSSLContext(String scheme) throws SSLException {
        return "wss".equalsIgnoreCase(scheme) ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
    }

    private String getSerializers() {
        if (this.mSerializers != null) {
            StringBuilder result = new StringBuilder();
            for (String serializer : this.mSerializers) {
                result.append(serializer).append(",");
            }
            return result.toString();
        }
        return SERIALIZERS_DEFAULT;
    }

    @Override
    public void connect(ITransportHandler transportHandler) throws Exception {
        URI uri = new URI(this.mUri);
        final int port = this.validateURIAndGetPort(uri);
        String scheme = uri.getScheme();
        final String host = uri.getHost();
        final SslContext sslContext = this.getSSLContext(scheme);
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)this.getSerializers(), (boolean)true, (HttpHeaders)new DefaultHttpHeaders(), (int)this.getOptions().getMaxFramePayloadSize());
        this.mHandler = new NettyWebSocketClientHandler(handshaker, this, transportHandler);
        NioEventLoopGroup group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)group);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline channelPipeline = ch.pipeline();
                if (sslContext != null) {
                    channelPipeline.addLast(new ChannelHandler[]{sslContext.newHandler(ch.alloc(), host, port)});
                }
                channelPipeline.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, new IdleStateHandler(15L, 10L, 20L, TimeUnit.SECONDS), NettyWebSocket.this.mHandler});
            }
        });
        this.mChannel = bootstrap.connect(uri.getHost(), port).sync().channel();
        this.mHandler.getHandshakeFuture().sync();
    }

    @Override
    public void send(byte[] payload, boolean isBinary) {
        Object frame = isBinary ? new BinaryWebSocketFrame(this.toByteBuf(payload)) : new TextWebSocketFrame(this.toByteBuf(payload));
        this.mChannel.writeAndFlush(frame);
    }

    @Override
    public boolean isOpen() {
        return this.mChannel != null && this.mChannel.isOpen();
    }

    @Override
    public void close() throws Exception {
        LOGGER.v("close()");
        if (this.mHandler != null && this.mChannel != null) {
            this.mHandler.close(this.mChannel, true);
        }
    }

    @Override
    public void abort() throws Exception {
        LOGGER.v("abort()");
        this.close();
    }

    private ByteBuf toByteBuf(byte[] bytes) {
        return Unpooled.copiedBuffer((byte[])bytes);
    }
}

