/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Event
implements IMessage {
    public static final int MESSAGE_TYPE = 36;
    public final long subscription;
    public final long publication;
    public final String topic;
    public final boolean retained;
    public final List<Object> args;
    public final Map<String, Object> kwargs;

    public Event(long subscription, long publication, String topic, boolean retained, List<Object> args, Map<String, Object> kwargs) {
        this.subscription = subscription;
        this.publication = publication;
        this.topic = topic;
        this.retained = retained;
        this.args = args;
        this.kwargs = kwargs;
    }

    public static Event parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 36, "EVENT", 3, 6);
        long subscription = (Long)wmsg.get(1);
        long publication = (Long)wmsg.get(2);
        Map details = (Map)wmsg.get(3);
        String topic = (String)details.get("topic");
        boolean retained = Shortcuts.getOrDefault(details, "retained", false);
        List args = null;
        if (wmsg.size() > 4) {
            if (wmsg.get(4) instanceof byte[]) {
                throw new ProtocolError("Binary payload not supported");
            }
            args = (List)wmsg.get(4);
        }
        Map kwargs = null;
        if (wmsg.size() > 5) {
            kwargs = (Map)wmsg.get(5);
        }
        return new Event(subscription, publication, topic, retained, args, kwargs);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(36);
        marshaled.add(this.subscription);
        marshaled.add(this.publication);
        HashMap<String, Object> details = new HashMap<String, Object>();
        if (this.topic != null) {
            details.put("topic", this.topic);
        }
        if (this.retained) {
            details.put("retained", this.retained);
        }
        marshaled.add(details);
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

