/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Call
implements IMessage {
    public static final int MESSAGE_TYPE = 48;
    private static final int TIMEOUT_DEFAULT = 0;
    public final long request;
    public final String procedure;
    public final List<Object> args;
    public final Map<String, Object> kwargs;
    public final int timeout;

    public Call(long request, String procedure, List<Object> args, Map<String, Object> kwargs, int timeout) {
        this.request = request;
        this.procedure = procedure;
        this.args = args;
        this.kwargs = kwargs;
        this.timeout = timeout < 1 ? 0 : timeout;
    }

    public static Call parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 48, "CALL", 4);
        long request = MessageUtil.parseRequestID(wmsg.get(1));
        Map options = (Map)wmsg.get(2);
        String procedure = (String)wmsg.get(3);
        List args = null;
        if (wmsg.size() > 4) {
            if (wmsg.get(4) instanceof byte[]) {
                throw new ProtocolError("Binary payload not supported");
            }
            args = (List)wmsg.get(4);
        }
        Map kwargs = null;
        if (wmsg.size() > 5) {
            kwargs = (Map)wmsg.get(5);
        }
        int timeout = Shortcuts.getOrDefault(options, "timeout", 0);
        return new Call(request, procedure, args, kwargs, timeout);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(48);
        marshaled.add(this.request);
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        if (this.timeout > 0) {
            options.put("timeout", this.timeout);
        }
        marshaled.add(options);
        marshaled.add(this.procedure);
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

