/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.utils;

import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.utils.CurrentThreadExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;

public class Platform {
    public static boolean isAndroid() {
        return System.getProperty("java.vendor").equals("The Android Project");
    }

    public static ITransport autoSelectTransport(String webSocketURL) throws RuntimeException {
        try {
            Class<?> transportClass = Platform.isAndroid() ? Class.forName("io.crossbar.autobahn.wamp.transports.AndroidWebSocket") : Class.forName("io.crossbar.autobahn.wamp.transports.NettyWebSocket");
            return (ITransport)transportClass.getConstructor(String.class).newInstance(webSocketURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Executor autoSelectExecutor() {
        if (Platform.isAndroid()) {
            return new CurrentThreadExecutor();
        }
        return ForkJoinPool.commonPool();
    }
}

