/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.interfaces;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;

public abstract class ISerializer {
    public final ObjectMapper mapper;

    public ISerializer(JsonFactory factor) {
        this.mapper = new ObjectMapper(factor);
    }

    public byte[] serialize(List<Object> message) {
        try {
            return this.mapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Object> unserialize(byte[] payload, boolean isBinary) {
        try {
            return (List)this.mapper.readValue(payload, (TypeReference)new TypeReference<List<Object>>(){});
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T convertValue(Object fromValue, TypeReference toValueTypeRef) {
        return (T)this.mapper.convertValue(fromValue, toValueTypeRef);
    }

    public boolean isBinary() {
        return true;
    }
}

