/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Unregistered
implements IMessage {
    public static final int MESSAGE_TYPE = 67;
    private static final long REGISTRATION_NULL = -1L;
    private final long request;
    private final long registration;
    private final String reason;

    public Unregistered(long request, long registration, String reason) {
        this.request = request;
        this.registration = registration;
        this.reason = reason;
    }

    public static Unregistered parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 67, "UNREGISTERED", 2, 3);
        long registration = -1L;
        String reason = null;
        if (wmsg.size() > 2) {
            Map details = (Map)wmsg.get(2);
            registration = Shortcuts.getOrDefault(details, "registration", registration);
            reason = Shortcuts.getOrDefault(details, "reason", reason);
        }
        return new Unregistered(MessageUtil.parseRequestID(wmsg.get(1)), registration, reason);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(67);
        marshaled.add(this.request);
        if (this.registration != -1L || this.reason != null) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            if (this.reason != null) {
                details.put("reason", this.reason);
            }
            if (this.registration != -1L) {
                details.put("registration", this.registration);
            }
            marshaled.add(details);
        }
        return marshaled;
    }
}

