/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Interrupt
implements IMessage {
    public static final int MESSAGE_TYPE = 69;
    private static final String ABORT = "abort";
    private static final String KILL = "kill";
    public final long request;
    public final String mode;

    public Interrupt(long request, String mode) {
        this.request = request;
        this.mode = mode;
    }

    public static Interrupt parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 69, "INTERRUPT", 3);
        long request = MessageUtil.parseRequestID(wmsg.get(1));
        Map options = (Map)wmsg.get(2);
        String mode = Shortcuts.getOrDefault(options, "mode", null);
        if (mode != null && !mode.equals(ABORT) && !mode.equals(KILL)) {
            throw new ProtocolError(String.format("invalid value %s for 'mode' option in INTERRUPT", mode));
        }
        return new Interrupt(request, mode);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(69);
        marshaled.add(this.request);
        if (this.mode != null) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("mode", this.mode);
            marshaled.add(options);
        } else {
            marshaled.add(Collections.emptyMap());
        }
        return marshaled;
    }
}

