/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Cancel
implements IMessage {
    public static final int MESSAGE_TYPE = 49;
    private static final String SKIP = "skip";
    private static final String ABORT = "abort";
    private static final String KILL = "kill";
    public final long request;
    public final String mode;

    public Cancel(long request, String mode) {
        this.request = request;
        if (!(mode == null || mode.equals(SKIP) || mode.equals(ABORT) || mode.equals(KILL))) {
            throw new IllegalArgumentException("mode must either be skip, abort or kill");
        }
        this.mode = mode;
    }

    public static Cancel parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 49, "CANCEL", 3);
        long request = MessageUtil.parseRequestID(wmsg.get(1));
        Map options = (Map)wmsg.get(2);
        String mode = Shortcuts.getOrDefault(options, "mode", null);
        return new Cancel(request, mode);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(49);
        marshaled.add(this.request);
        if (this.mode != null) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("mode", this.mode);
            marshaled.add(options);
        } else {
            marshaled.add(Collections.emptyMap());
        }
        return marshaled;
    }
}

