/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp;

import io.crossbar.autobahn.wamp.Session;
import io.crossbar.autobahn.wamp.interfaces.IAuthenticator;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.types.ExitInfo;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Logger;

public class Client {
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    private final List<ITransport> mTransports;
    private Session mSession;
    private String mRealm;
    private List<IAuthenticator> mAuthenticators;
    private ExecutorService mExecutor;

    public Client(List<ITransport> transports) {
        this.mTransports = transports;
    }

    public Client(List<ITransport> transports, ExecutorService executor) {
        this(transports);
        this.mExecutor = executor;
    }

    private ExecutorService getExecutor() {
        return this.mExecutor == null ? ForkJoinPool.commonPool() : this.mExecutor;
    }

    public void add(Session session, String realm, List<IAuthenticator> authenticators) {
        if (this.mSession != null) {
            throw new IllegalStateException("Addition of multiple sessions not implemented");
        }
        this.mSession = session;
        this.mRealm = realm;
        this.mAuthenticators = authenticators;
    }

    public CompletableFuture<ExitInfo> connect() {
        CompletableFuture<ExitInfo> exitFuture = new CompletableFuture<ExitInfo>();
        this.mSession.addOnConnectListener(session -> this.mSession.join(this.mRealm, null).thenAccept(details -> LOGGER.info(String.format("JOINED session=%s realm=%s", details.sessionID, details.realm))));
        this.mSession.addOnDisconnectListener((session, wasClean) -> exitFuture.complete(new ExitInfo(wasClean)));
        CompletableFuture.runAsync(() -> {
            try {
                this.mTransports.get(0).connect(this.mSession);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.getExecutor());
        return exitFuture;
    }
}

