/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp.messages;

import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.utils.MessageUtil;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Publish
implements IMessage {
    public static final int MESSAGE_TYPE = 16;
    public final long request;
    public final String topic;
    public final List<Object> args;
    public final Map<String, Object> kwargs;
    public final boolean acknowledge;
    public final boolean excludeMe;
    public final boolean retain;

    public Publish(long request, String topic, List<Object> args, Map<String, Object> kwargs, boolean acknowledge, boolean excludeMe, boolean retain) {
        this.request = request;
        this.topic = topic;
        this.args = args;
        this.kwargs = kwargs;
        this.acknowledge = acknowledge;
        this.excludeMe = excludeMe;
        this.retain = retain;
    }

    public static Publish parse(List<Object> wmsg) {
        MessageUtil.validateMessage(wmsg, 16, "PUBLISH", 4, 6);
        long request = MessageUtil.parseRequestID(wmsg.get(1));
        Map options = (Map)wmsg.get(2);
        String topic = (String)wmsg.get(3);
        List args = null;
        if (wmsg.size() > 4) {
            if (wmsg.get(4) instanceof byte[]) {
                throw new ProtocolError("Binary payload not supported");
            }
            args = (List)wmsg.get(4);
        }
        Map kwargs = null;
        if (wmsg.size() > 5) {
            kwargs = (Map)wmsg.get(5);
        }
        boolean acknowledge = Shortcuts.getOrDefault(options, "acknowledge", false);
        boolean excludeMe = Shortcuts.getOrDefault(options, "exclude_me", true);
        boolean retain = Shortcuts.getOrDefault(options, "retain", false);
        return new Publish(request, topic, args, kwargs, acknowledge, excludeMe, retain);
    }

    @Override
    public List<Object> marshal() {
        ArrayList<Object> marshaled = new ArrayList<Object>();
        marshaled.add(16);
        marshaled.add(this.request);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        if (this.acknowledge) {
            options.put("acknowledge", this.acknowledge);
        }
        if (!this.excludeMe) {
            options.put("exclude_me", this.excludeMe);
        }
        if (this.retain) {
            options.put("retain", this.retain);
        }
        marshaled.add(options);
        marshaled.add(this.topic);
        if (this.kwargs != null) {
            if (this.args == null) {
                marshaled.add(Collections.emptyList());
            } else {
                marshaled.add(this.args);
            }
            marshaled.add(this.kwargs);
        } else if (this.args != null) {
            marshaled.add(this.args);
        }
        return marshaled;
    }
}

