/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.wamp;

import com.fasterxml.jackson.core.type.TypeReference;
import io.crossbar.autobahn.wamp.exceptions.ApplicationError;
import io.crossbar.autobahn.wamp.exceptions.ProtocolError;
import io.crossbar.autobahn.wamp.interfaces.IInvocationHandler;
import io.crossbar.autobahn.wamp.interfaces.IMessage;
import io.crossbar.autobahn.wamp.interfaces.ISerializer;
import io.crossbar.autobahn.wamp.interfaces.ISession;
import io.crossbar.autobahn.wamp.interfaces.ITransport;
import io.crossbar.autobahn.wamp.interfaces.ITransportHandler;
import io.crossbar.autobahn.wamp.interfaces.TriConsumer;
import io.crossbar.autobahn.wamp.interfaces.TriFunction;
import io.crossbar.autobahn.wamp.messages.Abort;
import io.crossbar.autobahn.wamp.messages.Call;
import io.crossbar.autobahn.wamp.messages.Error;
import io.crossbar.autobahn.wamp.messages.Event;
import io.crossbar.autobahn.wamp.messages.Goodbye;
import io.crossbar.autobahn.wamp.messages.Hello;
import io.crossbar.autobahn.wamp.messages.Invocation;
import io.crossbar.autobahn.wamp.messages.MessageMap;
import io.crossbar.autobahn.wamp.messages.Publish;
import io.crossbar.autobahn.wamp.messages.Published;
import io.crossbar.autobahn.wamp.messages.Register;
import io.crossbar.autobahn.wamp.messages.Registered;
import io.crossbar.autobahn.wamp.messages.Result;
import io.crossbar.autobahn.wamp.messages.Subscribe;
import io.crossbar.autobahn.wamp.messages.Subscribed;
import io.crossbar.autobahn.wamp.messages.Welcome;
import io.crossbar.autobahn.wamp.messages.Yield;
import io.crossbar.autobahn.wamp.requests.CallRequest;
import io.crossbar.autobahn.wamp.requests.PublishRequest;
import io.crossbar.autobahn.wamp.requests.RegisterRequest;
import io.crossbar.autobahn.wamp.requests.SubscribeRequest;
import io.crossbar.autobahn.wamp.types.CallOptions;
import io.crossbar.autobahn.wamp.types.CallResult;
import io.crossbar.autobahn.wamp.types.CloseDetails;
import io.crossbar.autobahn.wamp.types.EventDetails;
import io.crossbar.autobahn.wamp.types.InvocationDetails;
import io.crossbar.autobahn.wamp.types.InvocationResult;
import io.crossbar.autobahn.wamp.types.Publication;
import io.crossbar.autobahn.wamp.types.PublishOptions;
import io.crossbar.autobahn.wamp.types.ReceptionResult;
import io.crossbar.autobahn.wamp.types.RegisterOptions;
import io.crossbar.autobahn.wamp.types.Registration;
import io.crossbar.autobahn.wamp.types.SessionDetails;
import io.crossbar.autobahn.wamp.types.SubscribeOptions;
import io.crossbar.autobahn.wamp.types.Subscription;
import io.crossbar.autobahn.wamp.utils.IDGenerator;
import io.crossbar.autobahn.wamp.utils.Shortcuts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class Session
implements ISession,
ITransportHandler {
    private static final Logger LOGGER = Logger.getLogger(Session.class.getName());
    private final int STATE_DISCONNECTED = 1;
    private final int STATE_HELLO_SENT = 2;
    private final int STATE_AUTHENTICATE_SENT = 3;
    private final int STATE_JOINED = 4;
    private final int STATE_READY = 5;
    private final int STATE_GOODBYE_SENT = 6;
    private final int STATE_ABORT_SENT = 7;
    private ITransport mTransport;
    private ISerializer mSerializer;
    private ExecutorService mExecutor;
    private CompletableFuture<SessionDetails> mJoinFuture;
    private final ArrayList<ISession.OnJoinListener> mOnJoinListeners = new ArrayList();
    private final ArrayList<ISession.OnReadyListener> mOnReadyListeners = new ArrayList();
    private final ArrayList<ISession.OnLeaveListener> mOnLeaveListeners = new ArrayList();
    private final ArrayList<ISession.OnConnectListener> mOnConnectListeners = new ArrayList();
    private final ArrayList<ISession.OnDisconnectListener> mOnDisconnectListeners = new ArrayList();
    private final ArrayList<ISession.OnUserErrorListener> mOnUserErrorListeners = new ArrayList();
    private final IDGenerator mIDGenerator = new IDGenerator();
    private final Map<Long, CallRequest> mCallRequests = new HashMap<Long, CallRequest>();
    private final Map<Long, SubscribeRequest> mSubscribeRequests = new HashMap<Long, SubscribeRequest>();
    private final Map<Long, PublishRequest> mPublishRequests = new HashMap<Long, PublishRequest>();
    private final Map<Long, RegisterRequest> mRegisterRequest = new HashMap<Long, RegisterRequest>();
    private final Map<Long, List<Subscription>> mSubscriptions = new HashMap<Long, List<Subscription>>();
    private final Map<Long, Registration> mRegistrations = new HashMap<Long, Registration>();
    private int mState = 1;
    private long mSessionID;
    private boolean mGoodbyeSent;
    private String mRealm;

    public Session() {
    }

    public Session(ExecutorService executor) {
        this();
        this.mExecutor = executor;
    }

    public long getID() {
        return this.mSessionID;
    }

    private ExecutorService getExecutor() {
        return this.mExecutor == null ? ForkJoinPool.commonPool() : this.mExecutor;
    }

    private void throwIfNotConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("The transport must be connected first");
        }
    }

    @Override
    public void onConnect(ITransport transport, ISerializer serializer) throws Exception {
        LOGGER.info("onConnect()");
        if (this.mTransport != null) {
            throw new Exception("already connected");
        }
        this.mTransport = transport;
        this.mSerializer = serializer;
        for (ISession.OnConnectListener listener : this.mOnConnectListeners) {
            listener.onConnect(this);
        }
    }

    private void send(IMessage message) {
        if (!this.isConnected()) {
            throw new IllegalStateException("no transport");
        }
        byte[] payload = this.mSerializer.serialize(message.marshal());
        LOGGER.info("  >>> TX : " + message);
        this.mTransport.send(payload, this.mSerializer.isBinary());
    }

    @Override
    public void onMessage(byte[] payload, boolean isBinary) throws Exception {
        List<Object> rawMessage = this.mSerializer.unserialize(payload, isBinary);
        try {
            int messageType = (Integer)rawMessage.get(0);
            Class<? extends IMessage> messageKlass = MessageMap.MESSAGE_TYPE_MAP.get(messageType);
            IMessage message = (IMessage)messageKlass.getMethod("parse", List.class).invoke(null, rawMessage);
            this.onMessage(message);
        }
        catch (Exception e) {
            LOGGER.info("mapping received message bytes to IMessage failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onMessage(IMessage message) throws Exception {
        LOGGER.info("  <<< RX : " + message);
        if (this.mSessionID == 0L) {
            if (message instanceof Welcome) {
                this.mState = 4;
                Welcome msg = (Welcome)message;
                this.mSessionID = msg.session;
                SessionDetails sessionDetails = new SessionDetails(msg.realm, msg.session);
                this.mJoinFuture.complete(sessionDetails);
                ArrayList futures = new ArrayList();
                for (ISession.OnJoinListener listener : this.mOnJoinListeners) {
                    futures.add(CompletableFuture.runAsync(() -> listener.onJoin(this, sessionDetails), this.getExecutor()));
                }
                CompletableFuture d = this.combineFutures(futures);
                d.thenRunAsync(() -> {
                    this.mState = 5;
                    for (ISession.OnReadyListener listener : this.mOnReadyListeners) {
                        listener.onReady(this);
                    }
                }, this.getExecutor());
                return;
            } else if (message instanceof Abort) {
                Abort abortMessage = (Abort)message;
                CloseDetails closeDetails = new CloseDetails(abortMessage.reason, abortMessage.message);
                ArrayList futures = new ArrayList();
                for (ISession.OnLeaveListener listener : this.mOnLeaveListeners) {
                    futures.add(CompletableFuture.runAsync(() -> listener.onLeave(this, closeDetails), this.getExecutor()));
                }
                CompletableFuture d = this.combineFutures(futures);
                d.thenRun(() -> {
                    LOGGER.info("Notified Session.onLeave listeners, now closing transport");
                    this.mState = 1;
                    if (this.mTransport != null && this.mTransport.isOpen()) {
                        try {
                            this.mTransport.close();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }
                });
                return;
            } else {
                LOGGER.info("FIXME (no session): unprocessed message:");
                LOGGER.info(message.toString());
            }
            return;
        } else if (message instanceof Result) {
            Result msg = (Result)message;
            CallRequest callRequest = Shortcuts.getOrDefault(this.mCallRequests, msg.request, null);
            if (callRequest == null) throw new ProtocolError(String.format("RESULT received for non-pending request ID %s", msg.request));
            this.mCallRequests.remove(msg.request);
            if (callRequest.resultType != null) {
                callRequest.onReply.complete(this.mSerializer.convertValue(msg.args.get(0), callRequest.resultType));
                return;
            } else {
                callRequest.onReply.complete(new CallResult(msg.args, msg.kwargs));
            }
            return;
        } else if (message instanceof Subscribed) {
            Subscribed msg = (Subscribed)message;
            SubscribeRequest subscribeRequest = Shortcuts.getOrDefault(this.mSubscribeRequests, msg.request, null);
            if (subscribeRequest == null) throw new ProtocolError(String.format("SUBSCRIBED received for non-pending request ID %s", msg.request));
            this.mSubscribeRequests.remove(msg.request);
            if (!this.mSubscriptions.containsKey(msg.subscription)) {
                this.mSubscriptions.put(msg.subscription, new ArrayList());
            }
            Subscription subscription = new Subscription(msg.subscription, subscribeRequest.topic, subscribeRequest.handler);
            this.mSubscriptions.get(msg.subscription).add(subscription);
            subscribeRequest.onReply.complete(subscription);
            return;
        } else if (message instanceof Event) {
            Event msg = (Event)message;
            List list = Shortcuts.getOrDefault(this.mSubscriptions, msg.subscription, null);
            if (list == null) {
                throw new ProtocolError(String.format("EVENT received for non-subscribed subscription ID %s", msg.subscription));
            }
            ArrayList futures = new ArrayList();
            for (Subscription subscription : list) {
                Object handler;
                EventDetails details = new EventDetails(subscription, msg.publication, msg.topic != null ? msg.topic : subscription.topic, msg.retained, -1L, null, null, this);
                CompletableFuture<Void> future = null;
                if (subscription.handler instanceof Consumer) {
                    handler = (Consumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$4((Consumer)handler, msg), this.getExecutor());
                } else if (subscription.handler instanceof Function) {
                    handler = (Function)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$5((Function)handler, msg), this.getExecutor());
                } else if (subscription.handler instanceof BiConsumer) {
                    handler = (BiConsumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$6((BiConsumer)handler, msg, details), this.getExecutor());
                } else if (subscription.handler instanceof BiFunction) {
                    handler = (BiFunction)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$7((BiFunction)handler, msg, details), this.getExecutor());
                } else if (subscription.handler instanceof TriConsumer) {
                    handler = (TriConsumer)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$8((TriConsumer)handler, msg, details), this.getExecutor());
                } else if (subscription.handler instanceof TriFunction) {
                    handler = (TriFunction)subscription.handler;
                    future = CompletableFuture.runAsync(() -> Session.lambda$onMessage$9((TriFunction)handler, msg, details), this.getExecutor());
                }
                futures.add(future);
            }
            this.combineFutures(futures);
            return;
        } else if (message instanceof Published) {
            Published msg = (Published)message;
            PublishRequest publishRequest = Shortcuts.getOrDefault(this.mPublishRequests, msg.request, null);
            if (publishRequest == null) throw new ProtocolError(String.format("PUBLISHED received for non-pending request ID %s", msg.request));
            this.mPublishRequests.remove(msg.request);
            Publication publication = new Publication(msg.publication);
            publishRequest.onReply.complete(publication);
            return;
        } else if (message instanceof Registered) {
            Registered msg = (Registered)message;
            RegisterRequest registerRequest = Shortcuts.getOrDefault(this.mRegisterRequest, msg.request, null);
            if (registerRequest == null) throw new ProtocolError(String.format("REGISTERED received for already existing registration ID %s", msg.request));
            this.mRegisterRequest.remove(msg.request);
            Registration registration = new Registration(msg.registration, registerRequest.procedure, registerRequest.endpoint);
            this.mRegistrations.put(msg.registration, registration);
            registerRequest.onReply.complete(registration);
            return;
        } else if (message instanceof Invocation) {
            CompletableFuture result;
            Invocation msg = (Invocation)message;
            Registration registration = Shortcuts.getOrDefault(this.mRegistrations, msg.registration, null);
            if (registration == null) throw new ProtocolError(String.format("INVOCATION received for non-registered registration ID %s", msg.registration));
            InvocationDetails details = new InvocationDetails(registration, registration.procedure, -1L, null, null, this);
            if (registration.endpoint instanceof Supplier) {
                Supplier endpoint = (Supplier)registration.endpoint;
                result = (CompletableFuture)endpoint.get();
            } else if (registration.endpoint instanceof Function) {
                Function endpoint = (Function)registration.endpoint;
                result = (CompletableFuture)endpoint.apply(msg.args);
            } else if (registration.endpoint instanceof BiFunction) {
                BiFunction endpoint = (BiFunction)registration.endpoint;
                result = (CompletableFuture)endpoint.apply(msg.args, details);
            } else if (registration.endpoint instanceof TriFunction) {
                TriFunction endpoint = (TriFunction)registration.endpoint;
                result = (CompletableFuture)endpoint.apply(msg.args, msg.kwargs, details);
            } else {
                IInvocationHandler endpoint = (IInvocationHandler)registration.endpoint;
                result = endpoint.apply(msg.args, msg.kwargs, details);
            }
            result.whenCompleteAsync((invocationResult, invocationException) -> {
                if (invocationException != null) {
                    LOGGER.info("FIXME: send call error: " + invocationException.getMessage());
                } else {
                    this.send(new Yield(msg.request, invocationResult.results, invocationResult.kwresults));
                }
            }, (Executor)this.getExecutor());
            return;
        } else if (message instanceof Goodbye) {
            Goodbye goodbyeMessage = (Goodbye)message;
            CloseDetails closeDetails = new CloseDetails(goodbyeMessage.reason, goodbyeMessage.message);
            ArrayList futures = new ArrayList();
            for (ISession.OnLeaveListener listener : this.mOnLeaveListeners) {
                futures.add(CompletableFuture.runAsync(() -> listener.onLeave(this, closeDetails), this.getExecutor()));
            }
            CompletableFuture d = this.combineFutures(futures);
            d.thenRun(() -> {
                LOGGER.info("Notified Session.onLeave listeners, now closing transport");
                if (this.mTransport != null && this.mTransport.isOpen()) {
                    try {
                        this.mTransport.close();
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }
                this.mState = 1;
            });
            return;
        } else {
            void var3_26;
            if (!(message instanceof Error)) throw new ProtocolError(String.format("Unexpected message %s", message.getClass().getName()));
            Error msg = (Error)message;
            Object var3_21 = null;
            if (msg.requestType == 48 && this.mCallRequests.containsKey(msg.request)) {
                CompletableFuture completableFuture = this.mCallRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mCallRequests.remove(msg.request);
            } else if (msg.requestType == 16 && this.mPublishRequests.containsKey(msg.request)) {
                CompletableFuture<Publication> completableFuture = this.mPublishRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mPublishRequests.remove(msg.request);
            } else if (msg.requestType == 32 && this.mSubscribeRequests.containsKey(msg.request)) {
                CompletableFuture<Subscription> completableFuture = this.mSubscribeRequests.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mSubscribeRequests.remove(msg.request);
            } else if (msg.requestType == 64 && this.mRegisterRequest.containsKey(msg.request)) {
                CompletableFuture<Registration> completableFuture = this.mRegisterRequest.get((Object)Long.valueOf((long)msg.request)).onReply;
                this.mRegisterRequest.remove(msg.request);
            }
            if (var3_26 == null) throw new ProtocolError(String.format("ERROR received for non-pending request_type: %s and request ID %s", msg.requestType, msg.request));
            var3_26.completeExceptionally(new ApplicationError(msg.error));
        }
    }

    @Override
    public void onDisconnect(boolean wasClean) {
        LOGGER.info("onDisconnect(), wasClean=" + wasClean);
        ArrayList futures = new ArrayList();
        for (ISession.OnDisconnectListener listener : this.mOnDisconnectListeners) {
            futures.add(CompletableFuture.runAsync(() -> listener.onDisconnect(this, wasClean), this.getExecutor()));
        }
        CompletableFuture d = this.combineFutures(futures);
        d.thenRun(() -> {
            LOGGER.info("Notified all Session.onDisconnect listeners.");
            this.mTransport = null;
            this.mSerializer = null;
            this.mState = 1;
        });
    }

    @Override
    public boolean isConnected() {
        return this.mTransport != null;
    }

    private CompletableFuture combineFutures(List<CompletableFuture<?>> futures) {
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private CompletableFuture<Subscription> reallySubscribe(String topic, Object handler, SubscribeOptions options) {
        this.throwIfNotConnected();
        CompletableFuture<Subscription> future = new CompletableFuture<Subscription>();
        long requestID = this.mIDGenerator.next();
        this.mSubscribeRequests.put(requestID, new SubscribeRequest(requestID, topic, future, handler));
        this.send(new Subscribe(requestID, options, topic));
        return future;
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Consumer<T> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, Function<T, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiConsumer<T, EventDetails> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    @Override
    public <T> CompletableFuture<Subscription> subscribe(String topic, BiFunction<T, EventDetails, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    @Override
    public <T, U> CompletableFuture<Subscription> subscribe(String topic, TriConsumer<T, U, EventDetails> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    @Override
    public <T, U> CompletableFuture<Subscription> subscribe(String topic, TriFunction<T, U, EventDetails, CompletableFuture<ReceptionResult>> handler, SubscribeOptions options) {
        return this.reallySubscribe(topic, handler, options);
    }

    private CompletableFuture<Publication> reallyPublish(String topic, List<Object> args, Map<String, Object> kwargs, PublishOptions options) {
        this.throwIfNotConnected();
        CompletableFuture<Publication> future = new CompletableFuture<Publication>();
        long requestID = this.mIDGenerator.next();
        this.mPublishRequests.put(requestID, new PublishRequest(requestID, future));
        if (options != null) {
            this.send(new Publish(requestID, topic, args, kwargs, options.acknowledge, options.excludeMe, options.retain));
        } else {
            this.send(new Publish(requestID, topic, args, kwargs, true, true, false));
        }
        return future;
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, List<Object> args, Map<String, Object> kwargs, PublishOptions options) {
        return this.reallyPublish(topic, args, kwargs, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, Object arg, PublishOptions options) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(arg);
        return this.reallyPublish(topic, args, null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, PublishOptions options, Object ... args) {
        return this.reallyPublish(topic, Arrays.asList(args), null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, Object ... args) {
        return this.reallyPublish(topic, Arrays.asList(args), null, null);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic, PublishOptions options) {
        return this.reallyPublish(topic, null, null, options);
    }

    @Override
    public CompletableFuture<Publication> publish(String topic) {
        return this.reallyPublish(topic, null, null, null);
    }

    private CompletableFuture<Registration> reallyRegister(String procedure, Object endpoint, RegisterOptions options) {
        this.throwIfNotConnected();
        CompletableFuture<Registration> future = new CompletableFuture<Registration>();
        long requestID = this.mIDGenerator.next();
        this.mRegisterRequest.put(requestID, new RegisterRequest(requestID, future, procedure, endpoint));
        if (options != null) {
            this.send(new Register(requestID, procedure, options.match, options.invoke));
        } else {
            this.send(new Register(requestID, procedure, null, null));
        }
        return future;
    }

    public CompletableFuture<Registration> register(String procedure, Supplier endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public CompletableFuture<Registration> register(String procedure, IInvocationHandler endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T> CompletableFuture<Registration> register(String procedure, Function<T, CompletableFuture<InvocationResult>> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T> CompletableFuture<Registration> register(String procedure, BiFunction<T, InvocationDetails, CompletableFuture<InvocationResult>> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    @Override
    public <T, U> CompletableFuture<Registration> register(String procedure, TriFunction<T, U, InvocationDetails, CompletableFuture<InvocationResult>> endpoint, RegisterOptions options) {
        return this.reallyRegister(procedure, endpoint, options);
    }

    private <T> CompletableFuture<T> reallyCall(String procedure, List<Object> args, Map<String, Object> kwargs, TypeReference<T> resultType, CallOptions options) {
        this.throwIfNotConnected();
        CompletableFuture future = new CompletableFuture();
        long requestID = this.mIDGenerator.next();
        this.mCallRequests.put(requestID, new CallRequest(requestID, procedure, future, options, resultType));
        if (options == null) {
            this.send(new Call(requestID, procedure, args, kwargs, 0));
        } else {
            this.send(new Call(requestID, procedure, args, kwargs, options.timeout));
        }
        return future;
    }

    @Override
    public CompletableFuture<CallResult> call(String procedure, List<Object> args, Map<String, Object> kwargs, CallOptions options) {
        return this.reallyCall(procedure, args, kwargs, null, options);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, List<Object> args, Map<String, Object> kwargs, TypeReference<T> resultType, CallOptions options) {
        return this.reallyCall(procedure, args, kwargs, resultType, options);
    }

    @Override
    public <T> CompletableFuture<T> call(String procedure, TypeReference<T> resultType, CallOptions options, Object ... args) {
        return this.reallyCall(procedure, Arrays.asList(args), null, resultType, options);
    }

    @Override
    public CompletableFuture<SessionDetails> join(String realm, List<String> authMethods) {
        LOGGER.info("Called join() with realm=" + realm);
        this.mRealm = realm;
        this.mGoodbyeSent = false;
        HashMap<String, Map> roles = new HashMap<String, Map>();
        roles.put("publisher", new HashMap());
        roles.put("subscriber", new HashMap());
        roles.put("caller", new HashMap());
        roles.put("callee", new HashMap());
        this.send(new Hello(realm, roles));
        this.mJoinFuture = new CompletableFuture();
        this.mState = 2;
        return this.mJoinFuture;
    }

    @Override
    public void leave(String reason, String message) {
        LOGGER.info(String.format("reason=%s message=%s", reason, message));
        this.send(new Goodbye(reason, message));
        this.mState = 6;
    }

    public ISession.OnJoinListener addOnJoinListener(ISession.OnJoinListener listener) {
        return this.addListener(this.mOnJoinListeners, listener);
    }

    public void removeOnJoinListener(ISession.OnJoinListener listener) {
        this.removeListener(this.mOnJoinListeners, listener);
    }

    public ISession.OnReadyListener adOnReadyListener(ISession.OnReadyListener listener) {
        return this.addListener(this.mOnReadyListeners, listener);
    }

    public void removeOnReadyListener(ISession.OnReadyListener listener) {
        this.removeListener(this.mOnReadyListeners, listener);
    }

    public ISession.OnLeaveListener addOnLeaveListener(ISession.OnLeaveListener listener) {
        return this.addListener(this.mOnLeaveListeners, listener);
    }

    public void removeOnLeaveListener(ISession.OnLeaveListener listener) {
        this.removeListener(this.mOnLeaveListeners, listener);
    }

    public ISession.OnConnectListener addOnConnectListener(ISession.OnConnectListener listener) {
        return this.addListener(this.mOnConnectListeners, listener);
    }

    public void removeOnConnectListener(ISession.OnConnectListener listener) {
        this.removeListener(this.mOnConnectListeners, listener);
    }

    public ISession.OnDisconnectListener addOnDisconnectListener(ISession.OnDisconnectListener listener) {
        return this.addListener(this.mOnDisconnectListeners, listener);
    }

    public void removeOnDisconnectListener(ISession.OnDisconnectListener listener) {
        this.removeListener(this.mOnDisconnectListeners, listener);
    }

    public ISession.OnUserErrorListener addOnUserErrorListener(ISession.OnUserErrorListener listener) {
        return this.addListener(this.mOnUserErrorListeners, listener);
    }

    public void removeOnUserErrorListener(ISession.OnUserErrorListener listener) {
        this.removeListener(this.mOnUserErrorListeners, listener);
    }

    private <T> T addListener(ArrayList<T> listeners, T listener) {
        listeners.add(listener);
        return listener;
    }

    private <T> void removeListener(ArrayList<T> listeners, T listener) {
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
    }

    private static /* synthetic */ void lambda$onMessage$9(TriFunction handler, Event msg, EventDetails details) {
        handler.apply(msg.args, msg.kwargs, details);
    }

    private static /* synthetic */ void lambda$onMessage$8(TriConsumer handler, Event msg, EventDetails details) {
        handler.accept(msg.args, msg.kwargs, details);
    }

    private static /* synthetic */ void lambda$onMessage$7(BiFunction handler, Event msg, EventDetails details) {
        handler.apply(msg.args.get(0), details);
    }

    private static /* synthetic */ void lambda$onMessage$6(BiConsumer handler, Event msg, EventDetails details) {
        handler.accept(msg.args.get(0), details);
    }

    private static /* synthetic */ void lambda$onMessage$5(Function handler, Event msg) {
        handler.apply(msg.args.get(0));
    }

    private static /* synthetic */ void lambda$onMessage$4(Consumer handler, Event msg) {
        handler.accept(msg.args.get(0));
    }
}

