/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.people.impl;

import org.springframework.social.google.api.impl.AbstractGoogleApiOperations;
import org.springframework.social.google.api.people.PeopleOperations;
import org.springframework.social.google.api.people.PeoplePerson;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class PeopleTemplate
extends AbstractGoogleApiOperations
implements PeopleOperations {
    private static final String PEOPLE_URL = "https://people.googleapis.com/v1/people/";

    public PeopleTemplate(RestTemplate restTemplate, boolean isAuthorized) {
        super(restTemplate, isAuthorized);
    }

    @Override
    public PeoplePerson getPerson(String id) {
        return this.getEntity(PeopleTemplate.buildUrl(PEOPLE_URL + id, "addresses,ageRanges,biographies,birthdays,braggingRights,coverPhotos,emailAddresses,events,genders,imClients,interests,locales,memberships,metadata,names,nicknames,occupations,organizations,phoneNumbers,photos,relations,relationshipInterests,relationshipStatuses,residences,skills,taglines,urls"), PeoplePerson.class);
    }

    @Override
    public PeoplePerson getPerson(String id, String fields) {
        return this.getEntity(PeopleTemplate.buildUrl(PEOPLE_URL + id, fields), PeoplePerson.class);
    }

    @Override
    public PeoplePerson getGoogleProfile() {
        return this.getPerson("me");
    }

    @Override
    public PeoplePerson getGoogleProfile(String fields) {
        return this.getPerson("me", fields);
    }

    private static String buildUrl(String url, String personFieldsValue) {
        return UriComponentsBuilder.fromHttpUrl((String)url).queryParam("personFields", new Object[]{personFieldsValue}).build().toString();
    }
}

