/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.calendar;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.calendar.AttendeeStatus;
import org.springframework.social.google.api.calendar.DisplayMode;
import org.springframework.social.google.api.calendar.EventStatus;
import org.springframework.social.google.api.calendar.NotificationMethod;
import org.springframework.social.google.api.calendar.Transparency;
import org.springframework.social.google.api.calendar.Visibility;
import org.springframework.social.google.api.calendar.impl.DateTimeDeserializer;
import org.springframework.social.google.api.calendar.impl.DateTimeSerializer;
import org.springframework.social.google.api.calendar.impl.TimeZoneDeserializer;
import org.springframework.social.google.api.calendar.impl.TimeZoneSerializer;

public class Event
extends ApiEntity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private EventStatus status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String htmlLink;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    private Date created;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", timezone="UTC")
    private Date updated;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String summary;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String location;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String colorId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Creator creator;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Organizer organizer;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DateTimeTimezone start;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DateTimeTimezone end;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean endTimeUnspecified;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> recurrence;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String recurringEventId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DateTimeTimezone originalStartTime;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Transparency transparency;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Visibility visibility;
    @JsonProperty(value="iCalUID")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String iCalUid;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer sequence;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Attendee> attendees;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean attendeesOmitted;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ExtendedProperties extendedProperties;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String hangoutLink;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Gadget gadget;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean anyoneCanAddSelf;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean guestsCanInviteOthers;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean guestsCanModify;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean guestsCanSeeOtherGuests;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean privateCopy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean locked;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Reminders reminders;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Source source;

    protected Event() {
        this.presetBooleansThatDefaultToTrue();
    }

    private void presetBooleansThatDefaultToTrue() {
        this.guestsCanInviteOthers = true;
        this.guestsCanSeeOtherGuests = true;
    }

    public EventStatus getStatus() {
        return this.status;
    }

    public Event setStatus(EventStatus status) {
        this.status = status;
        return this;
    }

    public String getHtmlLink() {
        return this.htmlLink;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getSummary() {
        return this.summary;
    }

    public Event setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLocation() {
        return this.location;
    }

    public Event setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getColorId() {
        return this.colorId;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public Organizer getOrganizer() {
        return this.organizer;
    }

    public DateTimeTimezone getStart() {
        return this.start;
    }

    public DateTimeTimezone getEnd() {
        return this.end;
    }

    public Boolean isEndTimeUnspecified() {
        return this.endTimeUnspecified;
    }

    public String getRecurringEventId() {
        return this.recurringEventId;
    }

    public DateTimeTimezone getOriginalStartTime() {
        return this.originalStartTime;
    }

    public Transparency getTransparency() {
        return this.transparency;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String getiCalUid() {
        return this.iCalUid;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public Boolean isAttendeesOmitted() {
        return this.attendeesOmitted;
    }

    public String getHangoutLink() {
        return this.hangoutLink;
    }

    public Boolean isAnyoneCanAddSelf() {
        return this.anyoneCanAddSelf;
    }

    public Boolean isGuestsCanInviteOthers() {
        return this.guestsCanInviteOthers;
    }

    public Boolean isGuestsCanModify() {
        return this.guestsCanModify;
    }

    public Boolean isGuestsCanSeeOtherGuests() {
        return this.guestsCanSeeOtherGuests;
    }

    public Boolean isPrivateCopy() {
        return this.privateCopy;
    }

    public Boolean isLocked() {
        return this.locked;
    }

    public List<String> getRecurrence() {
        return this.recurrence;
    }

    public Event setRecurrence(List<String> list) {
        this.recurrence = list;
        return this;
    }

    public List<Attendee> getAttendees() {
        return this.attendees;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.extendedProperties;
    }

    public Gadget getGadget() {
        return this.gadget;
    }

    public Reminders getReminders() {
        return this.reminders;
    }

    public Source getSource() {
        return this.source;
    }

    public Event setGuestsCanInviteOthers(Boolean guestsCanInviteOthers) {
        this.guestsCanInviteOthers = guestsCanInviteOthers;
        return this;
    }

    public Event setGuestsCanSeeOtherGuests(Boolean guestsCanSeeOtherGuests) {
        this.guestsCanSeeOtherGuests = guestsCanSeeOtherGuests;
        return this;
    }

    public static class Source {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String title;

        public String getUrl() {
            return this.url;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class Reminders {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean useDefault;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private List<ReminderOverride> overrides;

        public Boolean isUseDefault() {
            return this.useDefault;
        }

        public List<ReminderOverride> getOverrides() {
            return this.overrides;
        }
    }

    public static class ReminderOverride {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private NotificationMethod method;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer minutes;

        public NotificationMethod getMethod() {
            return this.method;
        }

        public Integer getMinutes() {
            return this.minutes;
        }
    }

    public static class Gadget {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String type;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String title;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String link;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String iconLink;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer width;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer height;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private DisplayMode display;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Map<String, String> preferences;

        public String getType() {
            return this.type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLink() {
            return this.link;
        }

        public String getIconLink() {
            return this.iconLink;
        }

        public Integer getWidth() {
            return this.width;
        }

        public Integer getHeight() {
            return this.height;
        }

        public DisplayMode getDisplay() {
            return this.display;
        }

        public Map<String, String> getPreferences() {
            return this.preferences;
        }
    }

    public static class ExtendedProperties {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="private")
        private Map<String, String> privateProperties;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="shared")
        private Map<String, String> sharedProperties;

        public Map<String, String> getPrivateProperties() {
            return this.privateProperties;
        }

        public Map<String, String> getSharedProperties() {
            return this.sharedProperties;
        }
    }

    public static class Attendee {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String email;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String displayName;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean organizer;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean self;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean resource;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean optional;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private AttendeeStatus responseStatus;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String comment;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Integer additionalGuests;

        public String getId() {
            return this.id;
        }

        public String getEmail() {
            return this.email;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Boolean isOrganizer() {
            return this.organizer;
        }

        public Boolean isSelf() {
            return this.self;
        }

        public Boolean isResource() {
            return this.resource;
        }

        public Boolean isOptional() {
            return this.optional;
        }

        public AttendeeStatus getResponseStatus() {
            return this.responseStatus;
        }

        public String getComment() {
            return this.comment;
        }

        public Integer getAdditionalGuests() {
            return this.additionalGuests;
        }
    }

    public static class DateTimeTimezone {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="UTC")
        private Date date;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonDeserialize(using=DateTimeDeserializer.class)
        @JsonSerialize(using=DateTimeSerializer.class)
        private Date dateTime;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonDeserialize(using=TimeZoneDeserializer.class)
        @JsonSerialize(using=TimeZoneSerializer.class)
        private TimeZone timeZone;

        public Date getDate() {
            return this.date;
        }

        public DateTimeTimezone setDate(Date date) {
            this.date = date;
            return this;
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public DateTimeTimezone setDateTime(Date dateTime) {
            this.dateTime = dateTime;
            return this;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public DateTimeTimezone setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }
    }

    public static class Organizer {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String email;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String displayName;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean self;

        public String getId() {
            return this.id;
        }

        public String getEmail() {
            return this.email;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Boolean isSelf() {
            return this.self;
        }
    }

    public static class Creator {
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String id;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String email;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String displayName;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private Boolean self;

        public String getId() {
            return this.id;
        }

        public String getEmail() {
            return this.email;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Boolean isSelf() {
            return this.self;
        }
    }
}

