/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.google.api.Google;

public class GoogleApiHelper
implements ApiHelper<Google> {
    private static final Log logger = LogFactory.getLog(GoogleApiHelper.class);
    private final UsersConnectionRepository usersConnectionRepository;
    private final UserIdSource userIdSource;

    private GoogleApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.userIdSource = userIdSource;
    }

    public Google getApi() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting API binding instance for Google provider");
        }
        Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(Google.class);
        if (logger.isDebugEnabled() && connection == null) {
            logger.debug((Object)"No current connection; Returning default GoogleTemplate instance.");
        }
        return connection != null ? (Google)connection.getApi() : null;
    }
}

