/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.social.connect.support.ConnectionFactoryRegistry;
import org.springframework.social.security.SocialAuthenticationServiceLocator;
import org.springframework.social.security.provider.SocialAuthenticationService;

public class SocialAuthenticationServiceRegistry
extends ConnectionFactoryRegistry
implements SocialAuthenticationServiceLocator {
    private Map<String, SocialAuthenticationService<?>> authenticationServices = new HashMap();

    @Override
    public SocialAuthenticationService<?> getAuthenticationService(String providerId) {
        SocialAuthenticationService<?> authenticationService = this.authenticationServices.get(providerId);
        if (authenticationService == null) {
            throw new IllegalArgumentException("No authentication service for service provider '" + providerId + "' is registered");
        }
        return authenticationService;
    }

    public void addAuthenticationService(SocialAuthenticationService<?> authenticationService) {
        this.addConnectionFactory(authenticationService.getConnectionFactory());
        this.authenticationServices.put(authenticationService.getConnectionFactory().getProviderId(), authenticationService);
    }

    public void setAuthenticationServices(Iterable<SocialAuthenticationService<?>> authenticationServices) {
        for (SocialAuthenticationService<?> authenticationService : authenticationServices) {
            this.addAuthenticationService(authenticationService);
        }
    }

    @Override
    public Set<String> registeredAuthenticationProviderIds() {
        return this.authenticationServices.keySet();
    }
}

