/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.tasks;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.tasks.TaskStatus;

public class Task
extends ApiEntity {
    private String title;
    private String notes;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", timezone="UTC")
    private Date due;
    private String parent;
    private String position;
    private Date updated;
    private TaskStatus status;
    private Date completed;

    public Task() {
    }

    public Task(String id) {
        super(id);
    }

    public Task(String id, String title, String notes, Date due, Date completed) {
        super(id);
        this.title = title;
        this.notes = notes;
        this.due = due;
        this.setCompleted(completed);
    }

    public Task(String title, String notes, Date due) {
        this(null, title, notes, due, null);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public String getParent() {
        return this.parent;
    }

    public String getPosition() {
        return this.position;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public Date getCompleted() {
        return this.completed;
    }

    public void setCompleted(Date completed) {
        this.completed = completed;
        this.status = completed == null ? TaskStatus.NEEDS_ACTION : TaskStatus.COMPLETED;
    }
}

