/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.calendar.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeDeserializer
extends JsonDeserializer<Date> {
    private static final SimpleDateFormat[] DATE_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss")};

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String valueAsString = jp.getValueAsString();
        if (valueAsString != null && valueAsString.length() > 0) {
            for (SimpleDateFormat format : DATE_FORMATS) {
                try {
                    return format.parse(valueAsString);
                }
                catch (ParseException parseException) {
                }
            }
            throw new JsonParseException(jp, "Date-time unparseable: \"" + valueAsString + "\".", jp.getCurrentLocation());
        }
        return null;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        for (SimpleDateFormat format : DATE_FORMATS) {
            format.setTimeZone(timeZone);
        }
    }
}

