package io.cronapp;

import java.io.File;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import cronapi.CronapiMetaData.ObjectType;
import org.apache.commons.io.FileUtils;

/**
 * Manipular arquivos no S3 ...
 *
 * @author Ricardo Caldas
 * @version 1.0
 * @since 2019-01-14
 */

@CronapiMetaData(categoryName = "AmazonS3")
public class AmazonS3Service {

    @CronapiMetaData(type = "function", name = "Salvar arquivo no S3", description = "Salva arquivo em bucket do S3", returnType = ObjectType.STRING)
    public static Var inserirArquivo(
            @ParamMetaData(type = ObjectType.STRING, description = "Chave de acesso") Var accesskey,
            @ParamMetaData(type = ObjectType.STRING, description = "Chave secreta") Var secretkey,
            @ParamMetaData(type = ObjectType.STRING, description = "Nome do bucket") Var bucket,
            @ParamMetaData(type = ObjectType.UNKNOWN, description = "Arquivo local") Var arquivo,
            @ParamMetaData(type = ObjectType.UNKNOWN, description = "Caminho para salvar") Var folder,
            @ParamMetaData(type = ObjectType.STRING, description = "Região", blockType = "util_dropdown", keys = {
                    "SA_EAST_1", "AP_NORTHEAST_1", "AP_NORTHEAST_2", "AP_SOUTH_1", "AP_SOUTHEAST_1", "AP_SOUTHEAST_2", "CA_CENTRAL_1", "CN_NORTH_1",
                    "CN_NORTHWEST_1", "EU_CENTRAL_1", "DEFAULT_REGION", "EU_NORTH_1", "EU_WEST_1", "EU_WEST_2", "EU_WEST_3", "GovCloud", "SA_EAST_1", "US_EAST_1", "US_EAST_2", "US_GOV_EAST_1", "US_WEST_1", "US_WEST_2"}) Var bucketRegion)
            throws Exception {
        Regions region = null;
        switch (bucketRegion.getObjectAsString()) {
            case "SA_EAST_1":
                region = Regions.SA_EAST_1;
                break;
            case "AP_NORTHEAST_1":
                region = Regions.AP_NORTHEAST_1;
                break;
            case "AP_NORTHEAST_2":
                region = Regions.AP_NORTHEAST_2;
                break;
            case "AP_SOUTH_1":
                region = Regions.AP_SOUTH_1;
                break;
            case "AP_SOUTHEAST_1":
                region = Regions.AP_SOUTHEAST_1;
                break;
            case "AP_SOUTHEAST_2":
                region = Regions.AP_SOUTHEAST_2;
                break;
            case "CA_CENTRAL_1":
                region = Regions.CA_CENTRAL_1;
                break;
            case "CN_NORTH_1":
                region = Regions.CN_NORTH_1;
                break;
            case "CN_NORTHWEST_1":
                region = Regions.CN_NORTHWEST_1;
                break;
            case "EU_CENTRAL_1":
                region = Regions.EU_CENTRAL_1;
                break;
            case "DEFAULT_REGION":
                region = Regions.DEFAULT_REGION;
                break;
            case "EU_NORTH_1":
                region = Regions.EU_NORTH_1;
                break;
            case "EU_WEST_1":
                region = Regions.EU_WEST_1;
                break;
            case "EU_WEST_2":
                region = Regions.EU_WEST_2;
                break;
            case "EU_WEST_3":
                region = Regions.EU_WEST_3;
                break;
            case "GovCloud":
                region = Regions.GovCloud;
                break;
            case "US_EAST_1":
                region = Regions.US_EAST_1;
                break;
            case "US_EAST_2":
                region = Regions.US_EAST_2;
                break;
            case "US_GOV_EAST_1":
                region = Regions.US_GOV_EAST_1;
                break;
            case "US_WEST_1":
                region = Regions.US_WEST_1;
                break;
            case "US_WEST_2":
                region = Regions.US_WEST_2;
                break;
        }
        AWSCredentials credentials = new BasicAWSCredentials(accesskey.getObjectAsString(), secretkey.getObjectAsString());
        AmazonS3 s3client = AmazonS3ClientBuilder.standard().withCredentials(new AWSStaticCredentialsProvider(credentials)).withRegion(region).build();
        s3client.putObject(bucket.getObjectAsString(), folder.getObjectAsString(), arquivo.getObjectAsFile());
        return Var.valueOf(String.format("http://s3.amazonaws.com/%s/%s", bucket, folder.getObjectAsString()));
    }

    @CronapiMetaData(type = "function", name = "Abrir arquivo do S3", description = "Abrir arquivo do bucket S3", returnType = ObjectType.STRING)
    public static Var obterArquivo(
            @ParamMetaData(type = ObjectType.STRING, description = "Chave de acesso") Var accesskey,
            @ParamMetaData(type = ObjectType.STRING, description = "Chave secreta") Var secretkey,
            @ParamMetaData(type = ObjectType.STRING, description = "Nome do bucket") Var bucket,
            @ParamMetaData(type = ObjectType.STRING, description = "Arquivo de origem") Var arquivoOrigem,
            @ParamMetaData(type = ObjectType.STRING, description = "Caminho de destino") Var caminhoDestino,
            @ParamMetaData(type = ObjectType.STRING, description = "Região", blockType = "util_dropdown", keys = {
                    "SA_EAST_1", "AP_NORTHEAST_1", "AP_NORTHEAST_2", "AP_SOUTH_1", "AP_SOUTHEAST_1", "AP_SOUTHEAST_2", "CA_CENTRAL_1", "CN_NORTH_1",
                    "CN_NORTHWEST_1", "EU_CENTRAL_1", "DEFAULT_REGION", "EU_NORTH_1", "EU_WEST_1", "EU_WEST_2", "EU_WEST_3", "GovCloud", "SA_EAST_1", "US_EAST_1", "US_EAST_2", "US_GOV_EAST_1", "US_WEST_1", "US_WEST_2"}) Var bucketRegion)
            throws Exception {
        Regions region = null;
        switch (bucketRegion.getObjectAsString()) {
            case "SA_EAST_1":
                region = Regions.SA_EAST_1;
                break;
            case "AP_NORTHEAST_1":
                region = Regions.AP_NORTHEAST_1;
                break;
            case "AP_NORTHEAST_2":
                region = Regions.AP_NORTHEAST_2;
                break;
            case "AP_SOUTH_1":
                region = Regions.AP_SOUTH_1;
                break;
            case "AP_SOUTHEAST_1":
                region = Regions.AP_SOUTHEAST_1;
                break;
            case "AP_SOUTHEAST_2":
                region = Regions.AP_SOUTHEAST_2;
                break;
            case "CA_CENTRAL_1":
                region = Regions.CA_CENTRAL_1;
                break;
            case "CN_NORTH_1":
                region = Regions.CN_NORTH_1;
                break;
            case "CN_NORTHWEST_1":
                region = Regions.CN_NORTHWEST_1;
                break;
            case "EU_CENTRAL_1":
                region = Regions.EU_CENTRAL_1;
                break;
            case "DEFAULT_REGION":
                region = Regions.DEFAULT_REGION;
                break;
            case "EU_NORTH_1":
                region = Regions.EU_NORTH_1;
                break;
            case "EU_WEST_1":
                region = Regions.EU_WEST_1;
                break;
            case "EU_WEST_2":
                region = Regions.EU_WEST_2;
                break;
            case "EU_WEST_3":
                region = Regions.EU_WEST_3;
                break;
            case "GovCloud":
                region = Regions.GovCloud;
                break;
            case "US_EAST_1":
                region = Regions.US_EAST_1;
                break;
            case "US_EAST_2":
                region = Regions.US_EAST_2;
                break;
            case "US_GOV_EAST_1":
                region = Regions.US_GOV_EAST_1;
                break;
            case "US_WEST_1":
                region = Regions.US_WEST_1;
                break;
            case "US_WEST_2":
                region = Regions.US_WEST_2;
                break;
        }
        AWSCredentials credentials = new BasicAWSCredentials(accesskey.getObjectAsString(),
                secretkey.getObjectAsString());
        AmazonS3 s3client = AmazonS3ClientBuilder.standard()
                .withCredentials(new AWSStaticCredentialsProvider(credentials)).withRegion(region).build();
        S3Object s3object = s3client.getObject(bucket.getObjectAsString(), arquivoOrigem.getObjectAsString());
        S3ObjectInputStream inputStreamS3 = s3object.getObjectContent();
        FileUtils.copyInputStreamToFile(inputStreamS3, new File(caminhoDestino.getObjectAsString()));
        return caminhoDestino;
    }

}
