/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.validation;

import io.crnk.spring.setup.boot.core.CrnkCoreAutoConfiguration;
import io.crnk.spring.setup.boot.validation.CrnkValidationProperties;
import io.crnk.validation.ValidationModule;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Configuration
@ConditionalOnProperty(prefix="crnk.validation", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={ValidationModule.class})
@ConditionalOnMissingBean(value={ValidationModule.class})
@EnableConfigurationProperties(value={CrnkValidationProperties.class})
@Import(value={CrnkCoreAutoConfiguration.class})
public class CrnkValidationAutoConfiguration {
    @Autowired
    private CrnkValidationProperties validationProperties;

    @Bean
    public LocalValidatorFactoryBean validatorFactoryBean() {
        LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();
        return localValidatorFactoryBean;
    }

    @Bean
    public ValidationModule validationModule(LocalValidatorFactoryBean validatorFactoryBean) {
        return ValidationModule.create((boolean)this.validationProperties.getValidateResources(), (Validator)validatorFactoryBean.getValidator());
    }
}

