/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.meta;

import io.crnk.meta.MetaModule;
import io.crnk.meta.MetaModuleConfig;
import io.crnk.meta.provider.MetaProvider;
import io.crnk.meta.provider.resource.ResourceMetaProvider;
import io.crnk.spring.setup.boot.core.CrnkCoreAutoConfiguration;
import io.crnk.spring.setup.boot.meta.CrnkMetaProperties;
import io.crnk.spring.setup.boot.meta.MetaModuleConfigurer;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="crnk.meta", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={MetaModule.class})
@ConditionalOnMissingBean(value={MetaModule.class})
@EnableConfigurationProperties(value={CrnkMetaProperties.class})
@Import(value={CrnkCoreAutoConfiguration.class})
public class CrnkMetaAutoConfiguration {
    @Autowired
    private CrnkMetaProperties metaProperties;
    @Autowired(required=false)
    private List<MetaModuleConfigurer> configurers;

    @Bean
    public MetaModuleConfig metaModuleConfig() {
        MetaModuleConfig config = new MetaModuleConfig();
        if (this.metaProperties.getListResources()) {
            config.addMetaProvider((MetaProvider)new ResourceMetaProvider());
        }
        return config;
    }

    @Bean
    public MetaModule metaModule(MetaModuleConfig config) {
        if (this.configurers != null) {
            for (MetaModuleConfigurer configurer : this.configurers) {
                configurer.configure(config);
            }
        }
        return MetaModule.createServerModule((MetaModuleConfig)config);
    }
}

