/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.jpa;

import io.crnk.core.engine.transaction.TransactionRunner;
import io.crnk.jpa.JpaModule;
import io.crnk.jpa.JpaModuleConfig;
import io.crnk.jpa.query.JpaQueryFactory;
import io.crnk.jpa.query.criteria.JpaCriteriaQueryFactory;
import io.crnk.jpa.query.querydsl.QuerydslQueryFactory;
import io.crnk.spring.jpa.SpringTransactionRunner;
import io.crnk.spring.setup.boot.core.CrnkCoreAutoConfiguration;
import io.crnk.spring.setup.boot.core.CrnkCoreProperties;
import io.crnk.spring.setup.boot.jpa.CrnkJpaProperties;
import io.crnk.spring.setup.boot.jpa.JpaModuleConfigurer;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="crnk.jpa", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={JpaModule.class})
@ConditionalOnMissingBean(value={JpaModule.class})
@EnableConfigurationProperties(value={CrnkJpaProperties.class, CrnkCoreProperties.class})
@AutoConfigureAfter(value={HibernateJpaAutoConfiguration.class})
@AutoConfigureBefore
@Import(value={CrnkCoreAutoConfiguration.class})
public class CrnkJpaAutoConfiguration {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private EntityManagerFactory emf;
    @Autowired
    private CrnkJpaProperties jpaProperties;
    @Autowired(required=false)
    private List<JpaModuleConfigurer> configurers;

    @Bean
    @ConditionalOnMissingBean
    public SpringTransactionRunner transactionRunner() {
        return new SpringTransactionRunner();
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaModuleConfig jpaModuleConfig() {
        return new JpaModuleConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public JpaModule jpaModule(JpaModuleConfig config) {
        if (this.configurers != null) {
            for (JpaModuleConfigurer configurer : this.configurers) {
                configurer.configure(config);
            }
        }
        if (this.jpaProperties.getExposeAll().booleanValue()) {
            config.exposeAllEntities(this.emf);
        }
        JpaModule module = JpaModule.createServerModule((JpaModuleConfig)config, (EntityManager)this.em, (TransactionRunner)this.transactionRunner());
        if (this.jpaProperties.getQueryFactory() != null) {
            switch (this.jpaProperties.getQueryFactory()) {
                case CRITERIA: {
                    module.setQueryFactory((JpaQueryFactory)JpaCriteriaQueryFactory.newInstance());
                    break;
                }
                case QUERYDSL: {
                    module.setQueryFactory((JpaQueryFactory)QuerydslQueryFactory.newInstance());
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown query factory");
                }
            }
        }
        return module;
    }
}

