/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.spring.setup.boot.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.queryspec.mapper.DefaultQuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingSpec;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.servlet.CrnkFilter;
import io.crnk.servlet.internal.ServletModule;
import io.crnk.spring.internal.SpringServiceDiscovery;
import io.crnk.spring.setup.boot.core.CrnkBootConfigurer;
import io.crnk.spring.setup.boot.core.CrnkCoreProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="crnk", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnMissingBean(value={CrnkBoot.class})
@EnableConfigurationProperties(value={CrnkCoreProperties.class})
public class CrnkCoreAutoConfiguration
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private CrnkCoreProperties properties;
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<CrnkBootConfigurer> configurers;

    @Autowired
    public CrnkCoreAutoConfiguration(CrnkCoreProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceDiscovery.class})
    public SpringServiceDiscovery discovery() {
        return new SpringServiceDiscovery();
    }

    @Bean
    @ConditionalOnMissingBean(value={CrnkBoot.class})
    public CrnkBoot crnkBoot(ServiceDiscovery serviceDiscovery) {
        CrnkBoot boot = new CrnkBoot();
        boot.setObjectMapper(this.objectMapper);
        if (this.properties.getDomainName() != null && this.properties.getPathPrefix() != null) {
            String baseUrl = this.properties.getDomainName() + this.properties.getPathPrefix();
            boot.setServiceUrlProvider((ServiceUrlProvider)new ConstantServiceUrlProvider(baseUrl));
        }
        boot.setServiceDiscovery(serviceDiscovery);
        boot.setDefaultPageLimit(this.properties.getDefaultPageLimit());
        boot.setMaxPageLimit(this.properties.getMaxPageLimit());
        boot.setPropertiesProvider(new PropertiesProvider(){

            public String getProperty(String key) {
                if ("crnk.config.core.resource.package".equals(key)) {
                    return CrnkCoreAutoConfiguration.this.properties.getResourcePackage();
                }
                if ("crnk.config.core.resource.domain".equals(key)) {
                    return CrnkCoreAutoConfiguration.this.properties.getDomainName();
                }
                if ("crnk.config.web.path.prefix".equals(key)) {
                    return CrnkCoreAutoConfiguration.this.properties.getPathPrefix();
                }
                if ("crnk.config.resource.request.allowUnknownAttributes".equals(key)) {
                    return String.valueOf(CrnkCoreAutoConfiguration.this.properties.getAllowUnknownAttributes());
                }
                if ("crnk.config.resource.request.allowUnknownParameters".equals(key)) {
                    return String.valueOf(CrnkCoreAutoConfiguration.this.properties.getAllowUnknownParameters());
                }
                if ("crnk.config.resource.response.return_404".equals(key)) {
                    return String.valueOf(CrnkCoreAutoConfiguration.this.properties.getReturn404OnNull());
                }
                return CrnkCoreAutoConfiguration.this.applicationContext.getEnvironment().getProperty(key);
            }
        });
        boot.addModule((Module)new ServletModule(boot.getModuleRegistry().getHttpRequestContextProvider()));
        if (this.configurers != null) {
            for (CrnkBootConfigurer configurer : this.configurers) {
                configurer.configure(boot);
            }
        }
        boot.boot();
        return boot;
    }

    @Bean
    @ConditionalOnMissingBean(value={QuerySpecUrlMapper.class})
    public QuerySpecUrlMapper querySpecUrlMapper() {
        return new DefaultQuerySpecUrlMapper();
    }

    @Bean
    @ConditionalOnMissingBean(value={PagingBehavior.class})
    public PagingBehavior<OffsetLimitPagingSpec> offsetLimitPagingBehavior() {
        return new OffsetLimitPagingBehavior();
    }

    @Bean
    public CrnkFilter crnkFilter(CrnkBoot boot) {
        return new CrnkFilter(boot);
    }

    @Bean
    public ResourceRegistry resourceRegistry(CrnkBoot boot) {
        return boot.getResourceRegistry();
    }

    @Bean
    public ModuleRegistry moduleRegistry(CrnkBoot boot) {
        return boot.getModuleRegistry();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

