/*
 * Decompiled with CFR 0.152.
 */
package io.continuum.bokeh.examples.glyphs;

import io.continuum.bokeh.ArrayLike$;
import io.continuum.bokeh.Axis;
import io.continuum.bokeh.Color;
import io.continuum.bokeh.ColumnDataSource;
import io.continuum.bokeh.ColumnsRef;
import io.continuum.bokeh.DataRange1d;
import io.continuum.bokeh.DatetimeAxis;
import io.continuum.bokeh.DatetimeTickFormatter;
import io.continuum.bokeh.DatetimeUnits;
import io.continuum.bokeh.Document;
import io.continuum.bokeh.FillProps;
import io.continuum.bokeh.GlyphRenderer;
import io.continuum.bokeh.Grid;
import io.continuum.bokeh.HTMLFile;
import io.continuum.bokeh.Legend;
import io.continuum.bokeh.Line;
import io.continuum.bokeh.LineProps;
import io.continuum.bokeh.Patch;
import io.continuum.bokeh.Plot;
import io.continuum.bokeh.Renderer;
import io.continuum.bokeh.Text;
import io.continuum.bokeh.TextAlign;
import io.continuum.bokeh.TextProps;
import io.continuum.bokeh.Widget;
import io.continuum.bokeh.examples.Example;
import io.continuum.bokeh.examples.Example$Config$;
import io.continuum.bokeh.examples.Example$class;
import io.continuum.bokeh.examples.glyphs.Daylight;
import io.continuum.bokeh.package$;
import io.continuum.bokeh.sampledata.daylight.DaylightData;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class Daylight$
implements Example {
    public static final Daylight$ MODULE$;
    private final DaylightData daylight;
    private final ColumnDataSource source;
    private final ColumnDataSource patch1_source;
    private final DaylightData summer;
    private final ColumnDataSource patch2_source;
    private final int summerStartIndex;
    private final int summerEndIndex;
    private final LocalDate calendarStart;
    private final LocalDate summerStart;
    private final LocalDate summerEnd;
    private final LocalDate calendarEnd;
    private final LocalDate springMiddle;
    private final LocalDate summerMiddle;
    private final LocalDate autumnMiddle;
    private final LocalTime _11_30;
    private final ColumnDataSource text_source;
    private final DataRange1d xdr;
    private final DataRange1d ydr;
    private final String title;
    private final List<ColumnDataSource> sources;
    private final Plot plot;
    private final Patch patch1;
    private final GlyphRenderer patch1_glyph;
    private final Patch patch2;
    private final GlyphRenderer patch2_glyph;
    private final Line line1;
    private final GlyphRenderer line1_glyph;
    private final Line line2;
    private final GlyphRenderer line2_glyph;
    private final Text text;
    private final GlyphRenderer text_glyph;
    private final List<GlyphRenderer> glyphs;
    private final DatetimeTickFormatter xformatter;
    private final DatetimeAxis xaxis;
    private final DatetimeAxis yaxis;
    private final Grid xgrid;
    private final Grid ygrid;
    private final List<Tuple2<String, List<GlyphRenderer>>> legends;
    private final Legend legend;
    private final Document document;
    private final HTMLFile html;
    private Example.Config io$continuum$bokeh$examples$Example$$_config;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile Example$Config$ Config$module;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;

    static {
        symbol$1 = Symbol$.MODULE$.apply("dates");
        symbol$2 = Symbol$.MODULE$.apply("sunrises");
        symbol$3 = Symbol$.MODULE$.apply("sunsets");
        symbol$4 = Symbol$.MODULE$.apply("times");
        symbol$5 = Symbol$.MODULE$.apply("texts");
        new Daylight$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Example$Config$ Config$lzycompute() {
        Daylight$ daylight$ = this;
        synchronized (daylight$) {
            if (this.Config$module != null) return this.Config$module;
            this.Config$module = new Example$Config$(this);
            return this.Config$module;
        }
    }

    @Override
    public Example$Config$ Config() {
        return this.Config$module == null ? this.Config$lzycompute() : this.Config$module;
    }

    @Override
    public Example.Config io$continuum$bokeh$examples$Example$$_config() {
        return this.io$continuum$bokeh$examples$Example$$_config;
    }

    @Override
    @TraitSetter
    public void io$continuum$bokeh$examples$Example$$_config_$eq(Example.Config x$1) {
        this.io$continuum$bokeh$examples$Example$$_config = x$1;
    }

    @Override
    public /* synthetic */ void io$continuum$bokeh$examples$Example$$super$delayedInit(Function0 body2) {
        App.class.delayedInit((App)this, (Function0)body2);
    }

    @Override
    public Example.Config config() {
        return Example$class.config(this);
    }

    @Override
    public void delayedInit(Function0<BoxedUnit> body2) {
        Example$class.delayedInit(this, body2);
    }

    @Override
    public void info(Function0<String> text) {
        Example$class.info(this, text);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public DaylightData daylight() {
        return this.daylight;
    }

    public ColumnDataSource source() {
        return this.source;
    }

    public ColumnDataSource patch1_source() {
        return this.patch1_source;
    }

    public DaylightData summer() {
        return this.summer;
    }

    public ColumnDataSource patch2_source() {
        return this.patch2_source;
    }

    public int summerStartIndex() {
        return this.summerStartIndex;
    }

    public int summerEndIndex() {
        return this.summerEndIndex;
    }

    public LocalDate calendarStart() {
        return this.calendarStart;
    }

    public LocalDate summerStart() {
        return this.summerStart;
    }

    public LocalDate summerEnd() {
        return this.summerEnd;
    }

    public LocalDate calendarEnd() {
        return this.calendarEnd;
    }

    public LocalDate middle(LocalDate start, LocalDate end) {
        return new LocalDate((start.toDateTimeAtStartOfDay().getMillis() + end.toDateTimeAtStartOfDay().getMillis()) / 2L);
    }

    public LocalDate springMiddle() {
        return this.springMiddle;
    }

    public LocalDate summerMiddle() {
        return this.summerMiddle;
    }

    public LocalDate autumnMiddle() {
        return this.autumnMiddle;
    }

    public LocalTime _11_30() {
        return this._11_30;
    }

    public ColumnDataSource text_source() {
        return this.text_source;
    }

    public DataRange1d xdr() {
        return this.xdr;
    }

    public DataRange1d ydr() {
        return this.ydr;
    }

    public String title() {
        return this.title;
    }

    public List<ColumnDataSource> sources() {
        return this.sources;
    }

    public Plot plot() {
        return this.plot;
    }

    public Patch patch1() {
        return this.patch1;
    }

    public GlyphRenderer patch1_glyph() {
        return this.patch1_glyph;
    }

    public Patch patch2() {
        return this.patch2;
    }

    public GlyphRenderer patch2_glyph() {
        return this.patch2_glyph;
    }

    public Line line1() {
        return this.line1;
    }

    public GlyphRenderer line1_glyph() {
        return this.line1_glyph;
    }

    public Line line2() {
        return this.line2;
    }

    public GlyphRenderer line2_glyph() {
        return this.line2_glyph;
    }

    public Text text() {
        return this.text;
    }

    public GlyphRenderer text_glyph() {
        return this.text_glyph;
    }

    public List<GlyphRenderer> glyphs() {
        return this.glyphs;
    }

    public DatetimeTickFormatter xformatter() {
        return this.xformatter;
    }

    public DatetimeAxis xaxis() {
        return this.xaxis;
    }

    public DatetimeAxis yaxis() {
        return this.yaxis;
    }

    public Grid xgrid() {
        return this.xgrid;
    }

    public Grid ygrid() {
        return this.ygrid;
    }

    public List<Tuple2<String, List<GlyphRenderer>>> legends() {
        return this.legends;
    }

    public Legend legend() {
        return this.legend;
    }

    public Document document() {
        return this.document;
    }

    public HTMLFile html() {
        return this.html;
    }

    public final void delayedEndpoint$io$continuum$bokeh$examples$glyphs$Daylight$1() {
        this.daylight = io.continuum.bokeh.sampledata.daylight.package$.MODULE$.Warsaw2013();
        this.source = new ColumnDataSource().addColumn(symbol$1, (Object)this.daylight().date(), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$2, (Object)this.daylight().sunrise(), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$3, (Object)this.daylight().sunset(), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        this.patch1_source = new ColumnDataSource().addColumn(symbol$1, this.daylight().date().$plus$plus((GenTraversableOnce)this.daylight().date().reverse(), List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$4, this.daylight().sunrise().$plus$plus((GenTraversableOnce)this.daylight().sunset().reverse(), List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        this.summer = this.daylight().summerOnly();
        this.patch2_source = new ColumnDataSource().addColumn(symbol$1, this.summer().date().$plus$plus((GenTraversableOnce)this.summer().date().reverse(), List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$4, this.summer().sunrise().$plus$plus((GenTraversableOnce)this.summer().sunset().reverse(), List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        this.summerStartIndex = this.daylight().summer().indexOf((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.summerEndIndex = this.daylight().summer().indexOf((Object)BoxesRunTime.boxToBoolean((boolean)false), this.summerStartIndex());
        this.calendarStart = (LocalDate)this.daylight().date().head();
        this.summerStart = (LocalDate)this.daylight().date().apply(this.summerStartIndex());
        this.summerEnd = (LocalDate)this.daylight().date().apply(this.summerEndIndex());
        this.calendarEnd = (LocalDate)this.daylight().date().last();
        this.springMiddle = this.middle(this.summerStart(), this.calendarStart());
        this.summerMiddle = this.middle(this.summerEnd(), this.summerStart());
        this.autumnMiddle = this.middle(this.calendarEnd(), this.summerEnd());
        this._11_30 = new LocalTime(11, 30);
        this.text_source = new ColumnDataSource().addColumn(symbol$1, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalDate[]{this.springMiddle(), this.summerMiddle(), this.autumnMiddle()})), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$4, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalTime[]{this._11_30(), this._11_30(), this._11_30()})), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$5, (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CST (UTC+1)", "CEST (UTC+2)", "CST (UTC+1)"})), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        this.xdr = (DataRange1d)new DataRange1d().sources().apply((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnsRef[]{this.source().columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$1}))})));
        this.ydr = (DataRange1d)new DataRange1d().sources().apply((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnsRef[]{this.source().columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{symbol$2, symbol$3}))})));
        this.title = "Daylight Hours - Warsaw, Poland";
        this.sources = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnDataSource[]{this.source(), this.patch1_source(), this.patch2_source(), this.text_source()}));
        this.plot = (Plot)((Plot)((Plot)((Plot)((Plot)new Plot().title().apply((Object)this.title())).x_range().apply((Object)this.xdr())).y_range().apply((Object)this.ydr())).width().apply((Object)BoxesRunTime.boxToInteger((int)800))).height().apply((Object)BoxesRunTime.boxToInteger((int)400));
        this.patch1 = (Patch)((FillProps)((FillProps)((Patch)new Patch().x().apply(symbol$1)).y().apply(symbol$4)).fill_color().apply((Object)Color.SkyBlue$.MODULE$)).fill_alpha().apply((Object)package$.MODULE$.NumbericToPercent((Object)BoxesRunTime.boxToDouble((double)0.8), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
        this.patch1_glyph = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)this.patch1_source())).glyph().apply((Object)this.patch1());
        this.patch2 = (Patch)((FillProps)((FillProps)((Patch)new Patch().x().apply(symbol$1)).y().apply(symbol$4)).fill_color().apply((Object)Color.Orange$.MODULE$)).fill_alpha().apply((Object)package$.MODULE$.NumbericToPercent((Object)BoxesRunTime.boxToDouble((double)0.8), (Numeric)Numeric.DoubleIsFractional$.MODULE$));
        this.patch2_glyph = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)this.patch2_source())).glyph().apply((Object)this.patch2());
        this.line1 = (Line)((LineProps)((LineProps)((Line)new Line().x().apply(symbol$1)).y().apply(symbol$2)).line_color().apply((Object)Color.Yellow$.MODULE$)).line_width().apply((Object)BoxesRunTime.boxToDouble((double)2.0));
        this.line1_glyph = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)this.source())).glyph().apply((Object)this.line1());
        this.line2 = (Line)((LineProps)((LineProps)((Line)new Line().x().apply(symbol$1)).y().apply(symbol$3)).line_color().apply((Object)Color.Red$.MODULE$)).line_width().apply((Object)BoxesRunTime.boxToDouble((double)2.0));
        this.line2_glyph = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)this.source())).glyph().apply((Object)this.line2());
        this.text = (Text)((TextProps)((Text)((Text)((Text)new Text().x().apply(symbol$1)).y().apply(symbol$4)).text().apply(symbol$5)).angle().apply((Object)BoxesRunTime.boxToDouble((double)0.0))).text_align().apply((Object)TextAlign.Center$.MODULE$);
        this.text_glyph = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)this.text_source())).glyph().apply((Object)this.text());
        this.glyphs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlyphRenderer[]{this.patch1_glyph(), this.patch2_glyph(), this.line1_glyph(), this.line2_glyph(), this.text_glyph()}));
        this.plot().renderers().$less$less$eq((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Renderer> apply(List<Renderer> x$1) {
                return (List)Daylight$.MODULE$.glyphs().$plus$plus(x$1, List$.MODULE$.canBuildFrom());
            }
        });
        this.xformatter = (DatetimeTickFormatter)new DatetimeTickFormatter().formats().apply((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DatetimeUnits.Months$.MODULE$), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%b %Y"})))})));
        this.xaxis = (DatetimeAxis)((Axis)new DatetimeAxis().plot().apply((Object)this.plot())).formatter().apply((Object)this.xformatter());
        this.yaxis = (DatetimeAxis)new DatetimeAxis().plot().apply((Object)this.plot());
        this.plot().below().$less$less$eq((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Renderer> apply(List<Renderer> x$2) {
                DatetimeAxis datetimeAxis = Daylight$.MODULE$.xaxis();
                return x$2.$colon$colon((Object)datetimeAxis);
            }
        });
        this.plot().left().$less$less$eq((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Renderer> apply(List<Renderer> x$4) {
                DatetimeAxis datetimeAxis = Daylight$.MODULE$.yaxis();
                return x$4.$colon$colon((Object)datetimeAxis);
            }
        });
        this.xgrid = ((Grid)((Grid)new Grid().plot().apply((Object)this.plot())).dimension().apply((Object)BoxesRunTime.boxToInteger((int)0))).axis((Axis)this.xaxis());
        this.ygrid = ((Grid)((Grid)new Grid().plot().apply((Object)this.plot())).dimension().apply((Object)BoxesRunTime.boxToInteger((int)1))).axis((Axis)this.yaxis());
        this.plot().renderers().$less$less$eq((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Renderer> apply(List<Renderer> x$6) {
                DatetimeAxis datetimeAxis = Daylight$.MODULE$.xaxis();
                DatetimeAxis datetimeAxis2 = Daylight$.MODULE$.yaxis();
                Grid grid = Daylight$.MODULE$.xgrid();
                Grid grid2 = Daylight$.MODULE$.ygrid();
                return x$6.$colon$colon((Object)grid2).$colon$colon((Object)grid).$colon$colon((Object)datetimeAxis2).$colon$colon((Object)datetimeAxis);
            }
        });
        this.legends = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sunrise"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlyphRenderer[]{this.line1_glyph()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sunset"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlyphRenderer[]{this.line2_glyph()})))}));
        this.legend = (Legend)((Legend)new Legend().plot().apply((Object)this.plot())).legends().apply(this.legends());
        this.plot().renderers().$less$less$eq((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Renderer> apply(List<Renderer> x$11) {
                Legend legend = Daylight$.MODULE$.legend();
                return x$11.$colon$colon((Object)legend);
            }
        });
        this.document = new Document((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Widget[]{this.plot()}));
        this.html = this.document().save("daylight.html", this.config().resources());
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrote ", ". Open ", " in a web browser."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Daylight$.MODULE$.html().file(), Daylight$.MODULE$.html().url()}));
            }
        });
    }

    private Daylight$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        Example$class.$init$(this);
        this.delayedInit((Function0<BoxedUnit>)new Daylight.delayedInit.body(this));
    }
}

