/*
 * Decompiled with CFR 0.152.
 */
package io.continuum.bokeh.examples.glyphs;

import io.continuum.bokeh.ArrayLike$;
import io.continuum.bokeh.Axis;
import io.continuum.bokeh.CategoricalAxis;
import io.continuum.bokeh.Color;
import io.continuum.bokeh.ColumnDataSource;
import io.continuum.bokeh.Document;
import io.continuum.bokeh.FactorRange;
import io.continuum.bokeh.FillProps;
import io.continuum.bokeh.GlyphRenderer;
import io.continuum.bokeh.GridPlot;
import io.continuum.bokeh.HTMLFile;
import io.continuum.bokeh.HoverTool;
import io.continuum.bokeh.LineProps;
import io.continuum.bokeh.Plot;
import io.continuum.bokeh.Rect;
import io.continuum.bokeh.Renderer;
import io.continuum.bokeh.Text;
import io.continuum.bokeh.TextAlign;
import io.continuum.bokeh.TextBaseline;
import io.continuum.bokeh.TextProps;
import io.continuum.bokeh.TransientSelectTool;
import io.continuum.bokeh.Widget;
import io.continuum.bokeh.examples.Example;
import io.continuum.bokeh.examples.Example$Config$;
import io.continuum.bokeh.examples.Example$class;
import io.continuum.bokeh.examples.glyphs.Calendars;
import io.continuum.bokeh.package$;
import io.continuum.bokeh.sampledata.Holiday;
import java.text.DateFormatSymbols;
import java.util.Locale;
import org.joda.time.LocalDate;
import scala.App;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.TraitSetter;

public final class Calendars$
implements Example {
    public static final Calendars$ MODULE$;
    private final DateFormatSymbols symbols;
    private final List<String> day_abbrs;
    private final String[] month_names;
    private final List<List<Plot>> months;
    private final GridPlot grid;
    private final Document document;
    private final HTMLFile html;
    private Example.Config io$continuum$bokeh$examples$Example$$_config;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;
    private volatile Example$Config$ Config$module;
    private static Symbol symbol$1;
    private static Symbol symbol$2;
    private static Symbol symbol$3;
    private static Symbol symbol$4;
    private static Symbol symbol$5;
    private static Symbol symbol$6;
    private static Symbol symbol$7;

    static {
        symbol$1 = Symbol$.MODULE$.apply("days");
        symbol$2 = Symbol$.MODULE$.apply("weeks");
        symbol$3 = Symbol$.MODULE$.apply("month_days");
        symbol$4 = Symbol$.MODULE$.apply("day_backgrounds");
        symbol$5 = Symbol$.MODULE$.apply("holidays_days");
        symbol$6 = Symbol$.MODULE$.apply("holidays_weeks");
        symbol$7 = Symbol$.MODULE$.apply("month_holidays");
        new Calendars$();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Example$Config$ Config$lzycompute() {
        Calendars$ calendars$ = this;
        synchronized (calendars$) {
            if (this.Config$module != null) return this.Config$module;
            this.Config$module = new Example$Config$(this);
            return this.Config$module;
        }
    }

    @Override
    public Example$Config$ Config() {
        return this.Config$module == null ? this.Config$lzycompute() : this.Config$module;
    }

    @Override
    public Example.Config io$continuum$bokeh$examples$Example$$_config() {
        return this.io$continuum$bokeh$examples$Example$$_config;
    }

    @Override
    @TraitSetter
    public void io$continuum$bokeh$examples$Example$$_config_$eq(Example.Config x$1) {
        this.io$continuum$bokeh$examples$Example$$_config = x$1;
    }

    @Override
    public /* synthetic */ void io$continuum$bokeh$examples$Example$$super$delayedInit(Function0 body2) {
        App.class.delayedInit((App)this, (Function0)body2);
    }

    @Override
    public Example.Config config() {
        return Example$class.config(this);
    }

    @Override
    public void delayedInit(Function0<BoxedUnit> body2) {
        Example$class.delayedInit(this, body2);
    }

    @Override
    public void info(Function0<String> text) {
        Example$class.info(this, text);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String[] args() {
        return App.class.args((App)this);
    }

    public void main(String[] args) {
        App.class.main((App)this, (String[])args);
    }

    public Calendars.DateOps DateOps(LocalDate date) {
        return new Calendars.DateOps(date);
    }

    public DateFormatSymbols symbols() {
        return this.symbols;
    }

    public List<String> day_abbrs() {
        return this.day_abbrs;
    }

    public String[] month_names() {
        return this.month_names;
    }

    public Plot make_calendar(int year, int month, String nameOfFirstweekday) {
        HoverTool hover_tool;
        int firstweekday = this.day_abbrs().indexOf((Object)nameOfFirstweekday);
        Calendars.Calendar calendar = new Calendars.Calendar(firstweekday);
        List month_days = (List)calendar.itermonthdays(year, month).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(int day) {
                return day == 0 ? None$.MODULE$ : new Some((Object)((Object)BoxesRunTime.boxToInteger((int)day)).toString());
            }
        }, List$.MODULE$.canBuildFrom());
        int month_weeks = month_days.length() / 7;
        Color.Linen$ workday = Color.Linen$.MODULE$;
        Color.LightSteelBlue$ weekend = Color.LightSteelBlue$.MODULE$;
        List day_names = this.pick_weekdays$1(this.day_abbrs(), firstweekday);
        List week_days = this.pick_weekdays$1((List)package$.MODULE$.ListOps(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Color.Linen$[]{workday}))).$times(5).$plus$plus((GenTraversableOnce)package$.MODULE$.ListOps(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Color.LightSteelBlue$[]{weekend}))).$times(2), List$.MODULE$.canBuildFrom()), firstweekday);
        ColumnDataSource source = new ColumnDataSource().addColumn(symbol$1, (Object)package$.MODULE$.ListOps(day_names).$times(month_weeks), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$2, RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), month_weeks).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(int week) {
                return package$.MODULE$.ListOps(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToInteger((int)week)).toString()}))).$times(7);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$3, (Object)month_days, ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$4, (Object)package$.MODULE$.ListOps(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new List[]{week_days}))).$times(month_weeks).flatten((Function1)Predef$.MODULE$.$conforms()), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        List holidays = (List)io.continuum.bokeh.sampledata.package$.MODULE$.us_holidays().collect((PartialFunction)new Serializable(year, month){
            public static final long serialVersionUID = 0L;
            private final int year$1;
            private final int month$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Holiday, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    LocalDate date = A1.date();
                    String summary = A1.summary();
                    if (date.getYear() == this.year$1 && Calendars$.MODULE$.DateOps(date).month() == this.month$1 && summary.contains("(US-OPM)")) {
                        object = new Holiday(date, summary.replace("(US-OPM)", "").trim());
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Holiday x1) {
                Holiday holiday = x1;
                if (holiday == null) return false;
                LocalDate date = holiday.date();
                String summary = holiday.summary();
                if (date.getYear() != this.year$1) return false;
                if (Calendars$.MODULE$.DateOps(date).month() != this.month$1) return false;
                if (!summary.contains("(US-OPM)")) return false;
                return true;
            }
            {
                this.year$1 = year$1;
                this.month$1 = month$1;
            }
        }, List$.MODULE$.canBuildFrom());
        ColumnDataSource holidays_source = new ColumnDataSource().addColumn(symbol$5, holidays.map((Function1)new Serializable(firstweekday, day_names){
            public static final long serialVersionUID = 0L;
            private final int firstweekday$1;
            private final List day_names$1;

            public final String apply(Holiday holiday) {
                return (String)this.day_names$1.apply(Calendars$.MODULE$.io$continuum$bokeh$examples$glyphs$Calendars$$weekday$1(holiday.date(), this.firstweekday$1));
            }
            {
                this.firstweekday$1 = firstweekday$1;
                this.day_names$1 = day_names$1;
            }
        }, List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$6, holidays.map((Function1)new Serializable(firstweekday){
            public static final long serialVersionUID = 0L;
            private final int firstweekday$1;

            public final String apply(Holiday holiday) {
                return ((Object)BoxesRunTime.boxToInteger((int)((Calendars$.MODULE$.io$continuum$bokeh$examples$glyphs$Calendars$$weekday$1(holiday.date().withDayOfMonth(1), this.firstweekday$1) + Calendars$.MODULE$.DateOps(holiday.date()).day()) / 7))).toString();
            }
            {
                this.firstweekday$1 = firstweekday$1;
            }
        }, List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike()).addColumn(symbol$7, holidays.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Holiday holiday) {
                return holiday.summary();
            }
        }, List$.MODULE$.canBuildFrom()), ArrayLike$.MODULE$.TraversableOnceArrayLike());
        FactorRange xdr = (FactorRange)new FactorRange().factors().apply((Object)day_names);
        FactorRange ydr = (FactorRange)new FactorRange().factors().apply((Object)((TraversableOnce)((SeqLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), month_weeks).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int x$3) {
                return ((Object)BoxesRunTime.boxToInteger((int)x$3)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).reverse()).toList());
        Plot plot = (Plot)((Plot)((Plot)((Plot)((Plot)((Plot)((Plot)new Plot().title().apply((Object)this.month_names()[month - 1])).title_text_color().apply((Object)Color.DarkOliveGreen$.MODULE$)).x_range().apply((Object)xdr)).y_range().apply((Object)ydr)).width().apply((Object)BoxesRunTime.boxToInteger((int)300))).height().apply((Object)BoxesRunTime.boxToInteger((int)300))).outline_line_color().apply();
        Rect days_glyph = (Rect)((LineProps)((FillProps)((Rect)((Rect)((Rect)new Rect().x().apply(symbol$1)).y().apply(symbol$2)).width().apply((Object)BoxesRunTime.boxToDouble((double)0.9))).height().apply((Object)BoxesRunTime.boxToDouble((double)0.9))).fill_color().apply(symbol$4)).line_color().apply((Object)Color.Silver$.MODULE$);
        GlyphRenderer days_renderer = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)source)).glyph().apply((Object)days_glyph);
        Rect holidays_glyph = (Rect)((LineProps)((FillProps)((Rect)((Rect)((Rect)new Rect().x().apply(symbol$5)).y().apply(symbol$6)).width().apply((Object)BoxesRunTime.boxToDouble((double)0.9))).height().apply((Object)BoxesRunTime.boxToDouble((double)0.9))).fill_color().apply((Object)Color.Pink$.MODULE$)).line_color().apply((Object)Color.IndianRed$.MODULE$);
        GlyphRenderer holidays_renderer = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)holidays_source)).glyph().apply((Object)holidays_glyph);
        Text text_glyph = (Text)((TextProps)((TextProps)((Text)((Text)new Text().x().apply(symbol$1)).y().apply(symbol$2)).text().apply(symbol$3)).text_align().apply((Object)TextAlign.Center$.MODULE$)).text_baseline().apply((Object)TextBaseline.Middle$.MODULE$);
        GlyphRenderer text_renderer = (GlyphRenderer)((GlyphRenderer)new GlyphRenderer().data_source().apply((Object)source)).glyph().apply((Object)text_glyph);
        CategoricalAxis xaxis = (CategoricalAxis)((Axis)((Axis)((Axis)((Axis)new CategoricalAxis().plot().apply((Object)plot)).major_label_text_font_size().apply((Object)package$.MODULE$.NumbericOps((Object)BoxesRunTime.boxToInteger((int)8), (Numeric)Numeric.IntIsIntegral$.MODULE$).pt())).major_label_standoff().apply((Object)BoxesRunTime.boxToInteger((int)0))).major_tick_line_color().apply()).axis_line_color().apply();
        plot.above().$less$less$eq((Function1)new Serializable(xaxis){
            public static final long serialVersionUID = 0L;
            private final CategoricalAxis xaxis$1;

            public final List<Renderer> apply(List<Renderer> x$4) {
                CategoricalAxis categoricalAxis = this.xaxis$1;
                return x$4.$colon$colon((Object)categoricalAxis);
            }
            {
                this.xaxis$1 = xaxis$1;
            }
        });
        GlyphRenderer glyphRenderer = holidays_renderer;
        Tuple2 tuple2 = new Tuple2((Object)"Holiday", (Object)"@month_holidays");
        HoverTool hoverTool = hover_tool = (HoverTool)((HoverTool)((TransientSelectTool)new HoverTool().plot().apply((Object)plot)).renderers().apply((Object)Nil$.MODULE$.$colon$colon((Object)glyphRenderer))).tooltips().apply((Object)Nil$.MODULE$.$colon$colon((Object)tuple2));
        plot.tools().$colon$eq((Object)Nil$.MODULE$.$colon$colon((Object)hoverTool));
        CategoricalAxis categoricalAxis = xaxis;
        GlyphRenderer glyphRenderer2 = days_renderer;
        GlyphRenderer glyphRenderer3 = holidays_renderer;
        GlyphRenderer glyphRenderer4 = text_renderer;
        plot.renderers().$colon$eq((Object)Nil$.MODULE$.$colon$colon((Object)glyphRenderer4).$colon$colon((Object)glyphRenderer3).$colon$colon((Object)glyphRenderer2).$colon$colon((Object)categoricalAxis));
        return plot;
    }

    public String make_calendar$default$3() {
        return "Mon";
    }

    public List<List<Plot>> months() {
        return this.months;
    }

    public GridPlot grid() {
        return this.grid;
    }

    public Document document() {
        return this.document;
    }

    public HTMLFile html() {
        return this.html;
    }

    public final int io$continuum$bokeh$examples$glyphs$Calendars$$weekday$1(LocalDate date, int firstweekday$1) {
        return (this.DateOps(date).weekday() - firstweekday$1) % 7;
    }

    private final List pick_weekdays$1(List days, int firstweekday$1) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(firstweekday$1), firstweekday$1 + 7).map((Function1)new Serializable(days){
            public static final long serialVersionUID = 0L;
            private final List days$1;

            public final T apply(int i) {
                return (T)this.days$1.apply(i % 7);
            }
            {
                this.days$1 = days$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
    }

    public final void delayedEndpoint$io$continuum$bokeh$examples$glyphs$Calendars$1() {
        this.symbols = new DateFormatSymbols(Locale.US);
        this.day_abbrs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}));
        this.month_names = (String[])Predef$.MODULE$.refArrayOps((Object[])this.symbols().getMonths()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
            }
        });
        this.months = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Plot> apply(int i) {
                return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).map((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final Plot apply(int j) {
                        return Calendars$.MODULE$.make_calendar(2014, 3 * this.i$1 + j + 1, Calendars$.MODULE$.make_calendar$default$3());
                    }
                    {
                        this.i$1 = i$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toList();
        this.grid = (GridPlot)((GridPlot)((Plot)new GridPlot().title().apply((Object)"Calendar 2014")).toolbar_location().apply()).children().apply(this.months());
        this.document = new Document((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Widget[]{this.grid()}));
        this.html = this.document().save("calendars.html", this.config().resources());
        this.info((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrote ", ". Open ", " in a web browser."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Calendars$.MODULE$.html().file(), Calendars$.MODULE$.html().url()}));
            }
        });
    }

    private Calendars$() {
        MODULE$ = this;
        App.class.$init$((App)this);
        Example$class.$init$(this);
        this.delayedInit((Function0<BoxedUnit>)new Calendars.delayedInit.body(this));
    }
}

