package io.continuum.bokeh

object Palette {
    type Palette = List[Color]

    val YlGn3: Palette      = List("#31a354", "#addd8e", "#f7fcb9")
    val YlGn4: Palette      = List("#238443", "#78c679", "#c2e699", "#ffffcc")
    val YlGn5: Palette      = List("#006837", "#31a354", "#78c679", "#c2e699", "#ffffcc")
    val YlGn6: Palette      = List("#006837", "#31a354", "#78c679", "#addd8e", "#d9f0a3", "#ffffcc")
    val YlGn7: Palette      = List("#005a32", "#238443", "#41ab5d", "#78c679", "#addd8e", "#d9f0a3", "#ffffcc")
    val YlGn8: Palette      = List("#005a32", "#238443", "#41ab5d", "#78c679", "#addd8e", "#d9f0a3", "#f7fcb9", "#ffffe5")
    val YlGn9: Palette      = List("#004529", "#006837", "#238443", "#41ab5d", "#78c679", "#addd8e", "#d9f0a3", "#f7fcb9", "#ffffe5")

    val YlGnBu3: Palette    = List("#2c7fb8", "#7fcdbb", "#edf8b1")
    val YlGnBu4: Palette    = List("#225ea8", "#41b6c4", "#a1dab4", "#ffffcc")
    val YlGnBu5: Palette    = List("#253494", "#2c7fb8", "#41b6c4", "#a1dab4", "#ffffcc")
    val YlGnBu6: Palette    = List("#253494", "#2c7fb8", "#41b6c4", "#7fcdbb", "#c7e9b4", "#ffffcc")
    val YlGnBu7: Palette    = List("#0c2c84", "#225ea8", "#1d91c0", "#41b6c4", "#7fcdbb", "#c7e9b4", "#ffffcc")
    val YlGnBu8: Palette    = List("#0c2c84", "#225ea8", "#1d91c0", "#41b6c4", "#7fcdbb", "#c7e9b4", "#edf8b1", "#ffffd9")
    val YlGnBu9: Palette    = List("#081d58", "#253494", "#225ea8", "#1d91c0", "#41b6c4", "#7fcdbb", "#c7e9b4", "#edf8b1", "#ffffd9")

    val GnBu3: Palette      = List("#43a2ca", "#a8ddb5", "#e0f3db")
    val GnBu4: Palette      = List("#2b8cbe", "#7bccc4", "#bae4bc", "#f0f9e8")
    val GnBu5: Palette      = List("#0868ac", "#43a2ca", "#7bccc4", "#bae4bc", "#f0f9e8")
    val GnBu6: Palette      = List("#0868ac", "#43a2ca", "#7bccc4", "#a8ddb5", "#ccebc5", "#f0f9e8")
    val GnBu7: Palette      = List("#08589e", "#2b8cbe", "#4eb3d3", "#7bccc4", "#a8ddb5", "#ccebc5", "#f0f9e8")
    val GnBu8: Palette      = List("#08589e", "#2b8cbe", "#4eb3d3", "#7bccc4", "#a8ddb5", "#ccebc5", "#e0f3db", "#f7fcf0")
    val GnBu9: Palette      = List("#084081", "#0868ac", "#2b8cbe", "#4eb3d3", "#7bccc4", "#a8ddb5", "#ccebc5", "#e0f3db", "#f7fcf0")

    val BuGn3: Palette      = List("#2ca25f", "#99d8c9", "#e5f5f9")
    val BuGn4: Palette      = List("#238b45", "#66c2a4", "#b2e2e2", "#edf8fb")
    val BuGn5: Palette      = List("#006d2c", "#2ca25f", "#66c2a4", "#b2e2e2", "#edf8fb")
    val BuGn6: Palette      = List("#006d2c", "#2ca25f", "#66c2a4", "#99d8c9", "#ccece6", "#edf8fb")
    val BuGn7: Palette      = List("#005824", "#238b45", "#41ae76", "#66c2a4", "#99d8c9", "#ccece6", "#edf8fb")
    val BuGn8: Palette      = List("#005824", "#238b45", "#41ae76", "#66c2a4", "#99d8c9", "#ccece6", "#e5f5f9", "#f7fcfd")
    val BuGn9: Palette      = List("#00441b", "#006d2c", "#238b45", "#41ae76", "#66c2a4", "#99d8c9", "#ccece6", "#e5f5f9", "#f7fcfd")

    val PuBuGn3: Palette    = List("#1c9099", "#a6bddb", "#ece2f0")
    val PuBuGn4: Palette    = List("#02818a", "#67a9cf", "#bdc9e1", "#f6eff7")
    val PuBuGn5: Palette    = List("#016c59", "#1c9099", "#67a9cf", "#bdc9e1", "#f6eff7")
    val PuBuGn6: Palette    = List("#016c59", "#1c9099", "#67a9cf", "#a6bddb", "#d0d1e6", "#f6eff7")
    val PuBuGn7: Palette    = List("#016450", "#02818a", "#3690c0", "#67a9cf", "#a6bddb", "#d0d1e6", "#f6eff7")
    val PuBuGn8: Palette    = List("#016450", "#02818a", "#3690c0", "#67a9cf", "#a6bddb", "#d0d1e6", "#ece2f0", "#fff7fb")
    val PuBuGn9: Palette    = List("#014636", "#016c59", "#02818a", "#3690c0", "#67a9cf", "#a6bddb", "#d0d1e6", "#ece2f0", "#fff7fb")

    val PuBu3: Palette      = List("#2b8cbe", "#a6bddb", "#ece7f2")
    val PuBu4: Palette      = List("#0570b0", "#74a9cf", "#bdc9e1", "#f1eef6")
    val PuBu5: Palette      = List("#045a8d", "#2b8cbe", "#74a9cf", "#bdc9e1", "#f1eef6")
    val PuBu6: Palette      = List("#045a8d", "#2b8cbe", "#74a9cf", "#a6bddb", "#d0d1e6", "#f1eef6")
    val PuBu7: Palette      = List("#034e7b", "#0570b0", "#3690c0", "#74a9cf", "#a6bddb", "#d0d1e6", "#f1eef6")
    val PuBu8: Palette      = List("#034e7b", "#0570b0", "#3690c0", "#74a9cf", "#a6bddb", "#d0d1e6", "#ece7f2", "#fff7fb")
    val PuBu9: Palette      = List("#023858", "#045a8d", "#0570b0", "#3690c0", "#74a9cf", "#a6bddb", "#d0d1e6", "#ece7f2", "#fff7fb")

    val BuPu3: Palette      = List("#8856a7", "#9ebcda", "#e0ecf4")
    val BuPu4: Palette      = List("#88419d", "#8c96c6", "#b3cde3", "#edf8fb")
    val BuPu5: Palette      = List("#810f7c", "#8856a7", "#8c96c6", "#b3cde3", "#edf8fb")
    val BuPu6: Palette      = List("#810f7c", "#8856a7", "#8c96c6", "#9ebcda", "#bfd3e6", "#edf8fb")
    val BuPu7: Palette      = List("#6e016b", "#88419d", "#8c6bb1", "#8c96c6", "#9ebcda", "#bfd3e6", "#edf8fb")
    val BuPu8: Palette      = List("#6e016b", "#88419d", "#8c6bb1", "#8c96c6", "#9ebcda", "#bfd3e6", "#e0ecf4", "#f7fcfd")
    val BuPu9: Palette      = List("#4d004b", "#810f7c", "#88419d", "#8c6bb1", "#8c96c6", "#9ebcda", "#bfd3e6", "#e0ecf4", "#f7fcfd")

    val RdPu3: Palette      = List("#c51b8a", "#fa9fb5", "#fde0dd")
    val RdPu4: Palette      = List("#ae017e", "#f768a1", "#fbb4b9", "#feebe2")
    val RdPu5: Palette      = List("#7a0177", "#c51b8a", "#f768a1", "#fbb4b9", "#feebe2")
    val RdPu6: Palette      = List("#7a0177", "#c51b8a", "#f768a1", "#fa9fb5", "#fcc5c0", "#feebe2")
    val RdPu7: Palette      = List("#7a0177", "#ae017e", "#dd3497", "#f768a1", "#fa9fb5", "#fcc5c0", "#feebe2")
    val RdPu8: Palette      = List("#7a0177", "#ae017e", "#dd3497", "#f768a1", "#fa9fb5", "#fcc5c0", "#fde0dd", "#fff7f3")
    val RdPu9: Palette      = List("#49006a", "#7a0177", "#ae017e", "#dd3497", "#f768a1", "#fa9fb5", "#fcc5c0", "#fde0dd", "#fff7f3")

    val PuRd3: Palette      = List("#dd1c77", "#c994c7", "#e7e1ef")
    val PuRd4: Palette      = List("#ce1256", "#df65b0", "#d7b5d8", "#f1eef6")
    val PuRd5: Palette      = List("#980043", "#dd1c77", "#df65b0", "#d7b5d8", "#f1eef6")
    val PuRd6: Palette      = List("#980043", "#dd1c77", "#df65b0", "#c994c7", "#d4b9da", "#f1eef6")
    val PuRd7: Palette      = List("#91003f", "#ce1256", "#e7298a", "#df65b0", "#c994c7", "#d4b9da", "#f1eef6")
    val PuRd8: Palette      = List("#91003f", "#ce1256", "#e7298a", "#df65b0", "#c994c7", "#d4b9da", "#e7e1ef", "#f7f4f9")
    val PuRd9: Palette      = List("#67001f", "#980043", "#ce1256", "#e7298a", "#df65b0", "#c994c7", "#d4b9da", "#e7e1ef", "#f7f4f9")

    val OrRd3: Palette      = List("#e34a33", "#fdbb84", "#fee8c8")
    val OrRd4: Palette      = List("#d7301f", "#fc8d59", "#fdcc8a", "#fef0d9")
    val OrRd5: Palette      = List("#b30000", "#e34a33", "#fc8d59", "#fdcc8a", "#fef0d9")
    val OrRd6: Palette      = List("#b30000", "#e34a33", "#fc8d59", "#fdbb84", "#fdd49e", "#fef0d9")
    val OrRd7: Palette      = List("#990000", "#d7301f", "#ef6548", "#fc8d59", "#fdbb84", "#fdd49e", "#fef0d9")
    val OrRd8: Palette      = List("#990000", "#d7301f", "#ef6548", "#fc8d59", "#fdbb84", "#fdd49e", "#fee8c8", "#fff7ec")
    val OrRd9: Palette      = List("#7f0000", "#b30000", "#d7301f", "#ef6548", "#fc8d59", "#fdbb84", "#fdd49e", "#fee8c8", "#fff7ec")

    val YlOrRd3: Palette    = List("#f03b20", "#feb24c", "#ffeda0")
    val YlOrRd4: Palette    = List("#e31a1c", "#fd8d3c", "#fecc5c", "#ffffb2")
    val YlOrRd5: Palette    = List("#bd0026", "#f03b20", "#fd8d3c", "#fecc5c", "#ffffb2")
    val YlOrRd6: Palette    = List("#bd0026", "#f03b20", "#fd8d3c", "#feb24c", "#fed976", "#ffffb2")
    val YlOrRd7: Palette    = List("#b10026", "#e31a1c", "#fc4e2a", "#fd8d3c", "#feb24c", "#fed976", "#ffffb2")
    val YlOrRd8: Palette    = List("#b10026", "#e31a1c", "#fc4e2a", "#fd8d3c", "#feb24c", "#fed976", "#ffeda0", "#ffffcc")
    val YlOrRd9: Palette    = List("#800026", "#bd0026", "#e31a1c", "#fc4e2a", "#fd8d3c", "#feb24c", "#fed976", "#ffeda0", "#ffffcc")

    val YlOrBr3: Palette    = List("#d95f0e", "#fec44f", "#fff7bc")
    val YlOrBr4: Palette    = List("#cc4c02", "#fe9929", "#fed98e", "#ffffd4")
    val YlOrBr5: Palette    = List("#993404", "#d95f0e", "#fe9929", "#fed98e", "#ffffd4")
    val YlOrBr6: Palette    = List("#993404", "#d95f0e", "#fe9929", "#fec44f", "#fee391", "#ffffd4")
    val YlOrBr7: Palette    = List("#8c2d04", "#cc4c02", "#ec7014", "#fe9929", "#fec44f", "#fee391", "#ffffd4")
    val YlOrBr8: Palette    = List("#8c2d04", "#cc4c02", "#ec7014", "#fe9929", "#fec44f", "#fee391", "#fff7bc", "#ffffe5")
    val YlOrBr9: Palette    = List("#662506", "#993404", "#cc4c02", "#ec7014", "#fe9929", "#fec44f", "#fee391", "#fff7bc", "#ffffe5")

    val Purples3: Palette   = List("#756bb1", "#bcbddc", "#efedf5")
    val Purples4: Palette   = List("#6a51a3", "#9e9ac8", "#cbc9e2", "#f2f0f7")
    val Purples5: Palette   = List("#54278f", "#756bb1", "#9e9ac8", "#cbc9e2", "#f2f0f7")
    val Purples6: Palette   = List("#54278f", "#756bb1", "#9e9ac8", "#bcbddc", "#dadaeb", "#f2f0f7")
    val Purples7: Palette   = List("#4a1486", "#6a51a3", "#807dba", "#9e9ac8", "#bcbddc", "#dadaeb", "#f2f0f7")
    val Purples8: Palette   = List("#4a1486", "#6a51a3", "#807dba", "#9e9ac8", "#bcbddc", "#dadaeb", "#efedf5", "#fcfbfd")
    val Purples9: Palette   = List("#3f007d", "#54278f", "#6a51a3", "#807dba", "#9e9ac8", "#bcbddc", "#dadaeb", "#efedf5", "#fcfbfd")

    val Blues3: Palette     = List("#3182bd", "#9ecae1", "#deebf7")
    val Blues4: Palette     = List("#2171b5", "#6baed6", "#bdd7e7", "#eff3ff")
    val Blues5: Palette     = List("#08519c", "#3182bd", "#6baed6", "#bdd7e7", "#eff3ff")
    val Blues6: Palette     = List("#08519c", "#3182bd", "#6baed6", "#9ecae1", "#c6dbef", "#eff3ff")
    val Blues7: Palette     = List("#084594", "#2171b5", "#4292c6", "#6baed6", "#9ecae1", "#c6dbef", "#eff3ff")
    val Blues8: Palette     = List("#084594", "#2171b5", "#4292c6", "#6baed6", "#9ecae1", "#c6dbef", "#deebf7", "#f7fbff")
    val Blues9: Palette     = List("#08306b", "#08519c", "#2171b5", "#4292c6", "#6baed6", "#9ecae1", "#c6dbef", "#deebf7", "#f7fbff")

    val Greens3: Palette    = List("#31a354", "#a1d99b", "#e5f5e0")
    val Greens4: Palette    = List("#238b45", "#74c476", "#bae4b3", "#edf8e9")
    val Greens5: Palette    = List("#006d2c", "#31a354", "#74c476", "#bae4b3", "#edf8e9")
    val Greens6: Palette    = List("#006d2c", "#31a354", "#74c476", "#a1d99b", "#c7e9c0", "#edf8e9")
    val Greens7: Palette    = List("#005a32", "#238b45", "#41ab5d", "#74c476", "#a1d99b", "#c7e9c0", "#edf8e9")
    val Greens8: Palette    = List("#005a32", "#238b45", "#41ab5d", "#74c476", "#a1d99b", "#c7e9c0", "#e5f5e0", "#f7fcf5")
    val Greens9: Palette    = List("#00441b", "#006d2c", "#238b45", "#41ab5d", "#74c476", "#a1d99b", "#c7e9c0", "#e5f5e0", "#f7fcf5")

    val Oranges3: Palette   = List("#e6550d", "#fdae6b", "#fee6ce")
    val Oranges4: Palette   = List("#d94701", "#fd8d3c", "#fdbe85", "#feedde")
    val Oranges5: Palette   = List("#a63603", "#e6550d", "#fd8d3c", "#fdbe85", "#feedde")
    val Oranges6: Palette   = List("#a63603", "#e6550d", "#fd8d3c", "#fdae6b", "#fdd0a2", "#feedde")
    val Oranges7: Palette   = List("#8c2d04", "#d94801", "#f16913", "#fd8d3c", "#fdae6b", "#fdd0a2", "#feedde")
    val Oranges8: Palette   = List("#8c2d04", "#d94801", "#f16913", "#fd8d3c", "#fdae6b", "#fdd0a2", "#fee6ce", "#fff5eb")
    val Oranges9: Palette   = List("#7f2704", "#a63603", "#d94801", "#f16913", "#fd8d3c", "#fdae6b", "#fdd0a2", "#fee6ce", "#fff5eb")

    val Reds3: Palette      = List("#de2d26", "#fc9272", "#fee0d2")
    val Reds4: Palette      = List("#cb181d", "#fb6a4a", "#fcae91", "#fee5d9")
    val Reds5: Palette      = List("#a50f15", "#de2d26", "#fb6a4a", "#fcae91", "#fee5d9")
    val Reds6: Palette      = List("#a50f15", "#de2d26", "#fb6a4a", "#fc9272", "#fcbba1", "#fee5d9")
    val Reds7: Palette      = List("#99000d", "#cb181d", "#ef3b2c", "#fb6a4a", "#fc9272", "#fcbba1", "#fee5d9")
    val Reds8: Palette      = List("#99000d", "#cb181d", "#ef3b2c", "#fb6a4a", "#fc9272", "#fcbba1", "#fee0d2", "#fff5f0")
    val Reds9: Palette      = List("#67000d", "#a50f15", "#cb181d", "#ef3b2c", "#fb6a4a", "#fc9272", "#fcbba1", "#fee0d2", "#fff5f0")

    val Greys3: Palette     = List("#636363", "#bdbdbd", "#f0f0f0")
    val Greys4: Palette     = List("#525252", "#969696", "#cccccc", "#f7f7f7")
    val Greys5: Palette     = List("#252525", "#636363", "#969696", "#cccccc", "#f7f7f7")
    val Greys6: Palette     = List("#252525", "#636363", "#969696", "#bdbdbd", "#d9d9d9", "#f7f7f7")
    val Greys7: Palette     = List("#252525", "#525252", "#737373", "#969696", "#bdbdbd", "#d9d9d9", "#f7f7f7")
    val Greys8: Palette     = List("#252525", "#525252", "#737373", "#969696", "#bdbdbd", "#d9d9d9", "#f0f0f0", "#ffffff")
    val Greys9: Palette     = List("#000000", "#252525", "#525252", "#737373", "#969696", "#bdbdbd", "#d9d9d9", "#f0f0f0", "#ffffff")

    val PuOr3: Palette      = List("#998ec3", "#f7f7f7", "#f1a340")
    val PuOr4: Palette      = List("#5e3c99", "#b2abd2", "#fdb863", "#e66101")
    val PuOr5: Palette      = List("#5e3c99", "#b2abd2", "#f7f7f7", "#fdb863", "#e66101")
    val PuOr6: Palette      = List("#542788", "#998ec3", "#d8daeb", "#fee0b6", "#f1a340", "#b35806")
    val PuOr7: Palette      = List("#542788", "#998ec3", "#d8daeb", "#f7f7f7", "#fee0b6", "#f1a340", "#b35806")
    val PuOr8: Palette      = List("#542788", "#8073ac", "#b2abd2", "#d8daeb", "#fee0b6", "#fdb863", "#e08214", "#b35806")
    val PuOr9: Palette      = List("#542788", "#8073ac", "#b2abd2", "#d8daeb", "#f7f7f7", "#fee0b6", "#fdb863", "#e08214", "#b35806")
    val PuOr10: Palette     = List("#2d004b", "#542788", "#8073ac", "#b2abd2", "#d8daeb", "#fee0b6", "#fdb863", "#e08214", "#b35806", "#7f3b08")
    val PuOr11: Palette     = List("#2d004b", "#542788", "#8073ac", "#b2abd2", "#d8daeb", "#f7f7f7", "#fee0b6", "#fdb863", "#e08214", "#b35806", "#7f3b08")

    val BrBG3: Palette      = List("#5ab4ac", "#f5f5f5", "#d8b365")
    val BrBG4: Palette      = List("#018571", "#80cdc1", "#dfc27d", "#a6611a")
    val BrBG5: Palette      = List("#018571", "#80cdc1", "#f5f5f5", "#dfc27d", "#a6611a")
    val BrBG6: Palette      = List("#01665e", "#5ab4ac", "#c7eae5", "#f6e8c3", "#d8b365", "#8c510a")
    val BrBG7: Palette      = List("#01665e", "#5ab4ac", "#c7eae5", "#f5f5f5", "#f6e8c3", "#d8b365", "#8c510a")
    val BrBG8: Palette      = List("#01665e", "#35978f", "#80cdc1", "#c7eae5", "#f6e8c3", "#dfc27d", "#bf812d", "#8c510a")
    val BrBG9: Palette      = List("#01665e", "#35978f", "#80cdc1", "#c7eae5", "#f5f5f5", "#f6e8c3", "#dfc27d", "#bf812d", "#8c510a")
    val BrBG10: Palette     = List("#003c30", "#01665e", "#35978f", "#80cdc1", "#c7eae5", "#f6e8c3", "#dfc27d", "#bf812d", "#8c510a", "#543005")
    val BrBG11: Palette     = List("#003c30", "#01665e", "#35978f", "#80cdc1", "#c7eae5", "#f5f5f5", "#f6e8c3", "#dfc27d", "#bf812d", "#8c510a", "#543005")

    val PRGn3: Palette      = List("#7fbf7b", "#f7f7f7", "#af8dc3")
    val PRGn4: Palette      = List("#008837", "#a6dba0", "#c2a5cf", "#7b3294")
    val PRGn5: Palette      = List("#008837", "#a6dba0", "#f7f7f7", "#c2a5cf", "#7b3294")
    val PRGn6: Palette      = List("#1b7837", "#7fbf7b", "#d9f0d3", "#e7d4e8", "#af8dc3", "#762a83")
    val PRGn7: Palette      = List("#1b7837", "#7fbf7b", "#d9f0d3", "#f7f7f7", "#e7d4e8", "#af8dc3", "#762a83")
    val PRGn8: Palette      = List("#1b7837", "#5aae61", "#a6dba0", "#d9f0d3", "#e7d4e8", "#c2a5cf", "#9970ab", "#762a83")
    val PRGn9: Palette      = List("#1b7837", "#5aae61", "#a6dba0", "#d9f0d3", "#f7f7f7", "#e7d4e8", "#c2a5cf", "#9970ab", "#762a83")
    val PRGn10: Palette     = List("#00441b", "#1b7837", "#5aae61", "#a6dba0", "#d9f0d3", "#e7d4e8", "#c2a5cf", "#9970ab", "#762a83", "#40004b")
    val PRGn11: Palette     = List("#00441b", "#1b7837", "#5aae61", "#a6dba0", "#d9f0d3", "#f7f7f7", "#e7d4e8", "#c2a5cf", "#9970ab", "#762a83", "#40004b")

    val PiYG3: Palette      = List("#a1d76a", "#f7f7f7", "#e9a3c9")
    val PiYG4: Palette      = List("#4dac26", "#b8e186", "#f1b6da", "#d01c8b")
    val PiYG5: Palette      = List("#4dac26", "#b8e186", "#f7f7f7", "#f1b6da", "#d01c8b")
    val PiYG6: Palette      = List("#4d9221", "#a1d76a", "#e6f5d0", "#fde0ef", "#e9a3c9", "#c51b7d")
    val PiYG7: Palette      = List("#4d9221", "#a1d76a", "#e6f5d0", "#f7f7f7", "#fde0ef", "#e9a3c9", "#c51b7d")
    val PiYG8: Palette      = List("#4d9221", "#7fbc41", "#b8e186", "#e6f5d0", "#fde0ef", "#f1b6da", "#de77ae", "#c51b7d")
    val PiYG9: Palette      = List("#4d9221", "#7fbc41", "#b8e186", "#e6f5d0", "#f7f7f7", "#fde0ef", "#f1b6da", "#de77ae", "#c51b7d")
    val PiYG10: Palette     = List("#276419", "#4d9221", "#7fbc41", "#b8e186", "#e6f5d0", "#fde0ef", "#f1b6da", "#de77ae", "#c51b7d", "#8e0152")
    val PiYG11: Palette     = List("#276419", "#4d9221", "#7fbc41", "#b8e186", "#e6f5d0", "#f7f7f7", "#fde0ef", "#f1b6da", "#de77ae", "#c51b7d", "#8e0152")

    val RdBu3: Palette      = List("#67a9cf", "#f7f7f7", "#ef8a62")
    val RdBu4: Palette      = List("#0571b0", "#92c5de", "#f4a582", "#ca0020")
    val RdBu5: Palette      = List("#0571b0", "#92c5de", "#f7f7f7", "#f4a582", "#ca0020")
    val RdBu6: Palette      = List("#2166ac", "#67a9cf", "#d1e5f0", "#fddbc7", "#ef8a62", "#b2182b")
    val RdBu7: Palette      = List("#2166ac", "#67a9cf", "#d1e5f0", "#f7f7f7", "#fddbc7", "#ef8a62", "#b2182b")
    val RdBu8: Palette      = List("#2166ac", "#4393c3", "#92c5de", "#d1e5f0", "#fddbc7", "#f4a582", "#d6604d", "#b2182b")
    val RdBu9: Palette      = List("#2166ac", "#4393c3", "#92c5de", "#d1e5f0", "#f7f7f7", "#fddbc7", "#f4a582", "#d6604d", "#b2182b")
    val RdBu10: Palette     = List("#053061", "#2166ac", "#4393c3", "#92c5de", "#d1e5f0", "#fddbc7", "#f4a582", "#d6604d", "#b2182b", "#67001f")
    val RdBu11: Palette     = List("#053061", "#2166ac", "#4393c3", "#92c5de", "#d1e5f0", "#f7f7f7", "#fddbc7", "#f4a582", "#d6604d", "#b2182b", "#67001f")

    val RdGy3: Palette      = List("#999999", "#ffffff", "#ef8a62")
    val RdGy4: Palette      = List("#404040", "#bababa", "#f4a582", "#ca0020")
    val RdGy5: Palette      = List("#404040", "#bababa", "#ffffff", "#f4a582", "#ca0020")
    val RdGy6: Palette      = List("#4d4d4d", "#999999", "#e0e0e0", "#fddbc7", "#ef8a62", "#b2182b")
    val RdGy7: Palette      = List("#4d4d4d", "#999999", "#e0e0e0", "#ffffff", "#fddbc7", "#ef8a62", "#b2182b")
    val RdGy8: Palette      = List("#4d4d4d", "#878787", "#bababa", "#e0e0e0", "#fddbc7", "#f4a582", "#d6604d", "#b2182b")
    val RdGy9: Palette      = List("#4d4d4d", "#878787", "#bababa", "#e0e0e0", "#ffffff", "#fddbc7", "#f4a582", "#d6604d", "#b2182b")
    val RdGy10: Palette     = List("#1a1a1a", "#4d4d4d", "#878787", "#bababa", "#e0e0e0", "#fddbc7", "#f4a582", "#d6604d", "#b2182b", "#67001f")
    val RdGy11: Palette     = List("#1a1a1a", "#4d4d4d", "#878787", "#bababa", "#e0e0e0", "#ffffff", "#fddbc7", "#f4a582", "#d6604d", "#b2182b", "#67001f")

    val RdYlBu3: Palette    = List("#91bfdb", "#ffffbf", "#fc8d59")
    val RdYlBu4: Palette    = List("#2c7bb6", "#abd9e9", "#fdae61", "#d7191c")
    val RdYlBu5: Palette    = List("#2c7bb6", "#abd9e9", "#ffffbf", "#fdae61", "#d7191c")
    val RdYlBu6: Palette    = List("#4575b4", "#91bfdb", "#e0f3f8", "#fee090", "#fc8d59", "#d73027")
    val RdYlBu7: Palette    = List("#4575b4", "#91bfdb", "#e0f3f8", "#ffffbf", "#fee090", "#fc8d59", "#d73027")
    val RdYlBu8: Palette    = List("#4575b4", "#74add1", "#abd9e9", "#e0f3f8", "#fee090", "#fdae61", "#f46d43", "#d73027")
    val RdYlBu9: Palette    = List("#4575b4", "#74add1", "#abd9e9", "#e0f3f8", "#ffffbf", "#fee090", "#fdae61", "#f46d43", "#d73027")
    val RdYlBu10: Palette   = List("#313695", "#4575b4", "#74add1", "#abd9e9", "#e0f3f8", "#fee090", "#fdae61", "#f46d43", "#d73027", "#a50026")
    val RdYlBu11: Palette   = List("#313695", "#4575b4", "#74add1", "#abd9e9", "#e0f3f8", "#ffffbf", "#fee090", "#fdae61", "#f46d43", "#d73027", "#a50026")

    val Spectral3: Palette  = List("#99d594", "#ffffbf", "#fc8d59")
    val Spectral4: Palette  = List("#2b83ba", "#abdda4", "#fdae61", "#d7191c")
    val Spectral5: Palette  = List("#2b83ba", "#abdda4", "#ffffbf", "#fdae61", "#d7191c")
    val Spectral6: Palette  = List("#3288bd", "#99d594", "#e6f598", "#fee08b", "#fc8d59", "#d53e4f")
    val Spectral7: Palette  = List("#3288bd", "#99d594", "#e6f598", "#ffffbf", "#fee08b", "#fc8d59", "#d53e4f")
    val Spectral8: Palette  = List("#3288bd", "#66c2a5", "#abdda4", "#e6f598", "#fee08b", "#fdae61", "#f46d43", "#d53e4f")
    val Spectral9: Palette  = List("#3288bd", "#66c2a5", "#abdda4", "#e6f598", "#ffffbf", "#fee08b", "#fdae61", "#f46d43", "#d53e4f")
    val Spectral10: Palette = List("#5e4fa2", "#3288bd", "#66c2a5", "#abdda4", "#e6f598", "#fee08b", "#fdae61", "#f46d43", "#d53e4f", "#9e0142")
    val Spectral11: Palette = List("#5e4fa2", "#3288bd", "#66c2a5", "#abdda4", "#e6f598", "#ffffbf", "#fee08b", "#fdae61", "#f46d43", "#d53e4f", "#9e0142")

    val RdYlGn3: Palette    = List("#91cf60", "#ffffbf", "#fc8d59")
    val RdYlGn4: Palette    = List("#1a9641", "#a6d96a", "#fdae61", "#d7191c")
    val RdYlGn5: Palette    = List("#1a9641", "#a6d96a", "#ffffbf", "#fdae61", "#d7191c")
    val RdYlGn6: Palette    = List("#1a9850", "#91cf60", "#d9ef8b", "#fee08b", "#fc8d59", "#d73027")
    val RdYlGn7: Palette    = List("#1a9850", "#91cf60", "#d9ef8b", "#ffffbf", "#fee08b", "#fc8d59", "#d73027")
    val RdYlGn8: Palette    = List("#1a9850", "#66bd63", "#a6d96a", "#d9ef8b", "#fee08b", "#fdae61", "#f46d43", "#d73027")
    val RdYlGn9: Palette    = List("#1a9850", "#66bd63", "#a6d96a", "#d9ef8b", "#ffffbf", "#fee08b", "#fdae61", "#f46d43", "#d73027")
    val RdYlGn10: Palette   = List("#006837", "#1a9850", "#66bd63", "#a6d96a", "#d9ef8b", "#fee08b", "#fdae61", "#f46d43", "#d73027", "#a50026")
    val RdYlGn11: Palette   = List("#006837", "#1a9850", "#66bd63", "#a6d96a", "#d9ef8b", "#ffffbf", "#fee08b", "#fdae61", "#f46d43", "#d73027", "#a50026")

    val brewer: Map[String, Map[Int, Palette]] = Map(
        "YlGn"     -> Map(3 -> YlGn3,     4 -> YlGn4,     5 -> YlGn5,     6 -> YlGn6,     7 -> YlGn7,     8 -> YlGn8,     9 -> YlGn9    ),
        "YlGnBu"   -> Map(3 -> YlGnBu3,   4 -> YlGnBu4,   5 -> YlGnBu5,   6 -> YlGnBu6,   7 -> YlGnBu7,   8 -> YlGnBu8,   9 -> YlGnBu9  ),
        "GnBu"     -> Map(3 -> GnBu3,     4 -> GnBu4,     5 -> GnBu5,     6 -> GnBu6,     7 -> GnBu7,     8 -> GnBu8,     9 -> GnBu9    ),
        "BuGn"     -> Map(3 -> BuGn3,     4 -> BuGn4,     5 -> BuGn5,     6 -> BuGn6,     7 -> BuGn7,     8 -> BuGn8,     9 -> BuGn9    ),
        "PuBuGn"   -> Map(3 -> PuBuGn3,   4 -> PuBuGn4,   5 -> PuBuGn5,   6 -> PuBuGn6,   7 -> PuBuGn7,   8 -> PuBuGn8,   9 -> PuBuGn9  ),
        "PuBu"     -> Map(3 -> PuBu3,     4 -> PuBu4,     5 -> PuBu5,     6 -> PuBu6,     7 -> PuBu7,     8 -> PuBu8,     9 -> PuBu9    ),
        "BuPu"     -> Map(3 -> BuPu3,     4 -> BuPu4,     5 -> BuPu5,     6 -> BuPu6,     7 -> BuPu7,     8 -> BuPu8,     9 -> BuPu9    ),
        "RdPu"     -> Map(3 -> RdPu3,     4 -> RdPu4,     5 -> RdPu5,     6 -> RdPu6,     7 -> RdPu7,     8 -> RdPu8,     9 -> RdPu9    ),
        "PuRd"     -> Map(3 -> PuRd3,     4 -> PuRd4,     5 -> PuRd5,     6 -> PuRd6,     7 -> PuRd7,     8 -> PuRd8,     9 -> PuRd9    ),
        "OrRd"     -> Map(3 -> OrRd3,     4 -> OrRd4,     5 -> OrRd5,     6 -> OrRd6,     7 -> OrRd7,     8 -> OrRd8,     9 -> OrRd9    ),
        "YlOrRd"   -> Map(3 -> YlOrRd3,   4 -> YlOrRd4,   5 -> YlOrRd5,   6 -> YlOrRd6,   7 -> YlOrRd7,   8 -> YlOrRd8,   9 -> YlOrRd9  ),
        "YlOrBr"   -> Map(3 -> YlOrBr3,   4 -> YlOrBr4,   5 -> YlOrBr5,   6 -> YlOrBr6,   7 -> YlOrBr7,   8 -> YlOrBr8,   9 -> YlOrBr9  ),
        "Purples"  -> Map(3 -> Purples3,  4 -> Purples4,  5 -> Purples5,  6 -> Purples6,  7 -> Purples7,  8 -> Purples8,  9 -> Purples9 ),
        "Blues"    -> Map(3 -> Blues3,    4 -> Blues4,    5 -> Blues5,    6 -> Blues6,    7 -> Blues7,    8 -> Blues8,    9 -> Blues9   ),
        "Greens"   -> Map(3 -> Greens3,   4 -> Greens4,   5 -> Greens5,   6 -> Greens6,   7 -> Greens7,   8 -> Greens8,   9 -> Greens9  ),
        "Oranges"  -> Map(3 -> Oranges3,  4 -> Oranges4,  5 -> Oranges5,  6 -> Oranges6,  7 -> Oranges7,  8 -> Oranges8,  9 -> Oranges9 ),
        "Reds"     -> Map(3 -> Reds3,     4 -> Reds4,     5 -> Reds5,     6 -> Reds6,     7 -> Reds7,     8 -> Reds8,     9 -> Reds9    ),
        "Greys"    -> Map(3 -> Greys3,    4 -> Greys4,    5 -> Greys5,    6 -> Greys6,    7 -> Greys7,    8 -> Greys8,    9 -> Greys9   ),
        "PuOr"     -> Map(3 -> PuOr3,     4 -> PuOr4,     5 -> PuOr5,     6 -> PuOr6,     7 -> PuOr7,     8 -> PuOr8,     9 -> PuOr9,      10 -> PuOr10,     11 -> PuOr11     ),
        "BrBG"     -> Map(3 -> BrBG3,     4 -> BrBG4,     5 -> BrBG5,     6 -> BrBG6,     7 -> BrBG7,     8 -> BrBG8,     9 -> BrBG9,      10 -> BrBG10,     11 -> BrBG11     ),
        "PRGn"     -> Map(3 -> PRGn3,     4 -> PRGn4,     5 -> PRGn5,     6 -> PRGn6,     7 -> PRGn7,     8 -> PRGn8,     9 -> PRGn9,      10 -> PRGn10,     11 -> PRGn11     ),
        "PiYG"     -> Map(3 -> PiYG3,     4 -> PiYG4,     5 -> PiYG5,     6 -> PiYG6,     7 -> PiYG7,     8 -> PiYG8,     9 -> PiYG9,      10 -> PiYG10,     11 -> PiYG11     ),
        "RdBu"     -> Map(3 -> RdBu3,     4 -> RdBu4,     5 -> RdBu5,     6 -> RdBu6,     7 -> RdBu7,     8 -> RdBu8,     9 -> RdBu9,      10 -> RdBu10,     11 -> RdBu11     ),
        "RdGy"     -> Map(3 -> RdGy3,     4 -> RdGy4,     5 -> RdGy5,     6 -> RdGy6,     7 -> RdGy7,     8 -> RdGy8,     9 -> RdGy9,      10 -> RdGy10,     11 -> RdGy11     ),
        "RdYlBu"   -> Map(3 -> RdYlBu3,   4 -> RdYlBu4,   5 -> RdYlBu5,   6 -> RdYlBu6,   7 -> RdYlBu7,   8 -> RdYlBu8,   9 -> RdYlBu9,    10 -> RdYlBu10,   11 -> RdYlBu11   ),
        "Spectral" -> Map(3 -> Spectral3, 4 -> Spectral4, 5 -> Spectral5, 6 -> Spectral6, 7 -> Spectral7, 8 -> Spectral8, 9 -> Spectral9,  10 -> Spectral10, 11 -> Spectral11 ),
        "RdYlGn"   -> Map(3 -> RdYlGn3,   4 -> RdYlGn4,   5 -> RdYlGn5,   6 -> RdYlGn6,   7 -> RdYlGn7,   8 -> RdYlGn8,   9 -> RdYlGn9,    10 -> RdYlGn10,   11 -> RdYlGn11   ))

    def apply(name: String, index: Int): Palette = brewer(name)(index)
}
