/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import io.continual.util.data.TypeConvertor;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import io.continual.util.data.exprEval.JsonDataSource;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonEval {
    private JsonEval() {
    }

    public static Object eval(JSONObject root, String expression) {
        String[] parts = expression.split("\\.");
        if (parts.length == 1) {
            return JsonEval.evalToValue(root, parts[0]);
        }
        JSONObject o = JsonEval.evalToContainer(root, parts[0]);
        if (o != null) {
            return JsonEval.eval(o, expression.substring(expression.indexOf(46) + 1));
        }
        return null;
    }

    public static String eval(JSONObject root, String expression, String defval) {
        Object val = JsonEval.eval(root, expression);
        return val == null ? defval : val.toString();
    }

    public static String evalToString(JSONObject root, String expression) {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return "";
        }
        return result.toString();
    }

    public static boolean evalToBoolean(JSONObject root, String expression) {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return TypeConvertor.convertToBooleanBroad(result.toString());
    }

    public static int evalToInt(JSONObject root, String expression, int defaultValue) {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Integer) {
            return (Integer)result;
        }
        return TypeConvertor.convertToInt(result.toString(), defaultValue);
    }

    public static long evalToLong(JSONObject root, String expression, long defaultValue) {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Long) {
            return (Long)result;
        }
        return TypeConvertor.convertToLong(result.toString(), defaultValue);
    }

    public static double evalToDouble(JSONObject root, String expression, double defaultValue) {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return TypeConvertor.convertToDouble(result.toString(), defaultValue);
    }

    public static JSONObject evalToObject(JSONObject root, String expression) throws IllegalArgumentException {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return new JSONObject();
        }
        if (result instanceof JSONObject) {
            return (JSONObject)result;
        }
        throw new IllegalArgumentException(expression + " is not an object.");
    }

    public static JSONArray evalToArray(JSONObject root, String expression) throws IllegalArgumentException {
        Object result = JsonEval.eval(root, expression);
        if (result == null) {
            return new JSONArray();
        }
        if (result instanceof JSONArray) {
            return (JSONArray)result;
        }
        throw new IllegalArgumentException(expression + " is not an array.");
    }

    public static String substitute(String sourceString, JSONObject root) {
        return ExpressionEvaluator.evaluateText(sourceString, new JsonDataSource(root));
    }

    public static void setValue(JSONObject root, String key, Object data2) {
        JsonEval.setValue(root, key, data2, false);
    }

    public static void setValue(JSONObject root, String key, Object data2, boolean appendArray) {
        String[] parts = key.split("\\.");
        LinkedList<String> partList = new LinkedList<String>(Arrays.asList(parts));
        String lastPart = (String)partList.remove(partList.size() - 1);
        AbstractJsonContainer container = JsonEval.getAbstractContainer(new ObjectContainer(root), partList, true, appendArray);
        container.put(lastPart, data2, appendArray);
    }

    public static List<String> splitPath(String key) {
        String[] parts = key.split("\\.");
        return new LinkedList<String>(Arrays.asList(parts));
    }

    public static boolean hasKey(JSONObject root, String key) {
        try {
            List<String> partList = JsonEval.splitPath(key);
            String lastPart = partList.remove(partList.size() - 1);
            JSONObject container = JsonEval.getContainer(root, partList, false);
            return container != null && container.has(lastPart);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static JSONObject getContainer(JSONObject root, String key) {
        List<String> partList = JsonEval.splitPath(key);
        return JsonEval.getContainer(root, partList, false);
    }

    public static JSONObject getContainerOf(JSONObject root, String key) {
        List<String> partList = JsonEval.splitPath(key);
        partList.remove(partList.size() - 1);
        return JsonEval.getContainer(root, partList, false);
    }

    public static JSONObject getContainer(JSONObject root, List<String> parts, boolean withCreate) {
        AbstractJsonContainer ac = JsonEval.getAbstractContainer(new ObjectContainer(root), parts, withCreate, true);
        if (ac instanceof ObjectContainer) {
            return ((ObjectContainer)ac).getObject();
        }
        return null;
    }

    public static AbstractJsonContainer getAbstractContainer(AbstractJsonContainer root, List<String> parts, boolean withCreate, boolean appendArray) {
        AbstractJsonContainer current = root;
        for (String thisPart : parts) {
            if ((current = current.getInnerContainer(thisPart, withCreate, appendArray)) != null) continue;
            throw new IllegalArgumentException("Intermediate part " + thisPart + " is not an object.");
        }
        return current;
    }

    private static Object termToArrayValue(JSONObject root, String term) {
        String key;
        JSONArray a;
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]") && (a = root.optJSONArray(key = term.substring(0, openBrace))) != null) {
            try {
                String indexStr = term.substring(openBrace + 1, term.length() - 1);
                int index = Integer.parseInt(indexStr);
                return a.opt(index);
            }
            catch (NumberFormatException x) {
                return null;
            }
        }
        return null;
    }

    private static Object evalToValue(JSONObject root, String term) {
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]")) {
            return JsonEval.termToArrayValue(root, term);
        }
        Object val = root.opt(term);
        if (val == null || val.equals(JSONObject.NULL)) {
            return null;
        }
        return val;
    }

    private static JSONObject evalToContainer(JSONObject root, String term) {
        int openBrace = term.indexOf(91);
        if (openBrace > -1 && term.endsWith("]")) {
            Object element = JsonEval.termToArrayValue(root, term);
            if (element instanceof JSONObject) {
                return (JSONObject)element;
            }
        } else {
            return root.optJSONObject(term);
        }
        return null;
    }

    private static class ObjectContainer
    implements AbstractJsonContainer {
        private final JSONObject fObject;

        public ObjectContainer(JSONObject obj) {
            this.fObject = obj;
        }

        public JSONObject getObject() {
            return this.fObject;
        }

        @Override
        public AbstractJsonContainer getInnerContainer(String thisPart, boolean withCreate, boolean appendArray) {
            Object next = this.fObject.opt(thisPart);
            if (next == null) {
                if (withCreate) {
                    JSONObject newObj = new JSONObject();
                    this.fObject.put(thisPart, (Object)newObj);
                    return new ObjectContainer(newObj);
                }
            } else {
                if (next instanceof JSONObject) {
                    return new ObjectContainer((JSONObject)next);
                }
                if (next instanceof JSONArray) {
                    return new ArrayContainer((JSONArray)next);
                }
            }
            return null;
        }

        @Override
        public void put(String key, Object val, boolean appendArray) {
            Object existing = this.fObject.opt(key);
            if (existing instanceof JSONArray && appendArray) {
                ((JSONArray)existing).put(val);
            } else {
                this.fObject.put(key, val);
            }
        }
    }

    public static interface AbstractJsonContainer {
        public AbstractJsonContainer getInnerContainer(String var1, boolean var2, boolean var3);

        public void put(String var1, Object var2, boolean var3);
    }

    private static class ArrayContainer
    implements AbstractJsonContainer {
        private final JSONArray fArray;

        public ArrayContainer(JSONArray a) {
            this.fArray = a;
        }

        @Override
        public AbstractJsonContainer getInnerContainer(String thisPart, boolean withCreate, boolean appendArray) {
            Object obj;
            int len = this.fArray.length();
            if (len > 0 && (obj = this.fArray.get(len - 1)) instanceof JSONObject) {
                ObjectContainer wrapper = new ObjectContainer((JSONObject)obj);
                return wrapper.getInnerContainer(thisPart, withCreate, appendArray);
            }
            if (withCreate && appendArray) {
                JSONObject newObj = new JSONObject();
                this.fArray.put((Object)newObj);
                return new ObjectContainer(newObj);
            }
            return null;
        }

        @Override
        public void put(String key, Object val, boolean appendArray) {
            Object obj;
            int len = this.fArray.length();
            if (len > 0 && (obj = this.fArray.get(len - 1)) instanceof JSONObject) {
                ((JSONObject)obj).put(key, val);
                return;
            }
            if (appendArray) {
                JSONObject newObj = new JSONObject();
                this.fArray.put((Object)newObj);
                newObj.put(key, val);
                return;
            }
        }
    }
}

