/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.json.JSONException;
import org.json.JSONTokener;

public class CommentedJsonTokener
extends JSONTokener {
    public CommentedJsonTokener(Reader reader2) {
        super((Reader)new CommentStrippingReader(reader2));
    }

    public CommentedJsonTokener(InputStream inputStream) throws JSONException {
        super((Reader)new CommentStrippingReader(new InputStreamReader(inputStream)));
    }

    public CommentedJsonTokener(String s) {
        super((Reader)new CommentStrippingReader(new StringReader(s)));
    }

    private static class CommentStrippingReader
    extends Reader {
        private final BufferedReader fBase;
        private ReadState fState;
        private StringBuilder fPendingOut;

        public CommentStrippingReader(Reader baseReader) {
            this.fBase = new BufferedReader(baseReader);
            this.fState = ReadState.NORMAL;
            this.fPendingOut = new StringBuilder();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.fPendingOut.length() == 0 && this.fState == ReadState.EOF) {
                return -1;
            }
            if (len < 1) {
                return 0;
            }
            int transferLength = Math.min(this.fPendingOut.length(), len);
            if (transferLength > 0) {
                this.copyOut(transferLength, cbuf, off);
                return transferLength;
            }
            this.process();
            transferLength = Math.min(this.fPendingOut.length(), len);
            if (transferLength > 0) {
                this.copyOut(transferLength, cbuf, off);
                return transferLength;
            }
            return 0;
        }

        @Override
        public void close() throws IOException {
            this.fBase.close();
        }

        private void process() throws IOException {
            String rawLine = this.fBase.readLine();
            if (rawLine == null) {
                this.fState = ReadState.EOF;
                return;
            }
            String line = rawLine + "\n";
            block17: for (char currChar : line.toCharArray()) {
                switch (this.fState.ordinal()) {
                    case 0: {
                        switch (currChar) {
                            case '\"': {
                                this.fState = ReadState.DOUBLE_QUOTED_STRING;
                                this.fPendingOut.append(currChar);
                                continue block17;
                            }
                            case '\'': {
                                this.fState = ReadState.SINGLE_QUOTED_STRING;
                                this.fPendingOut.append(currChar);
                                continue block17;
                            }
                            case '/': {
                                this.fState = ReadState.POSSIBLE_COMMENT;
                                continue block17;
                            }
                        }
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 1: {
                        if (currChar == '\\') {
                            this.fState = ReadState.SINGLE_QUOTED_STRING_ESC;
                        } else if (currChar == '\'') {
                            this.fState = ReadState.NORMAL;
                        }
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 2: {
                        this.fState = ReadState.SINGLE_QUOTED_STRING;
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 3: {
                        if (currChar == '\\') {
                            this.fState = ReadState.DOUBLE_QUOTED_STRING_ESC;
                        } else if (currChar == '\"') {
                            this.fState = ReadState.NORMAL;
                        }
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 4: {
                        this.fState = ReadState.DOUBLE_QUOTED_STRING;
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 5: {
                        if (currChar == '*') {
                            this.fState = ReadState.BLOCK_COMMENT;
                            continue block17;
                        }
                        if (currChar == '/') {
                            this.fState = ReadState.LINE_COMMENT;
                            continue block17;
                        }
                        this.fState = ReadState.NORMAL;
                        this.fPendingOut.append('/');
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 6: {
                        if (currChar != '\n') continue block17;
                        this.fState = ReadState.NORMAL;
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 7: {
                        if (currChar == '*') {
                            this.fState = ReadState.POSSIBLE_BLOCK_COMMENT_END;
                            continue block17;
                        }
                        if (currChar != '\n') continue block17;
                        this.fPendingOut.append(currChar);
                        continue block17;
                    }
                    case 8: {
                        if (currChar == '/') {
                            this.fState = ReadState.NORMAL;
                            this.fPendingOut.append(' ');
                            continue block17;
                        }
                        if (currChar == '\n') {
                            this.fPendingOut.append(currChar);
                            this.fState = ReadState.BLOCK_COMMENT;
                            continue block17;
                        }
                        this.fState = ReadState.BLOCK_COMMENT;
                        continue block17;
                    }
                    case 9: {
                        throw new IllegalStateException("State EOF in process()");
                    }
                }
            }
        }

        private void copyOut(int transferLength, char[] cbuf, int off) {
            if (transferLength <= 0) {
                return;
            }
            this.fPendingOut.getChars(0, transferLength, cbuf, off);
            this.fPendingOut.delete(0, transferLength);
        }
    }

    private static enum ReadState {
        NORMAL,
        SINGLE_QUOTED_STRING,
        SINGLE_QUOTED_STRING_ESC,
        DOUBLE_QUOTED_STRING,
        DOUBLE_QUOTED_STRING_ESC,
        POSSIBLE_COMMENT,
        LINE_COMMENT,
        BLOCK_COMMENT,
        POSSIBLE_BLOCK_COMMENT_END,
        EOF;

    }
}

